// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*! 
 * @file TestPubSubTypes.h
 * This header file contains the declaration of the serialization functions.
 *
 * This file was generated by the tool fastcdrgen.
 */


#ifndef _TEST_PUBSUBTYPES_H_
#define _TEST_PUBSUBTYPES_H_

#include <fastrtps/TopicDataType.h>

#include "Test.h"


typedef MyEnum MyAliasEnum;
typedef MyAliasEnum MyAliasEnum2;
typedef MyAliasEnum2 MyAliasEnum3;
/*!
 * @brief This class represents the TopicDataType of the type BasicStruct defined by the user in the IDL file.
 * @ingroup TEST
 */
class BasicStructPubSubType : public eprosima::fastrtps::TopicDataType {
public:
        typedef BasicStruct type;

	BasicStructPubSubType();
	virtual ~BasicStructPubSubType();
	bool serialize(void *data, eprosima::fastrtps::rtps::SerializedPayload_t *payload);
	bool deserialize(eprosima::fastrtps::rtps::SerializedPayload_t *payload, void *data);
        std::function<uint32_t()> getSerializedSizeProvider(void* data);
	bool getKey(void *data, eprosima::fastrtps::rtps::InstanceHandle_t *ihandle, bool force_md5 = false);
	void* createData();
	void deleteData(void * data);
	MD5 m_md5;
	unsigned char* m_keyBuffer;
};
typedef std::array<uint8_t, 500> MyOctetArray500;
typedef std::array<BasicStruct, 5> BSAlias5;
typedef std::array<MyAliasEnum3, 42> MA3;
typedef std::array<int32_t, 2> MyMiniArray;
typedef std::vector<int32_t> MySequenceLong;
/*!
 * @brief This class represents the TopicDataType of the type ComplexStruct defined by the user in the IDL file.
 * @ingroup TEST
 */
class ComplexStructPubSubType : public eprosima::fastrtps::TopicDataType {
public:
        typedef ComplexStruct type;

	ComplexStructPubSubType();
	virtual ~ComplexStructPubSubType();
	bool serialize(void *data, eprosima::fastrtps::rtps::SerializedPayload_t *payload);
	bool deserialize(eprosima::fastrtps::rtps::SerializedPayload_t *payload, void *data);
        std::function<uint32_t()> getSerializedSizeProvider(void* data);
	bool getKey(void *data, eprosima::fastrtps::rtps::InstanceHandle_t *ihandle, bool force_md5 = false);
	void* createData();
	void deleteData(void * data);
	MD5 m_md5;
	unsigned char* m_keyBuffer;
};


/*!
 * @brief This class represents the TopicDataType of the type CompleteStruct defined by the user in the IDL file.
 * @ingroup TEST
 */
class CompleteStructPubSubType : public eprosima::fastrtps::TopicDataType {
public:
        typedef CompleteStruct type;

	CompleteStructPubSubType();
	virtual ~CompleteStructPubSubType();
	bool serialize(void *data, eprosima::fastrtps::rtps::SerializedPayload_t *payload);
	bool deserialize(eprosima::fastrtps::rtps::SerializedPayload_t *payload, void *data);
        std::function<uint32_t()> getSerializedSizeProvider(void* data);
	bool getKey(void *data, eprosima::fastrtps::rtps::InstanceHandle_t *ihandle, bool force_md5 = false);
	void* createData();
	void deleteData(void * data);
	MD5 m_md5;
	unsigned char* m_keyBuffer;
};
/*!
 * @brief This class represents the TopicDataType of the type KeyedStruct defined by the user in the IDL file.
 * @ingroup TEST
 */
class KeyedStructPubSubType : public eprosima::fastrtps::TopicDataType {
public:
        typedef KeyedStruct type;

	KeyedStructPubSubType();
	virtual ~KeyedStructPubSubType();
	bool serialize(void *data, eprosima::fastrtps::rtps::SerializedPayload_t *payload);
	bool deserialize(eprosima::fastrtps::rtps::SerializedPayload_t *payload, void *data);
        std::function<uint32_t()> getSerializedSizeProvider(void* data);
	bool getKey(void *data, eprosima::fastrtps::rtps::InstanceHandle_t *ihandle, bool force_md5 = false);
	void* createData();
	void deleteData(void * data);
	MD5 m_md5;
	unsigned char* m_keyBuffer;
};

#endif // _TEST_PUBSUBTYPES_H_