//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: _breitroot_6.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/breitrootlist.h>

using namespace std;
using namespace bagel;

void BreitRootList::breitroot6(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[6] = {3.669498773083708e-01,1.488534292310453e+00,3.434007968424071e+00,6.349067925680379e+00,1.054046985844834e+01,
    1.682097007782838e+01};
  constexpr double aw[6] = {1.547120484181300e-01,2.088760748535111e-01,7.164293661048844e-02,7.666245511316917e-03,2.153455980219705e-04,
    8.117349105370354e-07};
  constexpr double x[2304] = {  9.929098614615624e-02, -3.381830948200347e-03,  8.204498930983277e-05, -1.638884360339702e-06,  2.715366444138695e-08,
 -3.424448388823469e-10,  1.880793763192049e-12,  5.927377703887094e-14, -2.638567412320496e-15,  6.488299291422863e-17, -1.141551239526719e-18,  1.222472051386591e-20,
  3.796452612901541e-01, -1.113218042029527e-02,  1.895458797612936e-04, -1.418527487599696e-06, -2.663443067270095e-08,  1.091794940570644e-09, -1.430262831919667e-11,
 -1.372993884893544e-13,  9.859654759575024e-15, -1.761276203129458e-16, -5.343115903697559e-19,  1.028714989527362e-19,  7.899094074747147e-01, -1.755419407266807e-02,
  1.069844735811863e-04,  3.149070157158613e-06, -6.013140282800401e-08, -7.638282677558780e-10,  3.365455652042698e-11,  6.988078679328524e-14, -1.805172517785355e-14,
  1.302900801769696e-16,  8.831114138021192e-18, -1.612207387200944e-19,  1.250274835543662e+00, -1.751043739237669e-02, -1.173298328914905e-04,  3.154979370456679e-06,
  6.444835522315082e-08, -7.799384000435362e-10, -3.652645869619688e-11,  7.459579402205507e-14,  2.007378349373720e-14,  1.374499012709136e-16, -1.036651704245951e-17,
 -1.785662327553853e-19,  1.663100698694710e+00, -1.063337022563794e-02, -1.987505999019337e-04, -1.831926766029806e-06,  2.256998491133837e-08,  1.233487546312200e-09,
  2.015308314882370e-11, -7.611162555034508e-14, -1.199792639206378e-14, -2.734368269464866e-16, -7.887303645764653e-19,  1.289967918793666e-19,  1.932349338060804e+00,
 -2.507315231508865e-03, -6.718764147423586e-05, -1.517845677728683e-06, -2.976025515600891e-08, -4.956354681846836e-10, -6.316347520325552e-12, -3.172079239753980e-14,
  1.396929671130865e-15,  6.323852114202759e-17,  1.691800165043277e-18,  3.383109236446760e-20,  8.696159047867227e-02, -2.797254076867512e-03,  6.476824273281226e-05,
 -1.256346961882662e-06,  2.084937723532776e-08, -2.850614421549631e-10,  2.652823427548606e-12,  4.454314697674738e-15, -9.954499123912749e-16,  2.981288882514669e-17,
 -6.295962060130185e-19,  1.007269471669778e-20,  3.380332681766781e-01, -9.689613055480715e-03,  1.706246237877425e-04, -1.689382453976079e-06, -8.383096520664713e-09,
  7.322293351939300e-10, -1.467060520080015e-11,  7.959607205657682e-14,  3.941372391432982e-15, -1.374050545302092e-16,  1.818984014800029e-18,  1.426402158117068e-20,
  7.216194487365600e-01, -1.656439576442327e-02,  1.386378854171068e-04,  2.108208040140335e-06, -6.748370087664363e-08,  8.471559368119654e-12,  2.862405541107158e-11,
 -3.805016115764120e-13, -9.000292110897324e-15,  3.147101764653331e-16,  3.001677667384173e-19, -1.761552538469510e-19,  1.178618393181455e+00, -1.828159311159267e-02,
 -7.394693495325373e-05,  4.015776493071685e-06,  4.063556535682048e-08, -1.557504952684018e-09, -2.533684678089851e-11,  7.056376522038968e-13,  1.643417631229726e-14,
 -3.462177516194007e-16, -1.123726780643443e-17,  1.666955983159935e-19,  1.617259326986454e+00, -1.230313000753707e-02, -2.176718865873380e-04, -1.248790528874231e-06,
  5.164131441323112e-08,  1.639227481650536e-09,  1.120454416689043e-11, -6.091531456156960e-13, -2.052870476367455e-14, -1.355456164662440e-16,  8.969173909771931e-18,
  2.987563935282008e-19,  1.921117228738705e+00, -3.126575643984307e-03, -8.861311089957377e-05, -2.081726911464332e-06, -4.122384413896956e-08, -6.501847677721246e-10,
 -6.124535998167308e-12,  6.577147156163313e-14,  5.309476904914955e-15,  1.670354735243276e-16,  3.631260446630825e-18,  5.114640409192667e-20,  7.672084688425734e-02,
 -2.334152590376936e-03,  5.151666893021105e-05, -9.649186741204894e-07,  1.577996630100243e-08, -2.226584525637416e-10,  2.462962501218459e-12, -1.428953671158555e-14,
 -2.790015754253219e-16,  1.236682715706174e-17, -2.697554735228465e-19,  6.343542736546077e-21,  3.018745141890635e-01, -8.406993310476491e-03,  1.499711299772123e-04,
 -1.724525075406946e-06,  2.977211943382967e-09,  4.170779850424662e-10, -1.131648146001704e-11,  1.410752439179200e-13,  3.434658453758835e-16, -6.363395265337241e-17,
  1.678035663981560e-18, -1.288593552250282e-20,  6.577146801496927e-01, -1.537221878318648e-02,  1.575734278558805e-04,  1.063074348238802e-06, -6.143202464487235e-08,
  5.452767070297954e-10,  1.558202658950805e-11, -4.975599266038792e-13,  1.067709730577300e-15,  2.154966488741431e-16, -4.094547691493569e-18, -2.086877932007312e-20,
  1.104626326347764e+00, -1.867190340982411e-02, -2.297102673884590e-05,  4.391317943814962e-06,  5.253439508678041e-09, -1.883219639269835e-09, -5.961255612587308e-13,
  9.655813706772032e-13, -1.487920768842961e-15, -5.592922401580984e-16,  2.076884781184065e-18,  3.645977366613785e-19,  1.564492341851966e+00, -1.408784838453111e-02,
 -2.265897161434394e-04, -1.528053487398267e-07,  8.534171730992878e-08,  1.627840867423200e-09, -1.513805538455479e-11, -1.249067408333379e-12, -1.580676949537604e-14,
  4.758248467360061e-16,  2.031876190045759e-17,  1.160333737706970e-19,  1.907017712641118e+00, -3.947651685068221e-03, -1.180035957467744e-04, -2.852270972533467e-06,
 -5.542146308157293e-08, -7.492107263701192e-10, -7.758287972804139e-13,  3.641026943149492e-13,  1.443739536502776e-14,  3.510453933551107e-16,  5.186817403992287e-18,
 -4.775849381552995e-21,  6.814080809857820e-02, -1.964361491844964e-03,  4.131556539768859e-05, -7.450024134577391e-07,  1.188180006764685e-08, -1.690083042949677e-10,
  1.992777694008510e-12, -1.769821024795153e-14,  2.891154167139020e-17,  6.008154371333944e-18, -7.870021180449028e-20,  2.151054842825081e-21,  2.705168815684389e-01,
 -7.288646909691355e-03,  1.297937850899609e-04, -1.623571309746662e-06,  8.921803561679709e-09,  1.924426820556637e-10, -7.471465876736225e-12,  1.271574401589045e-13,
 -8.905168494103307e-16, -9.375108180608915e-18,  1.005610032661377e-18, -1.730765946190861e-20,  5.988054146367898e-01, -1.407637542063014e-02,  1.648459492336467e-04,
  1.831385037145308e-07, -4.786903977090722e-08,  7.619595431630045e-10,  3.069600769409374e-12, -3.706065367561495e-13,  5.958691204898609e-15,  6.452245925284941e-17,
 -2.945988066644730e-18,  4.877575835770710e-20,  1.029903207679786e+00, -1.864628252142629e-02,  2.900806203963243e-05,  4.182149283026721e-06, -3.046636816725351e-08,
 -1.595768905132921e-09,  2.303055811546213e-11,  6.405588838219134e-13, -1.670856481217378e-14, -2.113242465796417e-16,  1.313016255529087e-17,  7.222780041562217e-20,
  1.504539695576954e+00, -1.588240409161359e-02, -2.192545549665872e-04,  1.440715616070040e-06,  1.112249311563848e-07,  8.091672377171935e-10, -5.349597956760841e-11,
 -1.325167374771067e-12,  1.542980720755961e-14,  1.190520390890286e-15,  9.609793292109472e-18, -6.627265280775805e-19,  1.889099510411288e+00, -5.044787883495058e-03,
 -1.580369781416970e-04, -3.855331166440063e-06, -6.944173229103756e-08, -5.802508963894929e-10,  1.805271180465509e-11,  1.064282907187315e-12,  3.017143358808542e-14,
  4.840836117657931e-16, -1.043864485938889e-18, -3.555112475386103e-19,  6.089203517853911e-02, -1.666606065234231e-03,  3.341261062249897e-05, -5.795005927677252e-07,
  8.941080631737272e-09, -1.268425209243344e-10,  1.539026304943578e-12, -1.381816058601420e-14,  1.987153426177311e-16,  3.376572989993888e-18, -8.496956226997034e-20,
 -2.176623216874953e-21,  2.433193420041273e-01, -6.325566338337525e-03,  1.112660395795996e-04, -1.458623382560104e-06,  1.124881998607437e-08,  5.255932899952203e-11,
 -4.314504117580042e-12,  9.943635343497134e-14, -7.026193689919010e-16,  1.394137133467773e-17,  1.183727800436534e-19, -2.275983832485894e-20,  5.451345252844808e-01,
 -1.276066924192069e-02,  1.629553810899552e-04, -4.599700785221047e-07, -3.261585854886200e-08,  7.340842379917808e-10, -4.428151746736718e-12, -1.616725389104126e-13,
  6.615269997627602e-15, -1.833065506802100e-17, -1.514091142442385e-18,  7.637192724358846e-21,  9.560854301309738e-01, -1.822396650768347e-02,  7.532707715166386e-05,
  3.474353167235003e-06, -5.573042678410348e-08, -8.916202798215145e-10,  3.305787774436586e-11,  8.407670434619102e-14, -1.525141687675107e-14,  2.529545944371365e-16,
  7.369649273451658e-18, -2.914463592443114e-19,  1.437655192346765e+00, -1.753631303271735e-02, -1.910112094618130e-04,  3.268931067266521e-06,  1.120245473069605e-07,
 -8.236026371595147e-10, -7.711071791012785e-11, -1.412417499799243e-13,  5.633014652718650e-14,  8.041541313948453e-16, -3.137587648237579e-17, -9.716376627937276e-19,
  1.866071197889866e+00, -6.513697832688937e-03, -2.112412298681975e-04, -5.023407599580518e-06, -7.367228455210775e-08,  3.345397965743684e-10,  6.369249286729941e-11,
  2.257057966028847e-12,  4.106284101679281e-14, -1.005896096689945e-16, -3.494992920627727e-17, -1.272507437577841e-18,  5.471936552059956e-02, -1.424869593195882e-03,
  2.723940631051679e-05, -4.548486711108424e-07,  6.746344398809616e-09, -9.374681568888955e-11,  1.253446570249340e-12, -6.398025599294588e-15,  2.303154431711516e-16,
 -2.486106609606806e-18, -2.115706063510174e-19, -2.600470574344979e-21,  2.196908622718035e-01, -5.502344392662308e-03,  9.486139977765373e-05, -1.274952086331167e-06,
  1.147884623212972e-08, -1.967122479540067e-11, -1.774500564125489e-12,  8.393179390274382e-14, -3.562664493736832e-16, -1.025157380512174e-18, -8.233967789182061e-19,
 -1.659479632753986e-20,  4.966530687628646e-01, -1.148690391078706e-02,  1.547672141145734e-04, -8.712652984307561e-07, -1.924408184655110e-08,  5.963799320769156e-10,
 -6.174304965873085e-12,  2.758519299598276e-14,  4.822849038687481e-15, -8.489253960025395e-17, -2.014497903679855e-18, -1.878564081279615e-20,  8.846360142200183e-01,
 -1.747081444559754e-02,  1.112204254100123e-04,  2.483045295225714e-06, -6.568228599249743e-08, -1.153444633275508e-10,  3.019839167324181e-11, -2.283785172544730e-13,
 -4.181930534834600e-15,  2.702356120015535e-16, -6.190603756112328e-18, -2.510562916316485e-19,  1.364742754238108e+00, -1.887891940200437e-02, -1.418932779662480e-04,
  4.831557748148903e-06,  7.785429577168366e-08, -2.501758198789041e-09, -5.361981689923237e-11,  1.813357937807717e-12,  5.476190877150827e-14, -1.022044487471548e-15,
 -5.022984964122809e-17,  3.240847873903067e-19,  1.836227970286992e+00, -8.463624972002013e-03, -2.780400150083107e-04, -6.041585468871007e-06, -4.586793552737058e-08,
  2.753981327256501e-09,  1.420978376644658e-10,  3.116745578758675e-12, -3.693579636953051e-15, -2.867223029909458e-15, -1.058975416755202e-16, -1.514376909348997e-18,
  4.942356495145473e-02, -1.227084196293295e-03,  2.237215908544486e-05, -3.603197513019760e-07,  5.161450659832381e-09, -6.512644345005174e-11,  1.151417384831773e-12,
 -2.247187392918487e-15, -2.785787756567462e-17, -1.190052011186086e-17, -2.127928067689195e-19,  3.789248351772161e-21,  1.991067249718086e-01, -4.801569718451109e-03,
  8.064558701436044e-05, -1.095978941178553e-06,  1.084217458563998e-08, -3.563621733832367e-11,  3.587215280197220e-13,  6.454858871627270e-14, -1.099957675646031e-15,
 -4.135778172018115e-17, -9.640618655509739e-19,  1.498622506691497e-20,  4.531092548476413e-01, -1.029496469876655e-02,  1.428335115616938e-04, -1.091266633264058e-06,
 -8.659736768993207e-09,  4.714933260771321e-10, -3.818556972814243e-12,  1.163745901741680e-13,  2.047954847696985e-16, -1.710370990026427e-16, -1.851734923351949e-18,
  4.180853559459042e-20,  8.166958497362972e-01, -1.647966149340085e-02,  1.347565150799639e-04,  1.450700789598566e-06, -6.130721213495330e-08,  5.243969700700604e-10,
  2.295160576011679e-11, -2.708408455382501e-13, -7.796508684278393e-16, -1.084994952892583e-16, -1.021414556697910e-17,  9.227735006194325e-20,  1.287348412363345e+00,
 -1.976513315570554e-02, -7.826368604931178e-05,  5.627288195605108e-06,  1.989547489076471e-08, -3.027969337797561e-09,  1.369228900296658e-11,  2.645073446950902e-12,
 -1.060989820087927e-14, -2.307981708761891e-15, -5.740706260396927e-18,  1.437786805576469e-18,  1.797455264240803e+00, -1.098488621736796e-02, -3.524473023827629e-04,
 -6.121637033143506e-06,  4.979589685685341e-08,  7.071272453752661e-09,  2.058633050045488e-10,  4.539295875013457e-13, -1.901011226849419e-13, -7.296424857223832e-15,
 -6.909048005607282e-17,  4.944716143159078e-18,  4.484766202154707e-02, -1.064087727200976e-03,  1.850562658805809e-05, -2.866840868415755e-07,  4.127787774191474e-09,
 -3.879101219886392e-11,  1.002787240644318e-12, -1.110357693662526e-14, -5.372904069913109e-16, -1.346296649483008e-17,  2.352738927321051e-19,  1.735738300968224e-20,
  1.811115801934695e-01, -4.206111376070867e-03,  6.851414754484512e-05, -9.272150943024782e-07,  1.033472773967890e-08, -1.090923213391737e-11,  1.408358597809341e-12,
  2.976244928521256e-16, -2.981237258020372e-15, -5.065283644918206e-17,  9.419756568009285e-19,  7.477699699648670e-20,  4.141293812159685e-01, -9.206343245615763e-03,
  1.292049251109333e-04, -1.158318593390914e-06,  9.583772314148662e-11,  4.136184742269420e-10, -1.464421385471951e-12,  1.590992047446715e-14, -6.501099956139715e-15,
 -1.696613849896016e-16,  3.011191283027947e-18,  1.890759054685615e-19,  7.530212989946975e-01, -1.534767301324231e-02,  1.467151623408200e-04,  5.809172074682503e-07,
 -4.596429193674367e-08,  9.753132545804752e-10,  1.395035216177125e-11, -4.220704102032821e-13, -9.974661507954109e-15, -3.161745955049518e-16,  2.815747432736284e-18,
  4.983813748335150e-19,  1.207465197730232e+00, -2.012008893800080e-02, -1.070187465964679e-05,  5.502511863680245e-06, -3.189869433147710e-08, -1.924271838886091e-09,
  7.090832504256361e-11,  1.054533540762484e-12, -8.284669462983816e-14, -1.316913999962014e-15,  5.250636594872716e-17,  1.097813911091906e-18,  1.747446761014667e+00,
 -1.407230617255549e-02, -4.156148515246984e-04, -3.936283403143265e-06,  2.370522041181849e-07,  1.123006680298487e-08,  9.370412968930053e-11, -9.710731787086643e-12,
 -4.151700853599920e-13, -1.894191156813247e-15,  4.251538390383206e-16,  1.583778201619689e-17,  4.086713035381123e-02, -9.287319429757123e-04,  1.543993528035466e-05,
 -2.256838479520067e-07,  3.555879404086967e-09, -2.073982229281603e-11,  4.009118803343495e-13, -3.255001395779447e-14, -6.418776153925237e-16,  1.367294382938582e-17,
  1.112255071664783e-18,  1.470618195397830e-20,  1.653168534118111e-01, -3.699698961721729e-03,  5.837795060720752e-05, -7.619771882347835e-07,  1.039387152206520e-08,
  1.096260039083567e-11, -9.954257704133376e-14, -1.097242851441845e-13, -3.215465995527864e-15,  6.378150453730124e-17,  4.751829595229653e-18,  6.494238291488888e-20,
  3.792841035065929e-01, -8.227661958157190e-03,  1.155803659387852e-04, -1.092847933365582e-06,  7.911844318707944e-09,  3.559446029337799e-10, -4.578270536427748e-12,
 -2.481209827688223e-13, -8.125816730085042e-15,  1.462009330388771e-16,  1.275012364565288e-17,  1.687442333777093e-19,  6.940066244149643e-01, -1.415699231629919e-02,
  1.499634274798670e-04,  1.494494747370024e-08, -2.429168081844594e-08,  1.123661131594428e-09, -3.617803604749222e-12, -8.536700435118043e-13, -1.333419201371667e-14,
  3.013249649466721e-16,  2.795839836354593e-17,  4.483432274235395e-19,  1.127216487287411e+00, -1.995255748140212e-02,  5.130904265038440e-05,  4.780962052018174e-06,
 -5.264868678048296e-08, -1.948418669851752e-10,  5.959120819885197e-11, -1.863229556044213e-12, -8.204611300530203e-14,  1.606429095319640e-15,  8.862289396417796e-17,
  3.143945411944598e-19,  1.684322385744104e+00, -1.750439204984465e-02, -4.326021568980123e-04,  1.656696769857182e-06,  4.546224318478612e-07,  8.800655281738507e-09,
 -3.438525310521245e-10, -1.960910568983576e-11, -4.015073453052558e-14,  2.472299229182293e-14,  6.773432650654381e-16, -1.549387044362492e-17,  3.738341570476645e-02,
 -8.151078923425198e-04,  1.306017057672638e-05, -1.719280030534658e-07,  3.154589249298861e-09, -2.359761082132869e-11, -6.596079693691529e-13, -3.623046268882573e-14,
  6.679119976130693e-16,  5.466569909848472e-17,  3.976303427594163e-19, -5.703575389397795e-20,  1.513981994856562e-01, -3.266413208667688e-03,  5.023557977676294e-05,
 -5.952640593093229e-07,  1.029433021443893e-08, -3.641365453557728e-11, -3.990881836716720e-12, -1.373393153070698e-13,  2.591641011567657e-15,  2.401443596927289e-16,
  1.724059788161133e-18, -2.465500556312814e-19,  3.481433712153100e-01, -7.352835007575489e-03,  1.034337950968692e-04, -9.180694714106787e-07,  1.325149941088004e-08,
  1.418912897197554e-10, -1.363423327417581e-11, -3.205923408194173e-13,  6.560715864204722e-15,  6.212078905134475e-16,  4.860658042603088e-18, -6.485100318777151e-19,
  6.397720384255661e-01, -1.296154073887196e-02,  1.485132493333050e-04, -2.074389529430038e-07, -4.799426160829482e-09,  7.200940752978970e-10, -3.020710961699837e-11,
 -8.748569950513731e-13,  1.877509127265315e-14,  1.383180460046981e-15,  1.156217305357973e-17, -1.494466988126773e-18,  1.048570454015845e+00, -1.932681733400713e-02,
  1.036900934520998e-04,  3.962963745079663e-06, -4.768731039728597e-08,  3.902792514510531e-10, -1.585754860199850e-11, -2.905299965285793e-12,  3.435745617837690e-14,
  4.405866913607424e-15,  1.637038216975181e-17, -4.359448210789199e-18,  1.607696539256185e+00, -2.075246292953773e-02, -3.652124536303423e-04,  9.713055788208554e-06,
  5.068918751768839e-07, -5.229692999479192e-09, -7.529195450409177e-10, -3.839740544916332e-12,  1.012438817163365e-12,  2.133898793883089e-14, -1.125738660066677e-15,
 -4.930387929703887e-17,  3.432003558659204e-02, -7.180639349119974e-04,  1.128072756609056e-05, -1.263685375273278e-07,  2.462299730823293e-09, -4.740237719078500e-11,
 -1.091314225335421e-12,  1.367826545800885e-14,  2.163197349898779e-15,  6.224775016836151e-18, -2.782215754581301e-18, -4.782201748981076e-20,  1.390949066346148e-01,
 -2.890395796838303e-03,  4.403683323466608e-05, -4.426218151868275e-07,  8.378834386703419e-09, -1.611302187335351e-10, -5.429217215682972e-12,  7.108666713259919e-14,
  9.181012238079503e-15,  2.925554191813593e-17, -1.213194980749028e-17, -2.095265306371321e-19,  3.203224107157522e-01, -6.565739901977806e-03,  9.371843088228446e-05,
 -7.034821329171831e-07,  1.229993500066102e-08, -2.489702580393227e-10, -1.643430559544780e-11,  2.155822951234289e-13,  2.369832684742083e-14,  7.395820908026939e-17,
 -3.195031134453245e-17, -5.601824973424380e-19,  5.902855577121393e-01, -1.178389295544486e-02,  1.458923810025949e-04, -2.149211856319588e-07,  9.140956759743394e-10,
 -1.855770530821337e-10, -3.908358076491231e-11,  4.506686728651450e-13,  5.649874496839719e-14,  1.079645540668663e-16, -7.491752578222293e-17, -1.310177078297498e-18,
  9.732055632625576e-01, -1.831970820633250e-02,  1.467921132867561e-04,  3.218146758344837e-06, -4.903090237847802e-08, -7.020194055270729e-10, -5.964020805199740e-11,
  4.068189135960330e-13,  1.480886399892170e-13,  2.940529203441990e-16, -2.144593647779574e-16, -2.973646967616099e-18,  1.519757732425110e+00, -2.308428285836025e-02,
 -2.065550647887456e-04,  1.603942512025477e-05,  2.334136416228658e-07, -2.061285149866092e-08, -3.718100178387987e-10,  2.922110325594919e-11,  6.592788992284459e-13,
 -4.175825328911494e-14, -1.190740299819512e-15,  5.850530629637172e-17,  3.161950781232558e-02, -6.332941530610553e-04,  9.965474879925383e-06, -9.571357869341469e-08,
  1.321700351010581e-09, -6.178259853197941e-11,  1.326111091031343e-13,  6.401062395272524e-14,  3.597060340256730e-16, -9.320452839710093e-17, -8.247287601376540e-19,
  1.270367471704848e-19,  1.282071170586973e-01, -2.557353127043024e-03,  3.940370454102842e-05, -3.401693204012850e-07,  4.177222020449818e-09, -2.369239877276633e-10,
  1.266387055524864e-13,  2.837101533791567e-13,  1.393740769931259e-15, -4.038409919163310e-16, -3.534516803066962e-18,  5.573061627305259e-19,  2.955095498899605e-01,
 -5.846915401822081e-03,  8.623290304358197e-05, -5.644149201741206e-07,  4.284488176914109e-09, -4.921585424414805e-10, -1.241231961475517e-12,  7.583163065374736e-13,
  3.091897132607424e-15, -1.062539407252731e-15, -8.824521663527529e-18,  1.492112773274325e-18,  5.454675351554817e-01, -1.062739895297773e-02,  1.431337483991939e-04,
 -2.731557485018475e-07, -1.016399868403597e-08, -7.861418534633666e-10, -4.915734872406969e-12,  1.718486084312164e-12,  6.292425451398374e-15, -2.507302907805151e-15,
 -1.733992213687321e-17,  3.598228928489480e-18,  9.024991805947489e-01, -1.700575205615974e-02,  1.800204887083769e-04,  2.256589732344776e-06, -7.387583706817747e-08,
 -1.512304341579109e-09,  7.648464357407832e-12,  3.660259261494575e-12,  1.221383657531647e-14, -6.536688635390268e-15, -2.347670078476908e-17,  1.014254944827122e-17,
  1.425380882224314e+00, -2.393633724207491e-02, -6.029088243545921e-06,  1.629235246164576e-05, -1.961058967964548e-07, -1.890483956316649e-08,  4.849286617965758e-10,
  2.313554294471980e-11, -9.479162439844594e-13, -2.724595772705105e-14,  1.684744007252154e-15,  2.917056252089441e-17,  2.923889334187104e-02, -5.578949076732430e-04,
  8.905213193648435e-06, -8.368561791317097e-08,  2.566825714674786e-10, -3.884278581192380e-11,  1.600621520913812e-12,  2.645097197229303e-14, -2.270945417801121e-15,
 -2.343913995909727e-17,  3.389834903809460e-18,  8.915960643387911e-21,  1.185834576503790e-01, -2.257661288273361e-03,  3.557407275376461e-05, -3.084568360289960e-07,
  8.199799267437249e-11, -1.467146004084153e-10,  6.596677285617569e-12,  1.164743499574113e-13, -9.923660983844317e-15, -9.659237185990732e-17,  1.478601084738612e-17,
  3.170711076284927e-20,  2.734594077414684e-01, -5.183702226605891e-03,  7.956038953020558e-05, -5.692575143323543e-07, -4.227335338159476e-09, -2.905202834835681e-10,
  1.589169462521740e-11,  3.050288279135041e-13, -2.619632543500833e-14, -2.280364295537177e-16,  3.918478178878069e-17,  4.138524441368992e-20,  5.052218853227075e-01,
 -9.499362431456224e-03,  1.383838954015491e-04, -5.522567431967934e-07, -2.339788981606642e-08, -3.844357473392283e-10,  3.328424315471235e-11,  6.453314038753199e-13,
 -6.027428304178309e-14, -4.203529234055779e-16,  9.242530280225307e-17, -1.260468149965131e-19,  8.374968874364916e-01, -1.547943315218700e-02,  1.991329079784824e-04,
  8.755410178852715e-07, -9.463503261316878e-08, -2.577772106514619e-10,  8.374918890081709e-11,  9.145459355313465e-13, -1.448604631985376e-13, -3.567406488233184e-16,
  2.377738744288740e-16, -1.846948943016995e-18,  1.330670276812853e+00, -2.327968757194670e-02,  1.606617582303148e-04,  1.091397136049470e-05, -4.251434125951866e-07,
 -3.343593527982698e-09,  6.563178106840203e-10, -9.692790009838354e-12, -7.506468623785594e-13,  2.968784441568573e-14,  5.206515924530631e-16, -5.455190128808427e-17,
  2.714347562375411e-02, -4.906451318351659e-04,  7.907080684964521e-06, -8.360336836112848e-08, -1.185137461575868e-10,  3.545319511374060e-13,  1.370140573637033e-12,
 -3.633411390354724e-14, -1.098466263787594e-15,  6.686200679182654e-17,  3.372888210755127e-19, -9.581905489831909e-20,  1.100983663754838e-01, -1.988016590844712e-03,
  3.181295928888436e-05, -3.215564627675089e-07, -1.189815161084685e-09,  1.549393929419790e-11,  5.640850276578479e-12, -1.553442209856195e-13, -4.681413296733733e-15,
  2.915531871886248e-16,  1.254700605549946e-18, -4.163598521985278e-19,  2.539522749032858e-01, -4.575992791091168e-03,  7.220268407251383e-05, -6.614513404731708e-07,
 -6.016337704472808e-09,  1.011701813584957e-10,  1.343273409413645e-11, -3.995118593065022e-13, -1.171853452839964e-14,  7.690373815501862e-16,  2.182526520083530e-18,
 -1.091642776301425e-18,  4.693872247761961e-01, -8.425451493152871e-03,  1.294049169320117e-04, -9.424510221631712e-07, -2.273394111428577e-08,  4.226746464915871e-10,
  2.661773911456297e-11, -9.179535998930744e-13, -2.395093695329505e-14,  1.780726926941657e-15,  1.023723389278336e-20, -2.499279482699957e-18,  7.787958684383960e-01,
 -1.386976071440312e-02,  2.007400170478759e-04, -5.709423096862109e-07, -8.016116984401976e-08,  1.580986599372334e-09,  5.352737931225143e-11, -2.477297592570953e-12,
 -3.842775600591311e-14,  4.368262343980224e-15, -2.984431559508484e-17, -5.845810129021561e-18,  1.240787884095146e+00, -2.158629438274688e-02,  2.510403012796258e-04,
  4.304636627440003e-06, -3.661396561179614e-07,  7.463049774135164e-09,  2.138795802200430e-10, -1.661491410760588e-11,  2.250469647323777e-13,  1.580175835907300e-14,
 -7.756427311921479e-16,  1.007925327405701e-18,  2.530102202972776e-02, -4.314234468292268e-04,  6.897428518513068e-06, -8.404560477018255e-08,  1.236753556880391e-10,
  1.919839261902781e-11,  2.009155211729769e-13, -3.702341214714029e-14,  7.869155040762620e-16,  2.494569334996195e-17, -1.609182987723038e-18,  1.023465673012940e-20,
  1.026304935017147e-01, -1.749208070879731e-03,  2.786960451735716e-05, -3.324208577662728e-07,  7.397752155837325e-11,  9.103360805756652e-11,  6.675561864119691e-13,
 -1.561974539744257e-13,  3.431684918959907e-15,  1.045605796294821e-16, -6.981107390271614e-18,  5.030561495658131e-20,  2.367512867991668e-01, -4.031510713282723e-03,
  6.379968054119348e-05, -7.282575544958922e-07, -1.789893163457197e-09,  2.711585134247228e-10,  8.310104726519970e-13, -3.885214279681701e-13,  9.114334339942976e-15,
  2.536454898866132e-16, -1.823099561453272e-17,  1.621929673066920e-19,  4.376766150008479e-01, -7.440812647335277e-03,  1.162784027721858e-04, -1.213431167328707e-06,
 -1.018479681524761e-08,  7.213079879900783e-10, -1.170437041377942e-12, -8.214602488412272e-13,  2.176160984233933e-14,  4.890120474774318e-16, -4.139058282856351e-17,
  5.035811169154723e-19,  7.264580840563910e-01, -1.231031430941527e-02,  1.873960757548395e-04, -1.555146798703052e-06, -4.147659415699738e-08,  2.021837876593475e-09,
 -1.319096616524275e-11, -1.765801301939013e-12,  5.948133499987500e-14,  6.606876102188692e-16, -9.624854222836241e-17,  1.900008226762833e-18,  1.158662278079430e+00,
 -1.945849218439237e-02,  2.729892696530031e-04, -2.194107583651654e-07, -1.975292713010609e-07,  8.153597818958087e-09, -1.039412570147570e-10, -5.582282040816587e-12,
  3.355476616931082e-13, -5.587302123981757e-15, -2.060387984957329e-16,  1.421696469790729e-17,  2.367938588431281e-02, -3.802152018542997e-04,  5.913448861963701e-06,
 -7.902775092904491e-08,  4.886347879386941e-10,  1.485393485569715e-11, -4.263906490365383e-13, -7.994556618863345e-15,  7.788612559305947e-16, -1.646129089994471e-17,
 -3.394157299638516e-19,  2.895306713768680e-20,  9.605452106402013e-02, -1.542049662525661e-03,  2.394709415372013e-05, -3.170380208519121e-07,  1.773084359511480e-09,
  6.872659288105495e-11, -1.939620899753120e-12, -3.142359827218042e-14,  3.307280985794482e-15, -7.213555302306052e-17, -1.381474640479288e-18,  1.242769025113609e-19,
  2.215905369643613e-01, -3.556153000722476e-03,  5.506270010017421e-05, -7.154697552830823e-07,  3.141111365847919e-09,  1.974814047510698e-10, -5.459536675048910e-12,
 -6.702225498348305e-14,  8.309831030798469e-15, -1.926104998949579e-16, -3.140424996704490e-18,  3.176020855178445e-19,  4.096790801224919e-01, -6.570546578112321e-03,
  1.011928976471947e-04, -1.268801817998113e-06,  2.536227478069260e-09,  5.022389732891868e-10, -1.369407814879625e-11, -9.890572282268722e-14,  1.775473060880901e-14,
 -4.589350468916437e-16, -5.146971323874544e-18,  6.906168422727789e-19,  6.800848741271063e-01, -1.089418040697538e-02,  1.659947959320205e-04, -1.925362667533927e-06,
 -7.087375531159505e-09,  1.327140952864575e-09, -3.659914352635109e-11, -3.179100921179717e-14,  3.792000238370476e-14, -1.208820221212315e-15, -2.024847283384184e-18,
  1.445046681644425e-18,  1.085118614581605e+00, -1.732750940432634e-02,  2.562372802295170e-04, -2.244884994436354e-06, -6.670440924662508e-08,  4.779754885045919e-09,
 -1.456205751742104e-10,  1.322697325105606e-12,  9.905103962322851e-14, -5.464399072377060e-15,  1.141029194500014e-16,  1.263789342483286e-18,  2.224734675602659e-02,
 -3.365492667986558e-04,  5.019924989949159e-06, -6.942192164138392e-08,  6.773103250325118e-10,  4.161862889811521e-12, -3.971425267896996e-13,  6.808466442428421e-15,
  1.709606343030943e-16, -1.311715134252338e-17,  3.033902819708463e-19,  2.042670106770396e-21,  9.024617802041496e-02, -1.365121147909717e-03,  2.034965001460032e-05,
 -2.803183240436511e-07,  2.661806938252127e-09,  2.101912216825936e-11, -1.753358647105813e-12,  3.063389069571425e-14,  6.897652031873514e-16, -5.567324124737299e-17,
  1.323055270144454e-18,  7.373266514872400e-21,  2.081940945388248e-01, -3.148886917749037e-03,  4.688525694919185e-05, -6.409175754730320e-07,  5.755246767018623e-09,
  6.727196489266323e-11, -4.700269499892686e-12,  8.493814547319255e-14,  1.556590378159262e-15, -1.395656068855394e-16,  3.493513354718838e-18,  1.177847998578102e-20,
  3.849213845601912e-01, -5.820569321369159e-03,  8.648415940454458e-05, -1.165707156819353e-06,  9.335901218760213e-09,  1.890622259906065e-10, -1.100454378897082e-11,
  2.099294459016093e-13,  2.638058997382081e-15, -2.957156656901159e-16,  8.117922931744935e-18, -3.736905357382349e-21,  6.390172971669452e-01, -9.658853261741965e-03,
  1.429353884696494e-04, -1.872479932734735e-06,  1.114337060104518e-08,  5.367992476270883e-10, -2.662166036641969e-11,  5.564924219547564e-13,  2.663237373610647e-15,
 -6.123574843225015e-16,  2.007661494477855e-17, -1.503701085972709e-19,  1.019720271296126e+00, -1.539739614381937e-02,  2.254800501431179e-04, -2.720259771579734e-06,
 -1.861511399707079e-09,  1.937770899701481e-09, -8.741849642351416e-11,  2.227736559370796e-12, -1.744843037510117e-14, -1.326382595910238e-15,  7.202388150713867e-17,
 -1.766520613577800e-18,  2.097645703821005e-02, -2.995345791855632e-04,  4.253146369349948e-06, -5.836575621290336e-08,  6.823237586868302e-10, -2.816527442116679e-12,
 -1.843736296374426e-13,  7.009374073757195e-15, -9.458274468619514e-17, -2.542882612912038e-18,  1.794951559621170e-19, -4.591895277163047e-21,  8.509103107937240e-02,
 -1.215036562537815e-03,  1.724869037096479e-05, -2.363363637982437e-07,  2.737216289748408e-09, -9.764523644924295e-12, -8.163751762715318e-13,  3.051341197600221e-14,
 -4.235760610243681e-16, -1.028512924909528e-17,  7.590619818812451e-19, -1.985964846991231e-20,  1.963023010858153e-01, -2.802936798018803e-03,  3.977363762160801e-05,
 -5.433394988438028e-07,  6.178103404974456e-09, -1.506669950905666e-11, -2.193953478817850e-12,  7.997289603250850e-14, -1.166941439621668e-15, -2.330716422182657e-17,
  1.887992308847012e-18, -5.157388020402533e-20,  3.629381189991396e-01, -5.181906233459798e-03,  7.347585992756442e-05, -9.983672377905144e-07,  1.096759067820586e-08,
 -2.668366895191121e-12, -5.124130531530667e-12,  1.816966800324025e-13, -2.866234702149094e-15, -3.974861563842113e-17,  3.934147544580744e-18, -1.160939609493882e-19,
  6.025316445835074e-01, -8.601601541573365e-03,  1.217916567635703e-04, -1.637751770317610e-06,  1.673430355837878e-08,  7.918922622664823e-11, -1.216992701204633e-11,
  4.235370385286331e-13, -7.566298626635313e-15, -4.095545434142462e-17,  7.814207179346201e-18, -2.683787970655545e-19,  9.615339845236657e-01, -1.372233050330033e-02,
  1.936222228471014e-04, -2.534319742904414e-06,  2.051355070294380e-08,  4.973622026592171e-10, -3.689402626947286e-11,  1.322068663099380e-12, -3.002702237583545e-14,
  2.415449089504062e-16,  1.399651674439070e-17, -7.791710028652364e-19,  1.984218803756154e-02, -2.681309117801683e-04,  3.615788665669360e-06, -4.807973849873213e-08,
  5.956647774209027e-10, -5.272627655766713e-12, -3.650176655139256e-14,  3.541359738417161e-15, -1.002914203235962e-16,  1.220544666933189e-18,  2.846039945583006e-20,
 -2.022338289603571e-21,  8.048992673584202e-02, -1.087667100145065e-03,  1.466625517788524e-05, -1.949074919906274e-07,  2.406466673011468e-09, -2.080900317171186e-11,
 -1.748292294135380e-13,  1.533721427324018e-14, -4.336391756724312e-16,  5.438494347197455e-18,  1.142667485302426e-19, -8.508604397567064e-21,  1.856879612949394e-01,
 -2.509185587013959e-03,  3.382933487960411e-05, -4.490816402382339e-07,  5.508067176287997e-09, -4.542672034106973e-11, -5.233281836844224e-13,  3.978414863493283e-14,
 -1.123732206574197e-15,  1.486493001830383e-17,  2.545578426744215e-19, -2.094406914323704e-20,  3.433143929696579e-01, -4.639077465179399e-03,  6.252919484268124e-05,
 -8.284594005341354e-07,  1.004056344408408e-08, -7.542437333793348e-11, -1.371457120492448e-12,  8.864152624485763e-14, -2.512233021416676e-15,  3.613350878318103e-17,
  4.154041467174295e-19, -4.275767215014955e-20,  5.699559126010647e-01, -7.701293366149614e-03,  1.037558167220580e-04, -1.369662761180770e-06,  1.621690684698386e-08,
 -9.765341954335990e-11, -3.608746212229830e-12,  1.985589669032150e-13, -5.726021350010424e-15,  9.404191568539483e-17,  3.347828666716320e-19, -8.104685664293417e-20,
  9.095585572241198e-01, -1.228892196293463e-02,  1.653820724841955e-04, -2.163872455873530e-06,  2.408722713220609e-08, -4.192120837801436e-11, -1.156051583578689e-11,
  5.570241602237585e-13, -1.718912839084599e-14,  3.610799264452812e-16, -3.232282957134380e-18, -1.183938336491179e-19,  1.882408090319011e-02, -2.413585898779636e-04,
  3.092459151410591e-06, -3.941256331320352e-08,  4.877987103307931e-10, -5.276483927853033e-12,  2.509948139163765e-14,  1.122710067332858e-15, -5.107610082659871e-17,
  1.236798640712197e-18, -1.474089980377368e-20, -2.441115058097122e-22,  7.635998672253548e-02, -9.790705512572938e-04,  1.254425014448477e-05, -1.598411378995992e-07,
  1.975842674801459e-09, -2.122192073244279e-11,  9.271958341664950e-14,  4.922435187461795e-15, -2.192254395317070e-16,  5.324610413102634e-18, -6.524148976835851e-20,
 -9.632297043894510e-22,  1.761603785445836e-01, -2.258680507951978e-03,  2.893781099925394e-05, -3.685908942225401e-07,  4.545399908208782e-09, -4.815380101513618e-11,
  1.734877689992109e-13,  1.300364843688423e-14, -5.601506937579860e-16,  1.369542574937179e-17, -1.763156354764165e-19, -2.060221760624072e-21,  3.256992814846899e-01,
 -4.176001607402856e-03,  5.349795003820783e-05, -6.809703114136580e-07,  8.362295950208375e-09, -8.639589724690506e-11,  1.870264229801785e-13,  2.956704835384334e-14,
 -1.221342804400600e-15,  3.027206376586654e-17, -4.215312963796276e-19, -3.000238313864890e-21,  5.407127407210840e-01, -6.932750642086666e-03,  8.880134737360772e-05,
 -1.128964966000662e-06,  1.375423457939718e-08, -1.351652932855864e-10, -1.169907420519258e-13,  6.716893876009855e-14, -2.654971211151524e-15,  6.779532267362146e-17,
 -1.069896304280078e-18, -5.476329602831413e-22,  8.628935976218881e-01, -1.106331890690406e-02,  1.416635899033228e-04, -1.795930838040761e-06,  2.146355250124549e-08,
 -1.834128225559261e-10, -1.923884323982396e-12,  1.844351459652204e-13, -7.100868587505500e-15,  1.963567246514789e-16, -3.899756195428693e-18,  3.919713961716363e-20,
  1.790530759441293e-02, -2.183858047995901e-04,  2.662982878078054e-06, -3.241144180482296e-08,  3.900435053854821e-10, -4.444763809585662e-12,  3.947653724628227e-14,
  7.821995117236001e-17, -1.796075732015695e-17,  6.150966689950153e-19, -1.349150312424918e-20,  1.641870647467039e-22,  7.263298200099919e-02, -8.858827852691987e-04,
  1.080232085135191e-05, -1.314675743401560e-07,  1.581406541295590e-09, -1.797736860461416e-11,  1.573419536461461e-13,  4.391041739664784e-16, -7.726695615904314e-17,
  2.626974665154920e-18, -5.789047258461486e-20,  7.212476056006191e-22,  1.675622999608155e-01, -2.043705272737937e-03,  2.492029222283029e-05, -3.032501839535583e-07,
  3.644734140715003e-09, -4.124143527331727e-11,  3.506618978912282e-13,  1.553071340478719e-15, -1.979425304029184e-16,  6.654788859969618e-18, -1.480201732146076e-19,
  1.923974059569776e-21,  3.098025298603987e-01, -3.778558658814083e-03,  4.607345904792481e-05, -5.605392789763367e-07,  6.727340903976844e-09, -7.550009759576749e-11,
  6.081192027755023e-13,  4.651964463239455e-15, -4.317190788868989e-16,  1.432304664281857e-17, -3.240979685313309e-19,  4.509112760080923e-21,  5.143217710228578e-01,
 -6.272992907282495e-03,  7.648585971218395e-05, -9.301834593740601e-07,  1.113408928597659e-08, -1.230376654798079e-10,  8.842177283465342e-13,  1.337439849034964e-14,
 -9.301814928443062e-16,  3.053499189629354e-17, -7.144809527682096e-19,  1.109432009017274e-20,  8.207783113028678e-01, -1.001066476706776e-02,  1.220475899872800e-04,
 -1.483001130776522e-06,  1.764325034690748e-08, -1.877463498161943e-10,  9.285554719110576e-13,  4.392320420319602e-14, -2.378265565501982e-15,  7.883214854847111e-17,
 -1.999168889994466e-18,  3.802955616459918e-20,  1.707205012218408e-02, -1.985380209861565e-04,  2.308722683044875e-06, -2.683062600096341e-08,  3.105387733740072e-10,
 -3.518894013080310e-12,  3.629089796280367e-14, -2.318432271061642e-16, -3.746440251523901e-18,  2.218276878784449e-19, -6.447633535554848e-21,  1.319684136950786e-22,
  6.925286937555301e-02, -8.053705082660968e-04,  9.365326006997095e-06, -1.088361464847689e-07,  1.259490846438165e-09, -1.426004295951413e-11,  1.464195870233165e-13,
 -9.039018717881055e-16, -1.661668991856635e-17,  9.464963361960915e-19, -2.744580485842709e-20,  5.646522035936314e-22,  1.597644772412494e-01, -1.857967262456318e-03,
  2.160546118027323e-05, -2.510714296446059e-07,  2.904691433566894e-09, -3.283482683252768e-11,  3.343051504882297e-13, -1.924345730495658e-15, -4.461395028533394e-17,
  2.391383014431449e-18, -6.912118246994941e-20,  1.436287546323501e-21,  2.953853082255262e-01, -3.435156518736364e-03,  3.994561614159406e-05, -4.641673527695582e-07,
  5.367497002026077e-09, -6.050676275911402e-11,  6.068606285255582e-13, -3.034479245274915e-15, -1.031098042719694e-16,  5.112356413937258e-18, -1.474092925926732e-19,
  3.118019382058835e-21,  4.903869180902237e-01, -5.702905463382740e-03,  6.631528789448614e-05, -7.704929733848100e-07,  8.902163805389246e-09, -9.984490639336340e-11,
  9.731956898879633e-13, -3.416487479136499e-15, -2.361683322474785e-16,  1.071199020630136e-17, -3.096858317381562e-19,  6.772555543446408e-21,  7.825821161650278e-01,
 -9.100945095730733e-03,  1.058261716461287e-04, -1.229245513960720e-06,  1.417570890587970e-08, -1.571578756221011e-10,  1.426700390647377e-12,  6.982891104426780e-16,
 -6.322405968530814e-16,  2.622740158644357e-17, -7.766502539242021e-19,  1.832943095502008e-20,  1.631291104170378e-02, -1.812766959530776e-04,  2.014391273434999e-06,
 -2.238007713109829e-08,  2.483005363207640e-10, -2.733504316801328e-12,  2.902543736088097e-14, -2.637700015145631e-16,  7.854262555830979e-19,  5.713067464874870e-20,
 -2.316001783630801e-21,  6.011004138760253e-23,  6.617341758550400e-02, -7.353499344445916e-04,  8.171384850388140e-06, -9.078431721345667e-08,  1.007179669662846e-09,
 -1.108477001278289e-11,  1.175294898690428e-13, -1.059789525205076e-15,  2.769571632534796e-18,  2.463631251431824e-19, -9.836156194214320e-21,  2.552352516572424e-22,
  1.526602671884991e-01, -1.696432101982925e-03,  1.885114036608754e-05, -2.094343735380308e-07,  2.323307052712177e-09, -2.555617126700059e-11,  2.702122260370105e-13,
 -2.400325358850315e-15,  4.559959910134268e-18,  6.328704575620297e-19, -2.465294858561448e-20,  6.399185647561823e-22,  2.822504814300426e-01, -3.136498656495717e-03,
  3.485342549424616e-05, -3.872109060437363e-07,  4.294792110058733e-09, -4.719918702824529e-11,  4.966346943091059e-13, -4.294546215881422e-15,  2.501665230874682e-18,
  1.381167616089376e-18, -5.207107019736973e-20,  1.354833005092625e-21,  4.685810118494344e-01, -5.207089164040919e-03,  5.786207568722479e-05, -6.428085513574442e-07,
  7.127913259785580e-09, -7.820640502050557e-11,  8.156245625194879e-13, -6.694353061790559e-15, -1.409538628795895e-17,  2.953262595394580e-18, -1.071676004876280e-19,
  2.812065050491056e-21,  7.477832755032353e-01, -8.309710608274803e-03,  9.233833553215627e-05, -1.025744152063675e-06,  1.136776109655260e-08, -1.242763044508873e-10,
  1.270074075285979e-12, -9.098888076821367e-15, -9.075217701031252e-17,  7.265344225706555e-18, -2.544545164126008e-19,  6.876385802887164e-21,  1.561842379675308e-02,
 -1.661721929365078e-04,  1.767978993935394e-06, -1.880922109863887e-08,  2.000191029869787e-10, -2.121307751860814e-12,  2.219906644033656e-14, -2.193099099157064e-16,
  1.681887923680960e-18,  3.582588725133218e-21, -6.428667065829607e-22,  2.121743285291398e-23,  6.335622613475346e-02, -6.740784522025708e-04,  7.171815837519233e-06,
 -7.629957413332757e-08,  8.113659354463579e-10, -8.604183312354213e-12,  8.999671613682076e-14, -8.869537253049171e-16,  6.708704536022841e-18,  1.872619392351674e-20,
 -2.742358034289301e-21,  8.983473968946338e-23,  1.461610836970781e-01, -1.555080557093290e-03,  1.654517841281522e-05, -1.760204333949388e-07,  1.871744262228777e-09,
 -1.984566567164941e-11,  2.073861876559405e-13, -2.034529976448579e-15,  1.497967902375144e-17,  6.158339511474601e-20, -6.919418339363587e-21,  2.239423170125729e-22,
  2.702342732514474e-01, -2.875156928500738e-03,  3.059003070582049e-05, -3.254387443195311e-07,  3.460458212432689e-09, -3.667980031198628e-11,  3.826916461122813e-13,
 -3.724498184848934e-15,  2.610191795255419e-17,  1.732340467682191e-19, -1.472516661400410e-20,  4.690472082124327e-22,  4.486321836657645e-01, -4.773220856893215e-03,
  5.078430761334100e-05, -5.402750271157224e-07,  5.744414907197284e-09, -6.085785051802578e-11,  6.331400719047323e-13, -6.072489056902034e-15,  3.852194674049877e-17,
  4.691848918798855e-19, -3.044695271866812e-20,  9.528156986736424e-22,  7.159480190654395e-01, -7.617326197315781e-03,  8.104380786909508e-05, -8.621780245877353e-07,
  9.165531321650498e-09, -9.699592066029805e-11,  1.002838040513560e-12, -9.301076417271471e-15,  4.417356049886411e-17,  1.418737618552547e-18, -7.142076607607404e-20,
  2.208551477389436e-21,  1.498066596914114e-02, -1.528798446392759e-04,  1.560158439495592e-06, -1.592135542630511e-08,  1.624547449158521e-10, -1.656156561172581e-12,
  1.680463724050344e-14, -1.669258289074969e-16,  1.519316547057171e-18, -9.100423431493688e-21, -1.001274923971706e-22,  6.052573623108577e-24,  6.076915784489614e-02,
 -6.201579695725940e-04,  6.328791446988435e-06, -6.458503827136159e-08,  6.589956593984352e-10, -6.717991818893302e-12,  6.815499307518423e-14, -6.764657127953980e-16,
  6.133696941244434e-18, -3.579085650757597e-20, -4.439504857982947e-22,  2.567108623876469e-23,  1.401927878501940e-01, -1.430687496749620e-03,  1.460034797058781e-05,
 -1.489957835540871e-07,  1.520272319538897e-09, -1.549729004480383e-11,  1.571750926042703e-13, -1.557688111066652e-15,  1.402252262119244e-17, -7.766592858647430e-20,
 -1.189493930212609e-21,  6.414106831393608e-23,  2.591996118716390e-01, -2.645169178065183e-03,  2.699428488345752e-05, -2.754748694233525e-07,  2.810761250861636e-09,
 -2.864970376640207e-11,  2.904198568621999e-13, -2.870817061286431e-15,  2.552018530519718e-17, -1.279264061318030e-19, -2.731341387074066e-21,  1.345549097172549e-22,
  4.303128785737361e-01, -4.391404532754464e-03,  4.481482769294138e-05, -4.573312027121145e-07,  4.666200244735038e-09, -4.755463084987817e-11,  4.816239680119215e-13,
 -4.739055403819599e-15,  4.116222466601038e-17, -1.653369311745292e-19, -6.151802559652547e-21,  2.726224926512018e-22,  6.867132250384597e-01, -7.008006619116569e-03,
  7.151754722940765e-05, -7.298263993459388e-07,  7.446166146279737e-09, -7.586179825552246e-11,  7.668498916024642e-13, -7.470631887281164e-15,  6.149245910648284e-17,
 -9.665778861169668e-20, -1.570634986760802e-20,  6.195707872271944e-22,  1.439295833646857e-02, -1.411209969844495e-04,  1.383671636368375e-06, -1.356664566541974e-08,
  1.330131812833485e-10, -1.303758286906616e-12,  1.275901065720726e-14, -1.239232997971981e-16,  1.165881171765532e-18, -9.648653938028257e-21,  3.808622667777844e-23,
  1.197313556805757e-24,  5.838511844855658e-02, -5.724581373602784e-04,  5.612871912482071e-06, -5.503316930404075e-08,  5.395680724782841e-10, -5.288653255738872e-12,
  5.175392675200022e-14, -5.025348337686382e-16,  4.722152715016347e-18, -3.885389323838885e-20,  1.445451753577789e-22,  5.164417607843384e-24,  1.346928740710480e-01,
 -1.320645290857875e-03,  1.294874200727252e-05, -1.269599888610634e-07,  1.244765966667237e-09, -1.220056517124540e-11,  1.193816777402177e-13, -1.158641152022912e-15,
  1.086253423908776e-17, -8.839522715743340e-20,  2.901696108456282e-22,  1.325707403595556e-23,  2.490309324874544e-01, -2.441714381932269e-03,  2.394066665023060e-05,
 -2.347336644266814e-07,  2.301413819943297e-09, -2.255671413591156e-11,  2.206810877225934e-13, -2.140014725550433e-15,  1.998475679993364e-17, -1.595055981311284e-19,
  3.985503195492337e-22,  2.881862583022560e-23,  4.134312419152096e-01, -4.053637018590823e-03,  3.974533980130492e-05, -3.896952232279539e-07,  3.820690490457305e-09,
 -3.744585458741172e-11,  3.662468226245632e-13, -3.546450022232298e-15,  3.288855212774126e-17, -2.531982772380845e-19,  2.497736199344016e-22,  6.085776486792114e-23,
  6.597727275844170e-01, -6.468981701532104e-03,  6.342744791974898e-05, -6.218928512715252e-07,  6.097154073198888e-09, -5.975163769603425e-11,  5.840815254965081e-13,
 -5.638512030673679e-15,  5.150489618513779e-17, -3.640669148309145e-19, -1.048931586980112e-21,  1.439060403061308e-22,  1.384963062334506e-02, -1.306685224813730e-04,
  1.232831517739831e-06, -1.163150623448573e-08,  1.097395906551666e-10, -1.035272976686419e-12,  9.761776747324054e-15, -9.180952081260839e-17,  8.536893923278717e-19,
 -7.584989642657502e-21,  5.607490256680212e-23, -7.734135747251325e-26,  5.618110644930355e-02, -5.300576145252151e-04,  5.000988145619327e-06, -4.718327056370763e-08,
  4.451591365034357e-10, -4.199579713123495e-12,  3.959800622183898e-14, -3.723886282827594e-16,  3.461278522677054e-18, -3.069908347849923e-20,  2.249788246598352e-22,
 -2.341794103157484e-25,  1.296082785713145e-01, -1.222828443399417e-03,  1.153714305126510e-05, -1.088505103975961e-07,  1.026969351710352e-09, -9.688268316771978e-12,
  9.134852994281464e-14, -8.589305190612862e-16,  7.977681025505163e-18, -7.052208250945956e-20,  5.082440905946774e-22, -1.947472693149457e-25,  2.396301266446801e-01,
 -2.260862792756147e-03,  2.133079044775295e-05, -2.012514887225360e-07,  1.898740961155916e-09, -1.791229676294027e-11,  1.688831697099179e-13, -1.587561039118353e-15,
  1.472663722083605e-17, -1.294443586447806e-19,  9.056431857170545e-22,  7.374592332410211e-25,  3.978243982584754e-01, -3.753394417237742e-03,  3.541252884011979e-05,
 -3.341096552163438e-07,  3.152208752888580e-09, -2.973686537160454e-11,  2.803466013719903e-13, -2.634173308582685e-15,  2.438160674197062e-17, -2.121493457250005e-19,
  1.403380025544081e-21,  4.484100355464428e-24,  6.348666035771305e-01, -5.989840676709787e-03,  5.651295263172005e-05, -5.331874896895973e-07,  5.030423619912457e-09,
 -4.745413598215579e-11,  4.473044826157872e-13, -4.199056524326474e-15,  3.868765725205200e-17, -3.293272366509532e-19,  1.897845354074078e-21,  1.848835708947735e-23,
  1.334583800768803e-02, -1.213358285076935e-04,  1.103144136005344e-06, -1.002940867390295e-08,  9.118367206177879e-11, -8.289885232520108e-13,  7.535525653194799e-15,
 -6.844108872879396e-17,  6.191840696218866e-19, -5.511385530741473e-21,  4.608471090075743e-23, -2.970882772857346e-25,  5.413746880028753e-02, -4.921994876786716e-04,
  4.474910543492453e-06, -4.068435377252770e-08,  3.698870601607864e-10, -3.362794317024184e-12,  3.056774942826478e-14, -2.776233157493879e-16,  2.511330682444932e-18,
 -2.234072023879288e-20,  1.863464201847506e-22, -1.185545412629078e-24,  1.248936623164521e-01, -1.135490778676632e-03,  1.032349642741828e-05, -9.385769191888516e-08,
  8.533192156319352e-10, -7.757864408301425e-12,  7.051830603455765e-14, -6.404336396775243e-16,  5.791885078716761e-18, -5.146957533822773e-20,  4.273250892830144e-22,
 -2.650327428578044e-24,  2.309133679432107e-01, -2.099385950331736e-03,  1.908690385726351e-05, -1.735315853959068e-07,  1.577684243882799e-09, -1.434332711094512e-11,
  1.303778408882548e-13, -1.183973979583546e-15,  1.070325570196979e-17, -9.494298032108842e-20,  7.820118881520292e-22, -4.633327118186733e-24,  3.833531824200213e-01,
 -3.485316992487045e-03,  3.168731797944185e-05, -2.880902193624834e-07,  2.619207444420111e-09, -2.381213176360171e-11,  2.164423548865259e-13, -1.965270937962207e-15,
  1.775410079859617e-17, -1.569918182423298e-19,  1.274854734600315e-21, -6.910881294057765e-24,  6.117727669910261e-01, -5.562030309372842e-03,  5.056808964489450e-05,
 -4.597476815752946e-07,  4.179849015482880e-09, -3.800022305033525e-11,  3.453904919205504e-13, -3.135258415478541e-15,  2.828410671148804e-17, -2.484701988399108e-19,
  1.956534499828864e-21, -8.387655935963344e-24,  1.287741619467175e-02, -1.129684843777665e-04,  9.910278738695944e-07, -8.693895264711489e-09,  7.626804098991965e-11,
 -6.690643893471496e-13,  5.869130219478934e-15, -5.147154066549555e-17,  4.508174879943243e-19, -3.926309464993071e-21,  3.344460074166797e-23, -2.621463372252295e-25,
  5.223731301594604e-02, -4.582573079984568e-04,  4.020110281889492e-06, -3.526683618458256e-08,  3.093817413542465e-10, -2.714063041677796e-12,  2.380812748556090e-14,
 -2.087927766449188e-16,  1.828656431807713e-18, -1.592342050185029e-20,  1.355304276346864e-22, -1.058766071692616e-24,  1.205100548052172e-01, -1.057187096977431e-03,
  9.274284650403285e-06, -8.135962784772608e-08,  7.137352020770853e-10, -6.261267160741704e-12,  5.492455908901540e-14, -4.816714460991788e-16,  4.218287114275966e-18,
 -3.671914344239662e-20,  3.120733180233685e-22, -2.422606329653757e-24,  2.228086046162022e-01, -1.954611856020015e-03,  1.714703743457347e-05, -1.504241706547637e-07,
  1.319610504749718e-09, -1.157632365188901e-11,  1.015484739775702e-13, -8.905285923712657e-16,  7.797951268861275e-18, -6.784040010486508e-20,  5.751431182536486e-22,
 -4.416748643318009e-24,  3.698979769391592e-01, -3.244968803914360e-03,  2.846682902789304e-05, -2.497282184170831e-07,  2.190764600134675e-09, -1.921853316115654e-11,
  1.685855179277571e-13, -1.478352363280028e-15,  1.294257256993739e-17, -1.124864331862330e-19,  9.495369782599528e-22, -7.152168180312831e-24,  5.903003267874374e-01,
 -5.178471537251437e-03,  4.542868440827972e-05, -3.985278521262769e-07,  3.496122909552925e-09, -3.066976783718932e-11,  2.690327745564140e-13, -2.359009376351608e-15,
  2.064391884017881e-17, -1.790617619032962e-19,  1.498065878301667e-21, -1.081830007384066e-23,  1.244076597302959e-02, -1.054377930261484e-04,  8.936047995855792e-07,
 -7.573465832301574e-09,  6.418650954189312e-11, -5.439914552137110e-13,  4.610360355694205e-15, -3.907005833472652e-17,  3.309607108162313e-19, -2.798284987117349e-21,
  2.347697645815764e-23, -1.912924446347460e-25,  5.046603887511537e-02, -4.277090151276239e-04,  3.624913019936437e-06, -3.072180778689595e-08,  2.603729445760315e-10,
 -2.206704367631078e-12,  1.870194640176067e-14, -1.584875279177932e-16,  1.342525144690418e-18, -1.135045087729451e-20,  9.520365232489968e-23, -7.749216364430456e-25,
  1.164237737263984e-01, -9.867130194441782e-04,  8.362575359515150e-06, -7.087437165871166e-08,  6.006732680776989e-10, -5.090806273447297e-12,  4.314485014214728e-14,
 -3.656247439681518e-16,  3.097088323522660e-18, -2.618172763565771e-20,  2.195002490749680e-22, -1.783188778577350e-24,  2.152535621203321e-01, -1.824313758496244e-03,
  1.546139655904496e-05, -1.310381930954542e-07,  1.110572647477492e-09, -9.412287453513788e-12,  7.976955095363314e-14, -6.759911199100286e-16,  5.725896226053814e-18,
 -4.839621099096875e-20,  4.054208867545334e-22, -3.282809788262229e-24,  3.573553961008475e-01, -3.028653088729982e-03,  2.566839515424257e-05, -2.175443919914409e-07,
  1.843728457557447e-09, -1.562590118499969e-11,  1.324299812778068e-13, -1.122239327579544e-15,  9.505207878119744e-18, -8.031532823217595e-20,  6.719014218896493e-22,
 -5.409672880664292e-24,  5.702842952625519e-01, -4.833264898552069e-03,  4.096281404157921e-05, -3.471674168476911e-07,  2.942307136568940e-09, -2.493652530428183e-11,
  2.113371208968320e-13, -1.790877272363994e-15,  1.516666419981211e-17, -1.280754977625635e-19,  1.068533350288014e-21, -8.502568481733357e-24,  1.203276049882555e-02,
 -9.863581182997384e-05,  8.085445873773838e-07, -6.627859950077976e-09,  5.433036837716392e-11, -4.453605811929303e-13,  3.650727220175898e-15, -2.992521592138877e-17,
  2.452683233591958e-19, -2.009018545471353e-21,  1.641316021820032e-23, -1.327204628047315e-25,  4.881096231736438e-02, -4.001167392008034e-04,  3.279865778928934e-06,
 -2.688595208616926e-08,  2.203914521996733e-10, -1.806607742995936e-12,  1.480919457810979e-14, -1.213917297730633e-16,  9.949283769880489e-19, -8.149422070165711e-21,
  6.657336605135010e-23, -5.381472228637730e-25,  1.126055572989890e-01, -9.230583922807058e-04,  7.566560796255138e-06, -6.202515733944697e-08,  5.084370613704328e-10,
 -4.167794642956712e-12,  3.416440145770235e-14, -2.800470616853129e-16,  2.295255630095185e-18, -1.879975630185812e-20,  1.535542949805447e-22, -1.240490240662725e-24,
  2.081941389403539e-01, -1.706624004907203e-03,  1.398966132288390e-05, -1.146770597367394e-07,  9.400390029355307e-10, -7.705750999488678e-12,  6.316585282292657e-14,
 -5.177723001321975e-16,  4.243599766989326e-18, -3.475622307993367e-20,  2.838151981583468e-22, -2.290424765835164e-24,  3.456356227235017e-01, -2.833269244237762e-03,
  2.322507889747104e-05, -1.903822899932824e-07,  1.560615326829210e-09, -1.279278033148144e-11,  1.048653834026992e-13, -8.595820388712755e-16,  7.044910295252696e-18,
 -5.769454095535580e-20,  4.709299738654061e-22, -3.793707840969689e-24,  5.515813379992136e-01, -4.521462308575105e-03,  3.706365678324695e-05, -3.038208773772636e-07,
  2.490502204063565e-09, -2.041530914751731e-11,  1.673488803781100e-13, -1.371751858232993e-15,  1.124214524897637e-17, -9.205179163892812e-20,  7.507490405193305e-22,
 -6.026319199593983e-24,  1.165067025521616e-02, -9.247146191990597e-05,  7.339467242430288e-07, -5.825340946122667e-09,  4.623577651812385e-11, -3.669736754822866e-13,
  2.912669868853603e-15, -2.311771486125817e-17,  1.834774813541166e-19, -1.455928022133220e-21,  1.154327603795510e-23, -9.119761310404547e-26,  4.726101104188866e-02,
 -3.751110182608940e-04,  2.977259117176762e-06, -2.363052912325578e-08,  1.875556938840779e-10, -1.488630825424722e-12,  1.181526182127893e-14, -9.377712700103786e-17,
  7.442766351750026e-19, -5.905944118886929e-21,  4.682393992735149e-23, -3.698931737442733e-25,  1.090298620273740e-01, -8.653708768456100e-04,  6.868455490235653e-06,
 -5.451498546135496e-08,  4.326858644191823e-10, -3.434230649446274e-12,  2.725748518438842e-14, -2.163412012029454e-16,  1.717022373281214e-18, -1.362469762590289e-20,
  1.080154837614791e-22, -8.531183418071885e-25,  2.015831082235478e-01, -1.599966723583043e-03,  1.269894853268531e-05, -1.007916547722647e-07,  7.999841487265161e-10,
 -6.349479580860232e-12,  5.039580971610385e-14, -3.999886605441493e-16,  3.174557280484295e-18, -2.518995655100811e-20,  1.996890428322431e-22, -1.576651842945379e-24,
  3.346602526661311e-01, -2.656201071062877e-03,  2.108228889795002e-05, -1.673302934273344e-07,  1.328101840107160e-09, -1.054115312040097e-11,  8.366510714519399e-14,
 -6.640446630699801e-16,  5.270244019913087e-18, -4.181805032977663e-20,  3.314637757497178e-22, -2.615636033499997e-24,  5.340663340376092e-01, -4.238888715308278e-03,
  3.364409324088445e-05, -2.670334336214272e-07,  2.119446434007411e-09, -1.682206000468171e-11,  1.335166228170353e-13, -1.059711443296357e-15,  8.410409060293928e-18,
 -6.673114140365197e-20,  5.288038587573102e-22, -4.168337674709388e-24  };
  constexpr double w[2304] = {  2.085082415819945e-02, -1.511395846242854e-03,  7.778210620091832e-05, -3.404881890050269e-06,  1.340383066056370e-07,
 -4.872376619575428e-09,  1.661031155269000e-10, -5.365148971277916e-12,  1.653707983946835e-13, -4.889743996659297e-15,  1.392432805908890e-16, -3.827841962352628e-18,
  6.557127583373057e-02, -8.276551224807806e-03,  6.906641351300671e-04, -4.574173356439457e-05,  2.583849337191257e-06, -1.292940047189776e-07,  5.864216779212933e-09,
 -2.447772169158536e-10,  9.504451102055357e-12, -3.460383627726575e-13,  1.188490990754055e-14, -3.865561355011252e-16,  1.004324706144519e-01, -2.054523138234190e-02,
  2.499187826695663e-03, -2.267228984363279e-04,  1.678589729748677e-05, -1.063644033608418e-06,  5.938591109266035e-08, -2.979014441161440e-09,  1.361456575308264e-10,
 -5.727788069061458e-12,  2.236192411907186e-13, -8.144518710065570e-15,  1.058588665276203e-01, -3.071322869558266e-02,  4.960473961523952e-03, -5.709157300323198e-04,
  5.180500657231047e-05, -3.913702792247422e-06,  2.546391605248573e-07, -1.460039937387862e-08,  7.500776491690786e-10, -3.496076069984598e-11,  1.492892664893499e-12,
 -5.879076917910917e-14,  8.208870381863077e-02, -2.979306237991862e-02,  5.843632620967644e-03, -7.934870775177390e-04,  8.293462022896483e-05, -7.075086230598588e-06,
  5.112399159450520e-07, -3.209859638270682e-08,  1.783965021869386e-09, -8.901567230610567e-11,  4.032312981355927e-12, -1.670926280640922e-13,  3.876321752318655e-02,
 -1.580450093034542e-02,  3.449727157814084e-03, -5.137627866427112e-04,  5.812457074699014e-05, -5.307095488680516e-06,  4.065239576724748e-07, -2.683707695658122e-08,
  1.557350108790901e-09, -8.065014687800914e-11,  3.772028130714463e-12, -1.606482545561065e-13,  1.583419807584658e-02, -1.022329815930989e-03,  4.715950161839540e-05,
 -1.865329894017259e-06,  6.680523763645638e-08, -2.221648255812283e-09,  6.960815994091639e-11, -2.074679032490383e-12,  5.921687400319753e-14, -1.626742741496701e-15,
  4.316782651636885e-17, -1.109076022031519e-18,  4.082338115121329e-02, -4.400366337099303e-03,  3.241034216507255e-04, -1.927289204488555e-05,  9.887474677381603e-07,
 -4.533013458321639e-08,  1.897271734078682e-09, -7.353019631119354e-11,  2.665237968255653e-12, -9.102132796622741e-14,  2.945311538419049e-15, -9.062662156816773e-17,
  4.581861882082941e-02, -8.094052896294024e-03,  8.783123998506347e-04, -7.234309517265042e-05,  4.924289263985763e-06, -2.896722285817022e-07,  1.513338479852172e-08,
 -7.150798801012675e-10,  3.096008926324692e-11, -1.240167554240074e-12,  4.630518757684519e-14, -1.619476737599774e-15,  3.309717693260966e-02, -8.667467440810383e-03,
  1.287114008836272e-03, -1.380345042062100e-04,  1.178977840509554e-05, -8.451060049047354e-07,  5.251298213380242e-08, -2.891231379060156e-09,  1.432850340722243e-10,
 -6.467989930571389e-12,  2.684108350643005e-13, -1.030356751834087e-14,  1.782236962579096e-02, -6.146503044037776e-03,  1.152797240844805e-03, -1.506855928849639e-04,
  1.524518527170152e-05, -1.264593647920975e-06,  8.918148181731889e-08, -5.481546531776847e-09,  2.990148991388078e-10, -1.467619273847872e-11,  6.551695871304994e-13,
 -2.679910227620061e-14,  6.550405930043384e-03, -2.631260847951913e-03,  5.662862004703209e-04, -8.328950967852919e-05,  9.320093276644244e-06, -8.427761335171460e-07,
  6.400458410235530e-08, -4.193062964129163e-09,  2.416546994921695e-10, -1.243710644030930e-11,  5.784239201503839e-13, -2.450915723510100e-14,  1.237950625824385e-02,
 -7.192903044835415e-04,  2.997058273820146e-05, -1.077631558375768e-06,  3.528674062363561e-08, -1.078209608184107e-09,  3.116169644112426e-11, -8.598160397209103e-13,
  2.278631171847730e-14, -5.828146919081642e-16,  1.444312970763124e-17, -3.471648849090575e-19,  2.724838305160112e-02, -2.519411612517265e-03,  1.642784024109428e-04,
 -8.790419144434637e-06,  4.101236478569049e-07, -1.723766393403231e-08,  6.657972494621430e-10, -2.394648375552438e-11,  8.095118994468409e-13, -2.589820566978492e-14,
  7.882410806180690e-16, -2.290068722315632e-17,  2.343600869282702e-02, -3.539839493540432e-03,  3.409715489682884e-04, -2.538706686393062e-05,  1.582016177489721e-06,
 -8.603056770086533e-08,  4.187876022941160e-09, -1.856160298765042e-10,  7.581676537605842e-12, -2.879679720422914e-13,  1.024129224415807e-14, -3.425793234786238e-16,
  1.179396968801689e-02, -2.735600239096002e-03,  3.689786677015306e-04, -3.651152621750228e-05,  2.910927997141278e-06, -1.965307758489861e-07,  1.158636632359652e-08,
 -6.089215561928774e-10,  2.895443535900339e-11, -1.259637760855326e-12,  5.057247473553111e-14, -1.884667856733778e-15,  4.258492473123492e-03, -1.374366989281186e-03,
  2.436580733939233e-04, -3.037985069849631e-05,  2.952931002236590e-06, -2.366838771574398e-07,  1.620359663659011e-08, -9.705688787765387e-10,  5.176014746084045e-11,
 -2.490412516495631e-12,  1.092365353839996e-13, -4.399102854713128e-15,  1.146285325236916e-03, -4.514487353561625e-04,  9.540209813902096e-05, -1.381113745747349e-05,
  1.524388288587286e-06, -1.362041236844111e-07,  1.023592884355623e-08, -6.643779890879167e-10,  3.797444425885705e-11, -1.940011366321801e-12,  8.962744982557853e-14,
 -3.774985613609688e-15,  9.911653027943453e-03, -5.230642154644067e-04,  1.982727016041796e-05, -6.518397225754893e-07,  1.960731116012389e-08, -5.528630452763269e-10,
  1.479134648528673e-11, -3.790557306766403e-13,  9.358960108480171e-15, -2.231682575608012e-16,  5.180235464977334e-18, -1.168636214399844e-19,  1.926000399492670e-02,
 -1.537082125360019e-03,  8.908419561252325e-05, -4.302801091887203e-06,  1.829832752224614e-07, -7.061734896496461e-09,  2.519446089414376e-10, -8.412951952029759e-12,
  2.652327117667640e-13, -7.945501735272181e-15,  2.272784861408360e-16, -6.227648433905950e-18,  1.327383188874078e-02, -1.702749186508459e-03,  1.452478595901520e-04,
 -9.752302115600992e-06,  5.549088329605241e-07, -2.781665396027278e-08,  1.257874936597834e-09, -5.212795676337584e-11,  2.002057847540554e-12, -7.185799043232776e-14,
  2.425713454653447e-15, -7.733736460538236e-17,  4.800183864600871e-03, -9.677665833708028e-04,  1.172706033905934e-04, -1.061200232542062e-05,  7.836457941125181e-07,
 -4.948739377118270e-08,  2.750552936976430e-09, -1.371827527296994e-10,  6.225132464396320e-12, -2.597014808094126e-13,  1.004091470049142e-14, -3.617178213104149e-16,
  1.140107437722629e-03, -3.377661884559356e-04,  5.584013373157863e-05, -6.570639704695835e-06,  6.082734383039183e-07, -4.676727779180640e-08,  3.088924551202511e-09,
 -1.793451938941329e-10,  9.307407282562366e-12, -4.372283262716447e-13,  1.877707689134329e-14, -7.421799150025697e-16,  2.099177469875635e-04, -8.048368093864714e-05,
  1.660507589910835e-05, -2.355303188641678e-06,  2.554770541178988e-07, -2.248761837969630e-08,  1.668158086903377e-09, -1.070501274543944e-10,  6.057728939009707e-12,
 -3.067314002490196e-13,  1.405864839671589e-14, -5.879296383792149e-16,  8.093652549151361e-03, -3.911319468134530e-04,  1.357650762503091e-05, -4.103754412101288e-07,
  1.138818046312707e-08, -2.975995682003719e-10,  7.398755530321642e-12, -1.763721443022165e-13,  4.082242798904201e-15, -9.083576201255962e-17,  1.969627682369308e-18,
 -4.220044998845023e-20,  1.426839906530218e-02, -9.901086011340570e-04,  5.123682918454384e-05, -2.242106222175581e-06,  8.716190736924896e-08, -3.095410910464692e-09,
  1.021762026115214e-10, -3.171122171784653e-12,  9.329856164464275e-14, -2.617885810538244e-15,  7.037077272454851e-17, -1.817711260834164e-18,  8.213911229924912e-03,
 -8.915903028643737e-04,  6.734769816757591e-05, -4.075307643816119e-06,  2.115074089325409e-07, -9.758571614485037e-09,  4.091661237416895e-10, -1.582027314126091e-11,
  5.699300338527322e-13, -1.928036784569389e-14,  6.160865764671923e-16, -1.866707475369812e-17,  2.223718558364721e-03, -3.828985706135798e-04,  4.132354612759579e-05,
 -3.394406110975456e-06,  2.306447583724372e-07, -1.354075484672383e-08,  7.054908580621700e-10, -3.321178133571251e-11,  1.430926245282289e-12, -5.696928897815159e-14,
  2.111490427032026e-15, -7.321427482821442e-17,  3.479183689067901e-04, -9.243964508639016e-05,  1.403707485784668e-05, -1.540524859514217e-06,  1.345199401068516e-07,
 -9.840511269301207e-09,  6.226859493025260e-10, -3.483269608353486e-11,  1.749838041001726e-12, -7.988488885643563e-14,  3.345270393992761e-15, -1.293097339811260e-16,
  4.081564338716389e-05, -1.507525004280867e-05,  3.012192099930731e-06, -4.160211815734764e-07,  4.412838171888486e-08, -3.811362241904444e-09,  2.781746072363102e-10,
 -1.760182296161592e-11,  9.838855587394946e-13, -4.928306050953415e-14,  2.237293405002595e-15, -9.276939272895127e-17,  6.719006960827405e-03, -2.995173683016641e-04,
  9.576080919258871e-06, -2.675799874723169e-07,  6.877070262336214e-09, -1.670851238102374e-10,  3.888052236353193e-12, -8.586915890792131e-14,  1.874321548654998e-15,
 -3.956326131652923e-17,  7.811697933078570e-19, -1.605526031541958e-20,  1.098555389634693e-02, -6.680950089693063e-04,  3.101774302019875e-05, -1.234614278980263e-06,
  4.401793761075006e-08, -1.442241539548699e-09,  4.413927242992565e-11, -1.275317522974465e-12,  3.505446758203951e-14, -9.220675093685017e-16,  2.330746617363470e-17,
 -5.675571508778543e-19,  5.480658287078531e-03, -5.028813573938543e-04,  3.369905030235269e-05, -1.839351147689946e-06,  8.709660210285508e-08, -3.697398015634997e-09,
  1.436171395288254e-10, -5.175490733205010e-12,  1.746161828652849e-13, -5.557439103852894e-15,  1.677831285465042e-16, -4.820506483654790e-18,  1.162741407609870e-03,
 -1.683726688722577e-04,  1.609247163015603e-05, -1.193312631057571e-06,  7.423260749808227e-08, -4.031702913445362e-09,  1.959613410637068e-10, -8.667069588161581e-12,
  3.529332347124454e-13, -1.335026577923195e-14,  4.723166996860890e-16, -1.569856171971925e-17,  1.226846256488935e-04, -2.846046766112876e-05,  3.908760034500817e-06,
 -3.952269014452839e-07,  3.222589855703603e-08, -2.223678280357314e-09,  1.337964019009701e-10, -7.163589110552351e-12,  3.463203990245675e-13, -1.528560386682258e-14,
  6.212912022168414e-16, -2.339018770348174e-17,  8.595213561147145e-06, -3.010283328008497e-06,  5.759930439253199e-07, -7.680529029403272e-08,  7.914568805293149e-09,
 -6.672378536412528e-10,  4.771054215484575e-11, -2.966378369463343e-12,  1.633109488213236e-13, -8.072588473508606e-15,  3.622262736998982e-16, -1.486608858471579e-17,
  5.656161732049960e-03, -2.341066430800161e-04,  6.929493701571180e-06, -1.799209798686700e-07,  4.303879834761703e-09, -9.697656459389234e-11,  2.145453385029434e-12,
 -4.379744467883676e-14,  8.767940790154362e-16, -1.879414813115260e-17,  3.304213678320064e-19, -5.865912020476981e-21,  8.730046882464093e-03, -4.691121396153282e-04,
  1.963422906412049e-05, -7.137268460846424e-07,  2.341911420850610e-08, -7.099177551965182e-10,  2.019140014234629e-11, -5.442618064555854e-13,  1.399828730367069e-14,
 -3.454508118699895e-16,  8.221027308365879e-18, -1.889785463675984e-19,  3.895843584389511e-03, -3.024963599217786e-04,  1.804280584324611e-05, -8.900057229143210e-07,
  3.849818478285301e-08, -1.505229715421532e-09,  5.414021077728448e-11, -1.818423151640379e-12,  5.743850533416244e-14, -1.716981748813683e-15,  4.893071347903108e-17,
 -1.331407611115638e-18,  6.781478238810374e-04, -8.152148650797614e-05,  6.885438662809166e-06, -4.593092571403118e-07,  2.606918831966814e-08, -1.305408453919716e-09,
  5.896709011496746e-11, -2.441288994110715e-12,  9.360755171268365e-14, -3.351169923017793e-15,  1.127476511951547e-16, -3.578749799525928e-18,  5.036657170062835e-05,
 -9.907754283379988e-06,  1.213715496906121e-06, -1.117502502748835e-07,  8.425362048232295e-09, -5.437201515807919e-10,  3.087093809168918e-11, -1.571222334717595e-12,
  7.265239583570142e-14, -3.083052473698777e-15,  1.210223488805780e-16, -4.417556259767266e-18,  2.013236448115433e-06, -6.527930234431374e-07,  1.177818607706264e-07,
 -1.499191027779051e-08,  1.487808935136731e-09, -1.215937930705058e-10,  8.471179628599868e-12, -5.151932798626014e-13,  2.783184783901035e-14, -1.353418431027843e-15,
  5.986902488242184e-17, -2.426548354336406e-18,  4.818412031664211e-03, -1.862673369758344e-04,  5.127654493533526e-06, -1.241445895896192e-07,  2.793954909264859e-09,
 -5.757567443196285e-11,  1.225986583674236e-12, -2.441723100576877e-14,  3.911449740925214e-16, -9.117002813049310e-18,  1.872958841312070e-19, -1.192375754808126e-21,
  7.121261004535496e-03, -3.408576863731124e-04,  1.292223798060975e-05, -4.306766658549883e-07,  1.305228031854780e-08, -3.671462929043971e-10,  9.726885198794165e-12,
 -2.451302932900361e-13,  5.914524276566147e-15, -1.370942137983583e-16,  3.068883626927346e-18, -6.685130147833443e-20,  2.919157913492143e-03, -1.923049138310653e-04,
  1.025412841393053e-05, -4.584655709011681e-07,  1.813550246941672e-08, -6.551443329717485e-10,  2.181395395749213e-11, -6.823864280137103e-13,  2.023887396352417e-14,
 -5.670948915582014e-16,  1.521790508921932e-17, -3.934543679913926e-19,  4.352290833560805e-04, -4.297347302718975e-05,  3.212437640653352e-06, -1.924988956184510e-07,
  9.945452470533495e-09, -4.585751171568976e-10,  1.919574757734377e-11, -7.417564822179211e-13,  2.671848120126507e-14, -9.022342612893167e-16,  2.877291684680407e-17,
 -8.697445008887397e-19,  2.406508668269463e-05, -3.894057255490938e-06,  4.212759320365542e-07, -3.496256124417845e-08,  2.415958329934047e-09, -1.446936647454007e-10,
  7.695927821852932e-12, -3.698783275605917e-13,  1.625874002271618e-14, -6.595900138661325e-16,  2.487550242354081e-17, -8.761877555434323e-19,  5.424246233970726e-07,
 -1.571164634303180e-07,  2.620197001487210e-08, -3.137143555133135e-09,  2.965062025902347e-10, -2.328635076766664e-11,  1.569540752284000e-12, -9.283685100637408e-14,
  4.898007069534403e-15, -2.333938053876902e-16,  1.014435352934096e-17, -4.049174296862314e-19,  4.146919449444871e-03, -1.505232767479660e-04,  3.872736347582106e-06,
 -8.726512900687347e-08,  1.887505225229823e-09, -3.519510305697266e-11,  6.781217391020667e-13, -1.576738574447717e-14,  1.910235095039859e-16, -2.099944987821756e-18,
  1.680531154053608e-19, -6.642648221450680e-22,  5.936222282107485e-03, -2.550879017737136e-04,  8.800344066330210e-06, -2.698996798511201e-07,  7.581712671515737e-09,
 -1.985144548580197e-10,  4.911610983453591e-12, -1.158895607021666e-13,  2.628211684877956e-15, -5.757784166946417e-17,  1.208790622287524e-18, -2.467612556448037e-20,
  2.285011036508765e-03, -1.281840227965964e-04,  6.138261011190479e-06, -2.500610017336894e-07,  9.031463945186649e-09, -3.030804152049578e-10,  9.380313107374497e-12,
 -2.710456059030331e-13,  7.597410267453595e-15, -2.013775806770076e-16,  4.986153325878040e-18, -1.236575644564032e-19,  3.031735330748048e-04, -2.437229394166750e-05,
  1.619822081876019e-06, -8.735460392735416e-08,  4.094496998414923e-09, -1.740917149637502e-10,  6.748691791245738e-12, -2.423265933295717e-13,  8.200039367246460e-15,
 -2.608815800485469e-16,  7.841205680124036e-18, -2.256957766097125e-19,  1.327486519366356e-05, -1.713636795133416e-06,  1.630912978506264e-07, -1.211209937059886e-08,
  7.610416943005628e-10, -4.205207782190078e-11,  2.082072565244090e-12, -9.389699327230421e-14,  3.902374853455669e-15, -1.505207369654764e-16,  5.424877145670930e-18,
 -1.835414564544333e-19,  1.745756130974630e-07, -4.290255272733840e-08,  6.461637470167246e-09, -7.148413069039156e-10,  6.347382898054921e-11, -4.739276531074438e-12,
  3.063609558389181e-13, -1.749861190900899e-14,  8.963373175298554e-16, -4.164667895092707e-17,  1.771266287387107e-18, -6.938523316434368e-20,  3.600818631472317e-03,
 -1.232651587679579e-04,  2.986009624610378e-06, -6.195012815139497e-08,  1.314026043917354e-09, -2.355346213481106e-11,  3.194127003360944e-13, -9.698721139495579e-15,
  2.174629940453113e-16,  2.643648043393245e-18,  2.553190697067949e-20, -6.365832543476178e-21,  5.038723834427032e-03, -1.958430980321675e-04,  6.176468885301419e-06,
 -1.749037590945471e-07,  4.569427401473176e-09, -1.116983235313438e-10,  2.588590920693560e-12, -5.737859304571620e-14,  1.218023819979285e-15, -2.527137240646210e-17,
  5.159563924859376e-19, -9.449519887438340e-21,  1.854429763476634e-03, -8.901658188815627e-05,  3.838114855755242e-06, -1.439787073582737e-07,  4.724234794892009e-09,
 -1.470979645781339e-10,  4.328097297416448e-12, -1.139824089678427e-13,  2.935065589839793e-15, -7.837392075481623e-17,  1.786656157473330e-18, -3.661763228727193e-20,
  2.262462165246796e-04, -1.471009646051164e-05,  8.730194016773546e-07, -4.276366703854854e-08,  1.805741545128715e-09, -7.080693760869606e-11,  2.565599325193029e-12,
 -8.486625536383347e-14,  2.679453779843035e-15, -8.154012122974197e-17,  2.289296334421788e-18, -6.139022306874885e-20,  8.335045878823836e-06, -8.331555537799161e-07,
  6.989988820810582e-08, -4.640779394260152e-09,  2.628343339985345e-10, -1.334653647646679e-11,  6.132457978677465e-13, -2.577129106997553e-14,  1.007634931758588e-15,
 -3.684055137895776e-17,  1.260772587209126e-18, -4.075801287106608e-20,  6.938484935240031e-08, -1.350501019961520e-08,  1.797514324660222e-09, -1.802222791604792e-10,
  1.479768386072762e-11, -1.037745291974382e-12,  6.368465055533962e-14, -3.482359472488550e-15,  1.719678447894511e-16, -7.744712822952394e-18,  3.206564118138792e-19,
 -1.227492584504108e-20,  3.151286248184722e-03, -1.020267651718415e-04,  2.354342652769067e-06, -4.435485646781053e-08,  9.020345863129139e-10, -1.827975198072374e-11,
  1.575173121912720e-13, -1.620974827046554e-15,  2.570207263666262e-16, -2.368392935137182e-18, -2.488196068682568e-19, -2.399340467874543e-21,  4.342437737988350e-03,
 -1.537341176826886e-04,  4.452179393788662e-06, -1.167656461409724e-07,  2.846243707136996e-09, -6.516308818120712e-11,  1.415170314088272e-12, -2.967197769274309e-14,
  5.965825751633323e-16, -1.117905204709559e-17,  2.207438453940505e-19, -4.866668140955447e-21,  1.550390637210069e-03, -6.412928480840059e-05,  2.482524779725637e-06,
 -8.720602762547512e-08,  2.607878650294264e-09, -7.308697059459328e-11,  2.110946611972028e-12, -5.386446360342371e-14,  1.113658628092971e-15, -2.863257271292342e-17,
  8.735043245877606e-19, -1.253672323887754e-20,  1.786988199308966e-04, -9.376733677280417e-06,  4.954581988496552e-07, -2.251840353297013e-08,  8.533781249834145e-10,
 -3.024809117399824e-11,  1.049582176794414e-12, -3.256216425932782e-14,  9.084561741633825e-16, -2.662451587257163e-17,  7.687190498182414e-19, -1.748301385923178e-20,
  5.847627279001825e-06, -4.413117373600898e-07,  3.268324806297230e-08, -1.963849532593374e-09,  9.929889503653786e-11, -4.592384577355827e-12,  1.969768021927497e-13,
 -7.688099690570657e-15,  2.787976720482978e-16, -9.684481188567914e-18,  3.164487304307156e-19, -9.572186766477750e-21,  3.455297258630663e-08, -4.916861983933100e-09,
  5.700937751958712e-10, -5.101847065715899e-11,  3.803929877734080e-12, -2.473329943941154e-13,  1.426594519489644e-14, -7.392526572927595e-16,  3.489051838208242e-17,
 -1.513543443137361e-18,  6.063827296993304e-20, -2.254780339053807e-21,  2.777789111424506e-03, -8.510216868605731e-05,  1.897274925870125e-06, -3.264205848723326e-08,
  5.747859065516983e-10, -1.426156168807135e-11,  2.010652635667922e-13,  3.418238494193476e-15,  1.380992714280327e-17, -9.341813876904600e-18,  1.390547603045065e-20,
  1.210510180025073e-20,  3.790837882062487e-03, -1.230355735428612e-04,  3.286513348950584e-06, -8.005436483555697e-08,  1.825088949698232e-09, -3.933189696706726e-11,
  8.011013142148720e-13, -1.568282096375682e-14,  3.095549573946140e-16, -5.722315398548011e-18,  7.718350534477552e-20, -1.464052280205412e-21,  1.327840927683413e-03,
 -4.784112847069623e-05,  1.645839077949472e-06, -5.487159231757240e-08,  1.548163834058654e-09, -3.723396445911837e-11,  9.884573845980211e-13, -2.907586111163071e-14,
  5.746036639878531e-16, -5.342530643278192e-18,  2.645337281896780e-19, -1.510676986374191e-20,  1.476844685016239e-04, -6.300250385254131e-06,  2.909055694691862e-07,
 -1.259580452130821e-08,  4.403514483234336e-10, -1.341978565357792e-11,  4.356244533157850e-13, -1.414326983408906e-14,  3.549354315980975e-16, -7.491707995533305e-18,
  2.497150493416069e-19, -8.433121459609100e-21,  4.486719953032451e-06, -2.527146653419069e-07,  1.628694829649292e-08, -9.114493306816180e-10,  4.139524973270940e-11,
 -1.691589576732733e-12,  6.779001507013691e-14, -2.538602366297650e-15,  8.383514984393264e-17, -2.626202760213137e-18,  8.555223847161423e-20, -2.587061800715896e-21,
  2.121315159298469e-08, -2.052960495416161e-09,  2.051682523982296e-10, -1.640571052389661e-11,  1.091259843304660e-12, -6.460085368063813e-14,  3.477719460496161e-15,
 -1.696453547016190e-16,  7.552729452194459e-18, -3.125183648446418e-19,  1.210058606640455e-20, -4.348648745684115e-22,  2.465450508379848e-03, -7.135426842286633e-05,
  1.552269186060749e-06, -2.543544815771337e-08,  3.445965177214079e-10, -8.519775079616361e-12,  2.588518176725920e-13, -4.576601603431562e-16, -2.002904464716144e-16,
 -3.985019837299467e-19,  3.215459234683660e-19, -2.200729375664057e-21,  3.345825416469986e-03, -1.001433169444487e-04,  2.478129915067318e-06, -5.623281743692349e-08,
  1.200194456618000e-09, -2.442668676587805e-11,  4.734780628496065e-13, -8.550793051592427e-15,  1.512042947577575e-16, -3.154474673317604e-18,  6.147333056805879e-20,
 -7.291461160702990e-23,  1.159168522479339e-03, -3.693660193230186e-05,  1.114934212270941e-06, -3.501067836082542e-08,  9.849226330507797e-10, -2.133740683279403e-11,
  4.104922270883608e-13, -1.288730350518933e-14,  4.354927806591294e-16, -5.185767927331797e-18, -1.459593791741048e-19, -6.538275933098150e-22,  1.263268111731926e-04,
 -4.475120383695437e-06,  1.746945152615303e-07, -7.243492103301655e-09,  2.502022207728390e-10, -6.630045815198364e-12,  1.680764609694292e-13, -5.804023488560777e-15,
  1.903263320217115e-16, -3.250083560479452e-18,  1.063046949650064e-20, -1.915549285391804e-21,  3.680287819405608e-06, -1.570071545236572e-07,  8.438445311451874e-09,
 -4.510198606048615e-10,  1.934226253086344e-11, -6.828580731997489e-13,  2.369674858567043e-14, -8.862877816862853e-16,  3.002054748026845e-17, -7.915475816928799e-19,
  1.958467760278568e-20, -7.017243228324272e-22,  1.535601964938684e-08, -9.773976703704561e-10,  8.164799689089992e-11, -5.976844719849278e-12,  3.558954113033798e-13,
 -1.862355205822027e-14,  9.172957993234785e-16, -4.247253481499244e-17,  1.788563920352073e-18, -6.865393249338933e-20,  2.508708335723596e-21, -8.906356263236406e-23,
  2.203054574322427e-03, -6.007411593000395e-05,  1.275553388115215e-06, -2.096428653332291e-08,  2.317794844848062e-10, -3.120232190139884e-12,  1.692758689358151e-13,
 -5.092957348050391e-15, -4.800578668063057e-17,  6.397686461065828e-18, -2.725293700095342e-20, -8.397426482204315e-21,  2.981045059650143e-03, -8.272448558872215e-05,
  1.904231784712915e-06, -4.039330852614826e-08,  8.083428157759018e-10, -1.547804718084135e-11,  2.879622712293180e-13, -5.083116436247657e-15,  7.774455519611173e-17,
 -1.128382316984248e-18,  3.199173714129852e-20, -1.044518565442894e-21,  1.026939465437644e-03, -2.945919987638709e-05,  7.767372764063839e-07, -2.222755531836578e-08,
  6.347349396259985e-10, -1.444994591944794e-11,  2.096820233211642e-13, -2.854287830432781e-15,  1.753716909930155e-16, -7.724792288112655e-18,  6.736771136796309e-20,
  5.931446849385432e-21,  1.107552410174104e-04, -3.366079414097118e-06,  1.080019810643157e-07, -4.126138600607212e-09,  1.478778518930529e-10, -3.965319152706252e-12,
  7.341551863439772e-14, -1.560429591577994e-15,  7.643784576961336e-17, -2.894031031687896e-18,  3.183744844527071e-20,  1.424665840756825e-21,  3.159265840809700e-06,
 -1.067596288166626e-07,  4.513473138239693e-09, -2.266785379186995e-10,  9.827371762816112e-12, -3.254580341741558e-13,  8.862337772777977e-15, -2.732268751989692e-16,
  1.076275979062285e-17, -3.577005802928001e-19,  6.822459031994772e-21, -5.117956701063990e-23,  1.240570434073604e-08, -5.364542932171432e-10,  3.479775018113264e-11,
 -2.377809721131071e-12,  1.330034146587667e-13, -6.155052766336386e-15,  2.613320961680995e-16, -1.113031807499598e-17,  4.637033126362924e-19, -1.730678828137079e-20,
  5.625562330690595e-22, -1.741442252436809e-23,  1.981657937750982e-03, -5.081648369419601e-05,  1.044754023249703e-06, -1.758339169931272e-08,  1.983811613103870e-10,
 -7.515609483222085e-13,  3.503999276445196e-14, -3.684594590046516e-15,  1.033292926412799e-16,  1.216163418183148e-18, -1.501749208741711e-19,  2.215649858684655e-21,
  2.677827122983866e-03, -6.923094904756371e-05,  1.487992881645574e-06, -2.960455249863783e-08,  5.576833090584911e-10, -1.002454136500687e-11,  1.756389161580280e-13,
 -3.079132472960563e-15,  5.059348650301686e-17, -5.810125069626349e-19,  2.100248152091464e-21, -1.936933134607651e-22,  9.200580646082341e-04, -2.415986311738808e-05,
  5.622364650359262e-07, -1.412915068389424e-08,  3.918742596001506e-10, -9.970733090870692e-12,  1.725024765112409e-13, -8.027548173010772e-16, -1.323565863341051e-17,
 -2.261875144996193e-18,  1.434633356716624e-19, -2.124360015808151e-21,  9.875492008408241e-05, -2.665358269181480e-06,  7.034649190281798e-08, -2.309818773628900e-09,
  8.371232183299315e-11, -2.536243978434287e-12,  5.061732326445188e-14, -4.446952298597627e-16,  5.242751814798338e-18, -9.491276031881971e-19,  4.870385021811432e-20,
 -6.956106927755478e-22,  2.790418481384871e-06, -7.928952770330807e-08,  2.553672396480728e-09, -1.119929006754181e-10,  4.982718853856961e-12, -1.757482525831993e-13,
  4.453687848121252e-15, -8.556212280670639e-17,  2.377353848153885e-18, -1.214736252502485e-19,  4.671467876553263e-21, -7.926907298527752e-23,  1.067694419509125e-08,
 -3.435970790134681e-10,  1.584351091144555e-11, -9.756729316618874e-13,  5.406876214643743e-14, -2.396357158709616e-15,  8.793709712143223e-17, -3.042917495048089e-18,
  1.152033861219914e-19, -4.597309034256623e-21,  1.621657033952937e-22, -4.482104359025127e-24,  1.793846596721895e-03, -4.324948631335793e-05,  8.523706295837260e-07,
 -1.451204755159539e-08,  1.853740054233193e-10, -7.698709955522650e-13, -2.206426317017259e-14, -5.794838398870182e-16,  7.157032667311541e-17, -2.013820661503894e-18,
 -1.090258407701728e-20,  2.520532840076913e-21,  2.422657040009245e-03, -5.861021695615807e-05,  1.180328847727259e-06, -2.208277848000128e-08,  3.932272871441219e-10,
 -6.679780919325539e-12,  1.090230078938914e-13, -1.783648532205670e-15,  3.080143881388539e-17, -5.011074807960350e-19,  3.984236317895155e-21,  1.083425701764866e-22,
  8.314728663456731e-04, -2.024731861808894e-05,  4.244301984374385e-07, -9.238658043777729e-09,  2.315993376491717e-10, -6.189491224685033e-12,  1.384228058085991e-13,
 -1.655223042717727e-15, -2.077644688433684e-17,  9.883532808511037e-19,  1.977194680082497e-20, -2.221251400558771e-21,  8.907106254051712e-05, -2.194134816057079e-06,
  4.919354723348699e-08, -1.314394489119536e-09,  4.413423107132638e-11, -1.471825612790791e-12,  3.762922280620112e-14, -5.231244401889285e-16, -3.356540209624214e-18,
  1.954713538485999e-19,  8.694480674659986e-21, -7.288209650974582e-22,  2.507212009621086e-06, -6.311347471633796e-08,  1.588973733169794e-09, -5.528190766024896e-11,
  2.373983239190230e-12, -9.194329178457174e-14,  2.680502638480379e-15, -5.069856932497648e-17,  4.671321963940294e-19, -8.731605445316817e-21,  1.124627064288926e-21,
 -6.027568533081593e-23,  9.498653731947100e-09, -2.519910748936182e-10,  8.051262486950199e-12, -4.023795512938736e-13,  2.198530912983680e-14, -1.008103162796272e-15,
  3.650501242393606e-17, -1.068959913188162e-18,  2.917810359052688e-20, -9.766834353486684e-22,  4.015193622069661e-23, -1.492888556874273e-24,  1.633453056888686e-03,
 -3.707804641246712e-05,  6.954149201985394e-07, -1.169972713707522e-08,  1.644233971321212e-10, -1.301004205979896e-12, -1.674920726711208e-14,  6.268272259156062e-16,
  9.409430647839427e-18, -1.150875970258157e-18,  3.431888384943440e-20, -1.225868096721811e-22,  2.205561825146367e-03, -5.012990821179359e-05,  9.490951695918734e-07,
 -1.673291851607066e-08,  2.822613642632980e-10, -4.566544557654334e-12,  7.042782942962973e-14, -1.049314681828134e-15,  1.635365509900886e-17, -2.936731612996348e-19,
  5.223751040417290e-21, -4.246909634076567e-23,  7.566502445679494e-04, -1.724065508862427e-05,  3.322541293009526e-07, -6.359550199785798e-09,  1.370354135688845e-10,
 -3.464133188936862e-12,  8.833559827960718e-14, -1.741385571254191e-15,  1.269921888478889e-17,  6.006256564013600e-19, -2.248396718062462e-20,  1.440229393737393e-23,
  8.099609482188878e-05, -1.853616522434913e-06,  3.683131664017577e-08, -7.997724982728901e-10,  2.251170629999848e-11, -7.490017273400576e-13,  2.272568281284869e-14,
 -4.984579916084939e-16,  4.485255263588508e-18,  1.468121647769344e-19, -5.825587565819357e-21, -1.847919452797780e-23,  2.276733445105733e-06, -5.252881637707161e-08,
  1.102883856112997e-09, -2.896753172862973e-11,  1.071731519698840e-12, -4.304339811642198e-14,  1.460617858644871e-15, -3.611296393823632e-17,  4.995525159137585e-19,
  2.136556448350741e-21, -1.766632768907821e-22, -5.814988178122039e-24,  8.595686685788523e-09, -2.021822218489663e-10,  4.798181020485554e-12, -1.729155551708680e-13,
  8.599222849163298e-15, -4.096723204121481e-16,  1.597317940815784e-17, -4.869340094052495e-19,  1.144702248727974e-20, -2.270696410822673e-22,  6.095434689026546e-24,
 -2.795605864485082e-25,  1.495438720730715e-03, -3.203367953287524e-05,  5.698903174735196e-07, -9.292776543756684e-09,  1.358511966896999e-10, -1.487752579549706e-12,
  5.306501103949913e-16,  5.027506895068078e-16, -1.096935655394171e-17, -1.161737008431492e-19,  1.507799404315487e-20, -4.828921554060782e-22,  2.019055946030698e-03,
 -4.326994200341379e-05,  7.726558263783415e-07, -1.286458330672601e-08,  2.057223689258676e-10, -3.178149115214558e-12,  4.704530984740004e-14, -6.594640819412593e-16,
  8.955811793645745e-18, -1.349539325835271e-19,  2.642080264552076e-21, -5.506293642205543e-23,  6.925668911298623e-04, -1.485520217581217e-05,  2.671388596824933e-07,
 -4.621609916952702e-09,  8.530429869193560e-11, -1.869169636787258e-12,  4.736109721719641e-14, -1.146859377173747e-15,  2.034779500547047e-17, -8.347689631317613e-20,
 -9.503816857546004e-21,  3.511719340619090e-22,  7.411750599662101e-05, -1.592200040007681e-06,  2.898466437823396e-08, -5.341976111950733e-10,  1.195417731581579e-11,
 -3.515171286066795e-13,  1.126749886350122e-14, -3.121532536560872e-16,  6.059927820096856e-18, -3.535590556271977e-20, -2.506730296122201e-21,  9.821586828169393e-23,
  2.082401740301855e-06, -4.485930098216256e-08,  8.350604998234834e-10, -1.711303699935754e-11,  4.889497241444632e-13, -1.829870071006035e-14,  6.741423157803136e-16,
 -2.038050710404981e-17,  4.421041110621243e-19, -4.605986812983407e-21, -8.963433686547044e-23,  4.632820917306218e-24,  7.853213888119463e-09, -1.702653946177082e-10,
  3.334748496894640e-12, -8.402132948665215e-14,  3.321508012793409e-15, -1.548456235342703e-16,  6.474671564205024e-18, -2.205255068767816e-19,  5.841152281278708e-21,
 -1.127687278952964e-22,  1.429426823484664e-24, -1.862156897335095e-26,  1.375765213171573e-03, -2.788589483387548e-05,  4.704503584319844e-07, -7.352449413720546e-09,
  1.071544736634542e-10, -1.346390546134727e-12,  9.680505063454812e-15,  1.651451790081698e-16, -8.569673640093754e-18,  1.563616353838964e-19,  9.701291448681830e-22,
 -1.615842437810577e-22,  1.857434057955303e-03, -3.765470010835142e-05,  6.361154510153942e-07, -1.002592883295323e-08,  1.521052237851408e-10, -2.242123282943167e-12,
  3.198314491173771e-14, -4.343363670156002e-16,  5.510038428843322e-18, -6.738459881512925e-20,  9.853941113815725e-22, -2.169837494714415e-23,  6.370985183878991e-04,
 -1.291921471592485e-05,  2.188083899910766e-07, -3.503699620059689e-09,  5.704761796177261e-11, -1.048994155287344e-12,  2.354559055474181e-14, -5.909725908966356e-16,
  1.360226626158473e-17, -2.242258804045712e-19,  6.450773309147372e-22,  1.103657019522035e-22,  6.817585149476503e-05, -1.383164743231519e-06,  2.353027230878273e-08,
 -3.870784859201561e-10,  7.026425316190791e-12, -1.657465127942961e-13,  4.956322187360950e-15, -1.506129699524405e-16,  3.850681484567633e-18, -6.868650996116634e-20,
  3.204704530286677e-22,  2.976264603942069e-23,  1.915182150012518e-06, -3.889020493721049e-08,  6.669481296271980e-10, -1.150594496662922e-11,  2.460980919160770e-13,
 -7.537399293696779e-15,  2.737712691941165e-16, -9.227518249604699e-18,  2.532405674129997e-19, -4.999212428828767e-21,  4.392293884640043e-23,  1.258911048580180e-24,
  7.220145856564175e-09, -1.469065274752037e-10,  2.565589215986347e-12, -4.897332282133132e-14,  1.372952997808576e-15, -5.581224995506592e-17,  2.379062828806434e-18,
 -8.852456440491480e-20,  2.697037618377158e-21, -6.405141420204250e-23,  1.064247310011772e-24, -7.713551170006323e-27,  1.271228612972487e-03, -2.444802224739106e-05,
  3.916631677454075e-07, -5.839695245927751e-09,  8.278654434771437e-11, -1.084356842187668e-12,  1.130439967172622e-14, -2.145939049000421e-17, -3.368970207489809e-18,
  1.143181377514170e-19, -1.934051978282555e-21, -3.459654447817397e-24,  1.716285367256030e-03, -3.300880469458037e-05,  5.290512090364677e-07, -7.913081730260504e-09,
  1.140479610470817e-10, -1.602548924032994e-12,  2.197088576310552e-14, -2.907046794619182e-16,  3.620290130632395e-18, -4.112419222437205e-20,  4.393922150614901e-22,
 -6.143691880820400e-24,  5.886763378154128e-04, -1.132282787869003e-05,  1.816342420414487e-07, -2.732906795862518e-09,  4.060213542719514e-11, -6.403840666874248e-13,
  1.195405800971227e-14, -2.733875500802544e-16,  6.721119600802759e-18, -1.476420161906403e-19,  2.333069654683570e-21, -7.910077561932504e-24,  6.299267021564870e-05,
 -1.211807288192798e-06,  1.946803406200899e-08, -2.959234056061870e-10,  4.622165970493816e-12, -8.562612074800562e-14,  2.120673168081809e-15, -6.278171892611679e-17,
  1.797313318688840e-18, -4.291848582079813e-20,  7.271788742687355e-22, -3.720962228806194e-24,  1.769499906603327e-06, -3.404948024432739e-08,  5.484791884948390e-10,
 -8.490728084757155e-12,  1.442043176865056e-13, -3.303976196909723e-15,  1.046136923741613e-16, -3.601285068829123e-18,  1.115799214041216e-19, -2.826868076934312e-21,
  5.241511364793265e-23, -4.506903327049741e-25,  6.670283602545215e-09, -1.284273270055505e-10,  2.080991586919249e-12, -3.352557621283499e-14,  6.692821285865650e-16,
 -2.056152127377800e-17,  8.162875530783568e-19, -3.164842378252352e-20,  1.063020612369135e-21, -2.953460276915575e-23,  6.462561079003936e-25, -9.802224277597432e-27,
  1.179289053334118e-03, -2.157405853979450e-05,  3.288654173194827e-07, -4.674246640312713e-09,  6.371505431562439e-11, -8.291650556231432e-13,  9.709218327608051e-15,
 -7.777503427619039e-17, -5.575779735629213e-19,  4.643340816637361e-20, -1.292894757429836e-21,  2.117510775135976e-23,  1.592154375311297e-03, -2.912746447774215e-05,
  4.440709244198733e-07, -6.318620551556943e-09,  8.667293343934905e-11, -1.161091227813206e-12,  1.525212713396791e-14, -1.955758273629854e-16,  2.406165081944685e-18,
 -2.739742455828679e-20,  2.733195712595271e-22, -2.382360811499538e-24,  5.460978948454752e-04, -9.990773142013892e-06,  1.523588222679229e-07, -2.172368177315158e-09,
  3.015040425697592e-11, -4.253372876569135e-13,  6.632631897919943e-15, -1.266195054342696e-16,  2.917058355846066e-18, -6.966473180179988e-20,  1.467372133345472e-21,
 -2.273999130702381e-23,  5.843606225740251e-05, -1.069124845532506e-06,  1.631173792448585e-08, -2.334007247689469e-10,  3.304442253252173e-12, -5.056352513396701e-14,
  9.730719918518741e-16, -2.485079949402958e-17,  7.143611717500354e-19, -1.925404761073891e-20,  4.339219835453867e-22, -7.147428876217444e-24,  1.641482050165730e-06,
 -3.003425836865316e-08,  4.586167701107425e-10, -6.603774924709593e-12,  9.679976050624622e-14, -1.680457165273384e-15,  4.109516983786152e-17, -1.299154952979139e-18,
  4.194813745400140e-20, -1.203176558075811e-21,  2.851627424794654e-23, -5.078860270854853e-25,  6.187545191565360e-09, -1.132321689075373e-10,  1.732132163373600e-12,
 -2.528559369348810e-14,  3.984638457838247e-16, -8.584625125674232e-18,  2.774623679617598e-19, -1.044494230819955e-20,  3.695288894056489e-22, -1.134497610243993e-23,
  2.917501455113640e-25, -6.003270416996507e-27,  1.097922327069935e-03, -1.915135038390711e-05,  2.783827920041266e-07, -3.775571426831254e-09,  4.928054742576935e-11,
 -6.230611910371429e-13,  7.471969420241160e-15, -7.712650490568530e-17,  3.920007754151069e-19,  1.146491525179392e-20, -5.196016760186687e-22,  1.281941669553347e-23,
  1.482300544820369e-03, -2.585626011993356e-05,  3.758614496442283e-07, -5.099455753862050e-09,  6.670941204631402e-11, -8.528935620258459e-13,  1.071964776882047e-14,
 -1.324345252226197e-16,  1.594303255944363e-18, -1.825878580337214e-20,  1.890555772309849e-22, -1.602051861334052e-24,  5.084182331276509e-04, -8.868570953200339e-06,
  1.289292423418199e-07, -1.750408438412893e-09,  2.299432317083954e-11, -3.001086098687548e-13,  4.087173516457349e-15, -6.389525048381274e-17,  1.245642772909378e-18,
 -2.855344429123514e-20,  6.589686817193179e-22, -1.336070891065306e-23,  5.440398895110548e-05, -9.490049923410025e-07,  1.379834372300737e-08, -1.875481743495033e-10,
  2.481369211053186e-12, -3.351159006176768e-14,  5.136376515894100e-16, -1.029777104082186e-17,  2.654815166413626e-19, -7.324237071810711e-21,  1.862372328043044e-22,
 -3.992384982411765e-24,  1.528215176645264e-06, -2.665823389219799e-08,  3.877005301410560e-10, -5.280346112951006e-12,  7.074647314647487e-14, -1.012159596560219e-15,
  1.833753549341656e-17, -4.690795856282947e-19,  1.444268989248354e-20, -4.362051331678099e-22,  1.166464262218170e-23, -2.611378142385976e-25,  5.760547190169527e-09,
 -1.004915465621087e-10,  1.462240765898298e-12, -2.000143206444705e-14,  2.752333940041428e-16, -4.407154869085360e-18,  1.025646242073595e-19, -3.349414033843947e-21,
  1.179748497276214e-22, -3.832130712508306e-24,  1.086573146831595e-25, -2.614323485548342e-27,  1.025501857328432e-03, -1.709299844647719e-05,  2.374252720138158e-07,
 -3.077734080808850e-09,  3.844617412901005e-11, -4.679687528352073e-13,  5.527071119214398e-15, -6.105036328917069e-17,  5.420234655566866e-19, -6.710422218921586e-22,
 -1.442462594419739e-22,  5.008133790065674e-24,  1.384525743352687e-03, -2.307720888391359e-05,  3.205512429985331e-07, -4.155754060092431e-09,  5.195129122217658e-11,
 -6.349134674273880e-13,  7.636556913860618e-15, -9.060465871340278e-17,  1.057265991056700e-18, -1.198157524571224e-20,  1.277637270091386e-22, -1.193342701032740e-24,
  4.748820548374925e-04, -7.915326430346452e-06,  1.099494983450206e-07, -1.425724800674884e-09,  1.784798580673780e-11, -2.197743690896662e-13,  2.732033582160891e-15,
 -3.638283231834277e-17,  5.746611432572806e-19, -1.136245012662165e-20,  2.564260613120685e-22, -5.700908781863515e-24,  5.081537946909762e-05, -8.469926346124933e-07,
  1.176579683491153e-08, -1.526217780335881e-10,  1.915145128949367e-12, -2.388414787619474e-14,  3.131074619082867e-16, -4.876658805616782e-18,  1.010917104486266e-19,
 -2.583006153631816e-21,  6.798570769198985e-23, -1.635310320147563e-24,  1.427409454083389e-06, -2.379224526519938e-08,  3.305271814589142e-10, -4.290120171604659e-12,
  5.405887325782696e-14, -6.892262579983525e-16,  9.841979145708461e-18, -1.871285176472069e-19,  4.885577790530071e-21, -1.443326287633799e-22,  4.081963642039243e-24,
 -1.023783664937264e-25,  5.380554537951453e-09, -8.968478765386549e-11,  1.246098805226043e-12, -1.619468705386437e-14,  2.058665156451322e-16, -2.746740574846181e-18,
  4.576169149744913e-20, -1.129626764987774e-21,  3.618510123180607e-23, -1.187562808217959e-24,  3.565633502808270e-26, -9.412081323959017e-28,  9.607086412608719e-04,
 -1.533153737829496e-05,  2.038962783033794e-07, -2.530809534863956e-09,  3.028475327150485e-11, -3.539250541549502e-13,  4.050997323405353e-15, -4.485777225790477e-17,
  4.547990759666795e-19, -3.333078382992666e-21, -1.451060907713229e-23,  1.448477874815692e-24,  1.297048643914476e-03, -2.069904877487244e-05,  2.752805304533670e-07,
 -3.416960037223757e-09,  4.089849168177311e-11, -4.786219025373103e-13,  5.514907776939403e-15, -6.278317024724180e-17,  7.062852911836023e-19, -7.809786739526324e-21,
  8.348890560492983e-23, -8.286111323064127e-25,  4.448780264262787e-04, -7.099623075821425e-06,  9.441983068229548e-08, -1.172071565725203e-09,  1.403502882053260e-11,
 -1.646699910589290e-13,  1.920951902018274e-15, -2.296722358679422e-17,  3.019982708227012e-19, -4.831039537395526e-21,  9.600540974919434e-23, -2.115355263854272e-24,
  4.760475306511152e-05, -7.597050441691531e-07,  1.010363536310608e-08, -1.254334172674219e-10,  1.503130780997910e-12, -1.771275238532585e-14,  2.109205799060060e-16,
 -2.720843879939006e-18,  4.335836410147485e-20, -9.176758111548995e-22,  2.292711504527665e-23, -5.741161548625405e-25,  1.337222331761152e-06, -2.134022154848282e-08,
  2.838178571872644e-10, -3.524136036752152e-12,  4.228643302181344e-14, -5.020900671912375e-16,  6.191571393957829e-18, -8.963703943600552e-20,  1.778097295842995e-21,
 -4.636372644632205e-23,  1.304062589170929e-24, -3.461481200242354e-26,  5.040596153167591e-09, -8.044117918149656e-11,  1.069881542105834e-12, -1.328945123629120e-14,
  1.598913532192429e-16, -1.928543906225334e-18,  2.548617884813781e-20, -4.461450928832066e-22,  1.139137480221496e-23, -3.514048311310934e-25,  1.075068284903549e-26,
 -3.001122942607627e-28,  9.024634515396648e-04, -1.381411420767132e-05,  1.762163223219772e-07, -2.097997887913242e-09,  2.408477657917395e-11, -2.702411430419518e-13,
  2.980463271087924e-15, -3.224150085553967e-17,  3.352884029313032e-19, -3.101966129317464e-21,  1.743323423245188e-23,  2.403092943838785e-25,  1.218412049648244e-03,
 -1.865037779796014e-05,  2.379091403875901e-07, -2.832527096695255e-09,  3.251941446652197e-11, -3.650437364684483e-13,  4.035337991665629e-15, -4.410168515194107e-17,
  4.772985623454118e-19, -5.108415667115960e-21,  5.366735736670333e-23, -5.420928371801821e-25,  4.179062526915698e-04, -6.396941373931003e-06,  8.160121241256391e-08,
 -9.715542124564443e-10,  1.115561341238627e-11, -1.253301958758922e-13,  1.391411795202357e-15, -1.549436072624684e-17,  1.795778629896292e-19, -2.347281754516457e-21,
  3.796713441074334e-23, -7.511498023846844e-25,  4.471860192678067e-05, -6.845131685186553e-07,  8.731870694547464e-09, -1.039657437183738e-10,  1.194026174933324e-12,
 -1.343332038875921e-14,  1.502176614153870e-16, -1.725019642564512e-18,  2.212286006700438e-20, -3.608569438384998e-22,  7.692952374245240e-24, -1.861635457552864e-25,
  1.256149990145747e-06, -1.922804985889436e-08,  2.452804059513699e-10, -2.920568105348818e-12,  3.355510249722546e-14, -3.784257566301276e-16,  4.284838682440675e-18,
 -5.177400361105296e-20,  7.666412133537548e-22, -1.567240576226438e-23,  4.015427936279736e-25, -1.071174119848082e-26,  4.734997325639576e-09, -7.247926404367108e-11,
  9.245824143947701e-13, -1.101015381336638e-14,  1.265976211171335e-16, -1.434850428720736e-18,  1.666401204723690e-20, -2.216391517449642e-22,  4.068916171873695e-24,
 -1.049344336722935e-25,  3.086131942456715e-27, -8.818524014740487e-29,  8.498757450673153e-04, -1.249892342424886e-05,  1.531859276011173e-07, -1.752279919239936e-09,
  1.932798788051435e-11, -2.084287889121608e-13,  2.212159363556510e-15, -2.315216716509967e-17,  2.374849840108880e-19, -2.320562244583065e-21,  1.943060383121208e-23,
 -7.171628524472238e-26,  1.147413609216102e-03, -1.687474333931154e-05,  2.068157185211417e-07, -2.365752218648200e-09,  2.609524734671028e-11, -2.814440740924930e-13,
  2.989377062733507e-15, -3.139896307518508e-17,  3.268826734354994e-19, -3.374635069020175e-21,  3.445707911979598e-23, -3.446683152070695e-25,  3.935543150770996e-04,
 -5.787911351904958e-06,  7.093628323285190e-08, -8.114395601824423e-10,  8.950865383674299e-12, -9.656204768563943e-14,  1.027089612375548e-15, -1.086003499268442e-17,
  1.161311856469735e-19, -1.312954963305772e-21,  1.712738552059310e-23, -2.788276621016991e-25,  4.211279088308266e-05, -6.193430057080652e-07,  7.590635105431855e-09,
 -8.682989093156216e-11,  9.578687870483961e-13, -1.033792405547599e-14,  1.102214761448860e-16, -1.178456716559965e-18,  1.315629299401066e-20, -1.689043291718447e-22,
  2.808422548877893e-24, -5.955207072002797e-26,  1.182952483784955e-06, -1.739740806324352e-08,  2.132219773296458e-10, -2.439095915630471e-12,  2.690998061762337e-14,
 -2.906432515378583e-16,  3.111505236306525e-18, -3.390354478205327e-20,  4.055266598102386e-22, -6.157309327522358e-24,  1.278896378529520e-25, -3.182403523421398e-27,
  4.459082720640555e-09, -6.557870688749540e-11,  8.037321165887891e-13, -9.194320990113179e-15,  1.014611128688042e-16, -1.097467653014288e-18,  1.184702787101636e-20,
 -1.340423165364844e-22,  1.813263747377189e-24, -3.457734190002476e-26,  8.838849044808065e-28, -2.465024325492726e-29,  8.022048795389087e-04, -1.135258733199789e-05,
  1.338852694712878e-07, -1.473701959696389e-09,  1.564195074402870e-11, -1.623293571623143e-13,  1.658759157951420e-15, -1.674694777666979e-17,  1.669614123943965e-19,
 -1.627664795801743e-21,  1.494167579972289e-23, -1.120434329076564e-25,  1.083053376938047e-03, -1.532707966174497e-05,  1.807579411656777e-07, -1.989640167434282e-09,
  2.111826835670023e-11, -2.191704979437983e-13,  2.240123521350291e-15, -2.264358111409623e-17,  2.269374258263562e-19, -2.257994446813148e-21,  2.229705915874392e-23,
 -2.176853723597012e-25,  3.714792347862427e-04, -5.257074106773180e-06,  6.199863362338778e-08, -6.824326664369729e-10,  7.243495825670051e-12, -7.518040539938794e-14,
  7.687528094573037e-16, -7.788002106968132e-18,  7.881147672102816e-20, -8.132303163107095e-22,  9.012588581653438e-24, -1.174715620050417e-25,  3.975061816688046e-05,
 -5.625400516190264e-07,  6.634245626464763e-09, -7.302475761757220e-11,  7.751152123210718e-13, -8.045948514010764e-15,  8.233436255963045e-17, -8.372185501650151e-19,
  8.609143516051574e-21, -9.404984083364487e-23,  1.213165584274728e-24, -2.041561551053699e-26,  1.116598814233256e-06, -1.580180625434919e-08,  1.863566794295042e-10,
 -2.051280445907844e-12,  2.177380281028978e-14, -2.260675606249579e-16,  2.316291880914122e-18, -2.370410457788404e-20,  2.504006758129935e-22, -2.986991557342451e-24,
  4.639374755497145e-26, -9.655668050852714e-28,  4.208965719527386e-09, -5.956415362353743e-11,  7.024630140066128e-13, -7.732260295304129e-15,  8.208078902289672e-17,
 -8.525704497140483e-19,  8.757701657220943e-21, -9.077799425281685e-23,  1.010219765787518e-24, -1.396893696247387e-26,  2.731030276727724e-28, -6.823234019307640e-30,
  7.588303911615706e-04, -1.034822169700932e-05,  1.176019315401413e-07, -1.247389646857676e-09,  1.275838840394089e-11, -1.275926323516651e-13,  1.256602162112687e-15,
 -1.223575206702002e-17,  1.179772213650895e-19, -1.123610674686330e-21,  1.042795373265766e-23, -8.988168964983212e-26,  1.024493665563700e-03, -1.397108986572513e-05,
  1.587738672232930e-07, -1.684095740534627e-09,  1.722507568571931e-11, -1.722645601652955e-13,  1.696677718081751e-15, -1.652716800982133e-17,  1.596384674847388e-19,
 -1.531525756123798e-21,  1.460300401632671e-23, -1.382355647036380e-25,  3.513936902341133e-04, -4.791979684655293e-06,  5.445825442050091e-08, -5.776324828674065e-10,
  5.908091569968106e-12, -5.908691217451526e-14,  5.820394905492392e-16, -5.673609470856505e-18,  5.498275711216083e-20, -5.345849092529107e-22,  5.344166237704152e-24,
 -5.824773520694180e-26,  3.760133836198917e-05, -5.127720133657955e-07,  5.827376538910454e-09, -6.181034930182131e-11,  6.322063855527419e-13, -6.322929986838227e-15,
  6.229823998876370e-17, -6.079910034043069e-19,  5.924420835784460e-21, -5.887669308134269e-23,  6.325597376751178e-25, -8.202552634127179e-27,  1.056225330301131e-06,
 -1.440381686328517e-08,  1.636915986484834e-10, -1.736260499997263e-12,  1.775889951055487e-14, -1.776239894394730e-16,  1.750743747313743e-18, -1.712069331264424e-20,
  1.683918418782316e-22, -1.735076976178337e-24,  2.073715120232508e-26, -3.275026496926889e-28,  3.981390760473274e-09, -5.429449778517614e-11,  6.170277274530587e-13,
 -6.544762695389589e-15,  6.694248581358057e-17, -6.696355084895271e-19,  6.605148633855530e-21, -6.485249085458260e-23,  6.497418903548832e-25, -7.164690300044080e-27,
  1.012924821188974e-28, -2.002219767572658e-30,  7.192289899311040e-04, -9.463994509678272e-06,  1.037788570242468e-07, -1.062140905441679e-09,  1.048242563620687e-11,
 -1.011534673663078e-13,  9.613055374981301e-16, -9.034411113391037e-18,  8.415831482562515e-20, -7.772791379706070e-22,  7.087574884407560e-24, -6.270120947547564e-26,
  9.710279831131643e-04, -1.277729851188780e-05,  1.401113915074554e-07, -1.433991959710827e-09,  1.415228444267159e-11, -1.365673604496986e-13,  1.297886280426405e-15,
 -1.219904848701573e-17,  1.137032628038311e-19, -1.052778580963228e-21,  9.693372799068632e-24, -8.876259241978452e-26,  3.330553596954889e-04, -4.382518143009156e-06,
  4.805716314888110e-08, -4.918485941677706e-10,  4.854132119070431e-12, -4.684190043974192e-14,  4.451854304540119e-16, -4.185278280778913e-18,  3.905110531187377e-20,
 -3.632437079307675e-22,  3.404104393597207e-24, -3.307119392642595e-26,  3.563902147427783e-05, -4.689570479999965e-07,  5.142419235508233e-09, -5.263090517427249e-11,
  5.194234296892533e-13, -5.012433971687201e-15,  4.764121500676889e-17, -4.480461567338375e-19,  4.187951505020085e-21, -3.925427957408189e-23,  3.785288953896076e-25,
 -4.012986975542646e-27,  1.001103653834730e-06, -1.317305008070278e-08,  1.444510698290640e-10, -1.478407698260308e-12,  1.459068934192085e-14, -1.408023869940419e-16,
  1.338415464103032e-18, -1.259493801564422e-20,  1.180816625156544e-22, -1.121165456228732e-24,  1.132325552834783e-26, -1.358230510291082e-28,  3.773612241917538e-09,
 -4.965518100930178e-11,  5.445014031072662e-13, -5.572789423159392e-15,  5.499914686640476e-17, -5.307669063413149e-19,  5.046332666249492e-21, -4.754466002236230e-23,
  4.484024742616756e-25, -4.365874222093725e-27,  4.795255865329302e-29, -6.905514287185633e-31,  6.829565831994566e-04, -8.682041212122803e-06,  9.197655577712522e-08,
 -9.094339531337423e-10,  8.671049322573900e-12, -8.083740535244195e-14,  7.421991709760695e-16, -6.739332039706340e-18,  6.067558062121776e-20, -5.423432614865379e-22,
  4.809459711207684e-24, -4.206185142391011e-26,  9.220567619190789e-04, -1.172158670723598e-05,  1.241771546679126e-07, -1.227822904088774e-09,  1.170674794859727e-11,
 -1.091383405088202e-13,  1.002046753877846e-15, -9.099120116713139e-18,  8.193588319357291e-20, -7.329761540769244e-22,  6.521809935617375e-24, -5.775133618200341e-26,
  3.162585958777521e-04, -4.020416862485202e-06,  4.259183843943628e-08, -4.211341119139485e-10,  4.015328125127790e-12, -3.743370358594107e-14,  3.436988761584545e-16,
 -3.121168523325039e-18,  2.811481981708502e-20, -2.518879136327087e-22,  2.255092535104322e-24, -2.042198663896571e-26,  3.384166193879123e-05, -4.302099297997274e-07,
  4.557595019484029e-09, -4.506400429782776e-11,  4.296655517218948e-13, -4.005653787525555e-15,  3.677870643992352e-17, -3.340268943716655e-19,  3.010492581708201e-21,
 -2.703959885124801e-23,  2.445563305088928e-25, -2.295406708679647e-27,  9.506156458938738e-07, -1.208463967031701e-08,  1.280232974068691e-10, -1.265852427859455e-12,
  1.206935498149399e-14, -1.125197607551911e-16,  1.033153325729809e-18, -9.384841162783869e-21,  8.466131142242540e-23, -7.636447908254828e-25,  7.025243331955696e-27,
 -6.978756908187171e-29,  3.583300115597805e-09, -4.555247005674156e-11,  4.825776873546846e-13, -4.771570554753532e-15,  4.549490476511725e-17, -4.241417850506812e-19,
  3.894681269304681e-21, -3.539025073434174e-23,  3.198352860452038e-25, -2.908969331324775e-27,  2.764863381516151e-29, -3.033195346175754e-31,  6.496341014982970e-04,
 -7.987639958445965e-06,  8.184538515583316e-08, -7.827237509211715e-10,  7.218206122799508e-12, -6.508643535252871e-14,  5.779905084059701e-16, -5.076313598833005e-18,
  4.421017900954234e-20, -3.824336875756741e-22,  3.287855093028718e-24, -2.804782423841505e-26,  8.770682218961183e-04, -1.078407854422937e-05,  1.104991044606297e-07,
 -1.056751991128537e-09,  9.745269489836527e-12, -8.787293986278929e-14,  7.803439488393374e-16, -6.853589526982571e-18,  5.969187061913763e-20, -5.164889501503937e-22,
  4.445291911852519e-24, -3.808611788081629e-26,  3.008278620157061e-04, -3.698858550949518e-06,  3.790036912887081e-08, -3.624580571572251e-10,  3.342554962572348e-12,
 -3.013977708184612e-14,  2.676530614118610e-16, -2.350780723158348e-18,  2.047632773864930e-20, -1.772574050348923e-22,  1.528739749692193e-24, -1.320218213498277e-26,
  3.219047621397405e-05, -3.958011648547442e-07,  4.055578241520769e-09, -3.878529562113504e-11,  3.576744668824307e-13, -3.225148421340964e-15,  2.864072274118092e-17,
 -2.515572761611221e-19,  2.191531468661297e-21, -1.898638224747277e-23,  1.643031438684611e-25, -1.437510862500648e-27,  9.042336748396520e-07, -1.111809404247660e-08,
  1.139215958148497e-10, -1.089482821276052e-12,  1.004711271962363e-14, -9.059485204813981e-17,  8.045281823217118e-19, -7.066687672283347e-21,  6.158083946932671e-23,
 -5.342149330271845e-25,  4.649432000851242e-27, -4.156432589771421e-29,  3.408465498689982e-09, -4.190912262247662e-11,  4.294219960659814e-13, -4.106753376738316e-15,
  3.787211983194775e-17, -3.414937528095673e-19,  3.032683649480038e-21, -2.664055927706927e-23,  2.322749162004613e-25, -2.020180537915622e-27,  1.777792848783563e-29,
 -1.655053140717781e-31,  6.189362280689155e-04, -7.368578528609905e-06,  7.310500685731820e-08, -6.769381878155920e-10,  6.044457398100676e-12, -5.277231060640999e-14,
  4.537580588876545e-16, -3.858715790490630e-18,  3.254027859211827e-20, -2.725986129247901e-22,  2.270961139649741e-24, -1.881429357293048e-26,  8.356231542761428e-04,
 -9.948286355497405e-06,  9.869875708626625e-08, -9.139313526074857e-10,  8.160596136338294e-12, -7.124767530024588e-14,  6.126171105836981e-16, -5.209652427488135e-18,
  4.393331424978711e-20, -3.680699530479828e-22,  3.067399693357985e-24, -2.544941943764445e-26,  2.866125127736858e-04, -3.412188060563994e-06,  3.385293793445950e-08,
 -3.134716414022568e-10,  2.799023676674966e-12, -2.443742431370606e-14,  2.101232882224499e-16, -1.786882482187670e-18,  1.506931801366150e-20, -1.262677951828470e-22,
  1.052970288633651e-24, -8.759546613600119e-27,  3.066934429956472e-05, -3.651256165761548e-07,  3.622477606249379e-09, -3.354344031493644e-11,  2.995131711586288e-13,
 -2.614958828428279e-15,  2.248454808935213e-17, -1.912095337204308e-19,  1.612603359342676e-21, -1.351543189609163e-23,  1.128294296121416e-25, -9.427586076070782e-28,
  8.615049282447309e-07, -1.025641484341460e-08,  1.017557558581928e-10, -9.422385736426917e-13,  8.413355015287385e-15, -7.345447597322633e-17,  6.315947053041476e-19,
 -5.371181114553161e-21,  4.530246433561752e-23, -3.798368577297405e-25,  3.176699598978278e-27, -2.673957736435137e-29,  3.247401536320282e-09, -3.866106417766365e-11,
  3.835634448438338e-13, -3.551723162689505e-15,  3.171374046574878e-17, -2.768832864621895e-19,  2.380776707209795e-21, -2.024702503752845e-23,  1.707961493325324e-25,
 -1.433128557809822e-27,  1.202765540542856e-29, -1.026839414994186e-31  };
  int offset = -6;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 6;
    if (std::isnan(t)) {
      fill_n(rr+offset, 6, 0.5);
      fill_n(ww+offset, 6, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 6; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t*t*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;
      const double t2 = t * 2.0;
      for (int j=1; j <=6; ++j) {
        const int boxof = it*72+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
