{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdPoint: TMFVec3f;
    { Internal wrapper for property @link(Point). This wrapper API may change, we advise to access simpler @link(Point) instead. }
    public property FdPoint: TMFVec3f read FFdPoint;
    {  }
    procedure SetPoint(const Value: array of TVector3); overload;
    {  }
    procedure SetPoint(const Value: TVector3List); overload;

{$endif read_interface}

{$ifdef read_implementation}

{ TCoordinateNode ----------------------------------------------- }

procedure TCoordinateNode.SetPoint(const Value: array of TVector3);
begin
  FdPoint.Send(Value);
end;

procedure TCoordinateNode.SetPoint(const Value: TVector3List);
begin
  FdPoint.Send(Value);
end;

class function TCoordinateNode.ClassX3DType: String;
begin
  Result := 'Coordinate';
end;

procedure TCoordinateNode.CreateNode;
begin
  inherited;

  FFdPoint := TMFVec3f.Create(Self, True, 'point', []);
   FdPoint.ChangeAlways := chCoordinate;
  AddField(FFdPoint);
end;

{$endif read_implementation}
