{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetUpdate: TTextureUpdate;
    procedure SetUpdate(const Value: TTextureUpdate);
    function GetSize: Integer;
    procedure SetSize(const Value: Integer);
    function GetLight: TAbstractLightNode;
    procedure SetLight(const Value: TAbstractLightNode);
    function GetScale: Single;
    procedure SetScale(const Value: Single);
    function GetBias: Single;
    procedure SetBias(const Value: Single);
    function GetCompareMode: TShadowMapCompareMode;
    procedure SetCompareMode(const Value: TShadowMapCompareMode);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdUpdate: TSFStringEnum;
    { Internal wrapper for property @link(Update). This wrapper API may change, we advise to access simpler @link(Update) instead. }
    public property FdUpdate: TSFStringEnum read FFdUpdate;
    { When to update the texture contents. }
    property Update: TTextureUpdate read GetUpdate write SetUpdate;

    strict private FFdSize: TSFInt32;
    { Internal wrapper for property @link(Size). This wrapper API may change, we advise to access simpler @link(Size) instead. }
    public property FdSize: TSFInt32 read FFdSize;
    {  }
    property Size: Integer read GetSize write SetSize;

    strict private FFdLight: TSFNode;
    { Internal wrapper for property @link(Light). This wrapper API may change, we advise to access simpler @link(Light) instead. }
    public property FdLight: TSFNode read FFdLight;
    {  }
    property Light: TAbstractLightNode read GetLight write SetLight;

    strict private FFdScale: TSFFloat;
    { Internal wrapper for property @link(Scale). This wrapper API may change, we advise to access simpler @link(Scale) instead. }
    public property FdScale: TSFFloat read FFdScale;
    {  }
    property Scale: Single read GetScale write SetScale;

    strict private FFdBias: TSFFloat;
    { Internal wrapper for property @link(Bias). This wrapper API may change, we advise to access simpler @link(Bias) instead. }
    public property FdBias: TSFFloat read FFdBias;
    {  }
    property Bias: Single read GetBias write SetBias;

    strict private FFdCompareMode: TSFStringEnum;
    { Internal wrapper for property @link(CompareMode). This wrapper API may change, we advise to access simpler @link(CompareMode) instead. }
    public property FdCompareMode: TSFStringEnum read FFdCompareMode;
    {  }
    property CompareMode: TShadowMapCompareMode read GetCompareMode write SetCompareMode;

{$endif read_interface}

{$ifdef read_implementation}

{ TGeneratedShadowMapNode ----------------------------------------------- }

function TGeneratedShadowMapNode.GetUpdate: TTextureUpdate;
begin
  Result := TTextureUpdate(FdUpdate.EnumValue);
end;

procedure TGeneratedShadowMapNode.SetUpdate(const Value: TTextureUpdate);
begin
  FdUpdate.SendEnumValue(Ord(Value));
end;

function TGeneratedShadowMapNode.GetSize: Integer;
begin
  Result := FdSize.Value;
end;

procedure TGeneratedShadowMapNode.SetSize(const Value: Integer);
begin
  FdSize.Send(Value);
end;

function TGeneratedShadowMapNode.GetLight: TAbstractLightNode;
begin
  if FdLight.Value is TAbstractLightNode then
    Result := TAbstractLightNode(FdLight.Value)
  else
    Result := nil;
end;

procedure TGeneratedShadowMapNode.SetLight(const Value: TAbstractLightNode);
begin
  FdLight.Send(Value);
end;

function TGeneratedShadowMapNode.GetScale: Single;
begin
  Result := FdScale.Value;
end;

procedure TGeneratedShadowMapNode.SetScale(const Value: Single);
begin
  FdScale.Send(Value);
end;

function TGeneratedShadowMapNode.GetBias: Single;
begin
  Result := FdBias.Value;
end;

procedure TGeneratedShadowMapNode.SetBias(const Value: Single);
begin
  FdBias.Send(Value);
end;

function TGeneratedShadowMapNode.GetCompareMode: TShadowMapCompareMode;
begin
  Result := TShadowMapCompareMode(FdCompareMode.EnumValue);
end;

procedure TGeneratedShadowMapNode.SetCompareMode(const Value: TShadowMapCompareMode);
begin
  FdCompareMode.SendEnumValue(Ord(Value));
end;

class function TGeneratedShadowMapNode.ClassX3DType: String;
begin
  Result := 'GeneratedShadowMap';
end;

procedure TGeneratedShadowMapNode.CreateNode;
begin
  inherited;

  FFdUpdate := TSFStringEnum.Create(Self, True, 'update', @TextureUpdateNames, Ord(High(TextureUpdateNames)) + 1, Ord(upNone));
   FdUpdate.ChangeAlways := chRedisplay;
  AddField(FFdUpdate);

  FFdSize := TSFInt32.Create(Self, False, 'size', 128);
   FdSize.ChangeAlways := chTextureRendererProperties;
   FdSize.MustBeNonnegative := true;
  AddField(FFdSize);

  FFdLight := TSFNode.Create(Self, False, 'light', [TAbstractLightNode]);
   FdLight.ChangeAlways := chGeneratedTextureUpdateNeeded;
   FdLight.WeakLink := true;
  AddField(FFdLight);

  FFdScale := TSFFloat.Create(Self, True, 'scale', DefaultScale);
   FdScale.ChangeAlways := chGeneratedTextureUpdateNeeded;
   FdScale.MustBeNonnegative := true;
  AddField(FFdScale);

  FFdBias := TSFFloat.Create(Self, True, 'bias', DefaultBias);
   FdBias.ChangeAlways := chGeneratedTextureUpdateNeeded;
   FdBias.MustBeNonnegative := true;
  AddField(FFdBias);

  FFdCompareMode := TSFStringEnum.Create(Self, False, 'compareMode', @CompareModeNames, Ord(High(CompareModeNames)) + 1, Ord(smCompareRLEqual));
   FdCompareMode.ChangeAlways := chTextureRendererProperties;
  AddField(FFdCompareMode);
end;

{$endif read_implementation}
