{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetCenter: TVector3;
    procedure SetCenter(const Value: TVector3);
    function GetLimitOrientation: TVector4;
    procedure SetLimitOrientation(const Value: TVector4);
    function GetNameField: String;
    procedure SetNameField(const Value: String);
    function GetRotation: TVector4;
    procedure SetRotation(const Value: TVector4);
    function GetScale: TVector3;
    procedure SetScale(const Value: TVector3);
    function GetScaleOrientation: TVector4;
    procedure SetScaleOrientation(const Value: TVector4);
    function GetTranslation: TVector3;
    procedure SetTranslation(const Value: TVector3);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdCenter: TSFVec3f;
    { Internal wrapper for property @link(Center). This wrapper API may change, we advise to access simpler @link(Center) instead. }
    public property FdCenter: TSFVec3f read FFdCenter;
    {  }
    property Center: TVector3 read GetCenter write SetCenter;

    strict private FFdDisplacers: TMFNode;
    { Internal wrapper for property @link(Displacers). This wrapper API may change, we advise to access simpler @link(Displacers) instead. }
    public property FdDisplacers: TMFNode read FFdDisplacers;
    {  }
    procedure SetDisplacers(const Value: array of THAnimDisplacerNode);

    strict private FFdLimitOrientation: TSFRotation;
    { Internal wrapper for property @link(LimitOrientation). This wrapper API may change, we advise to access simpler @link(LimitOrientation) instead. }
    public property FdLimitOrientation: TSFRotation read FFdLimitOrientation;
    {  }
    property LimitOrientation: TVector4 read GetLimitOrientation write SetLimitOrientation;

    strict private FFdLlimit: TMFFloat;
    { Internal wrapper for property @link(Llimit). This wrapper API may change, we advise to access simpler @link(Llimit) instead. }
    public property FdLlimit: TMFFloat read FFdLlimit;
    {  }
    procedure SetLlimit(const Value: array of Single); overload;
    {  }
    procedure SetLlimit(const Value: TSingleList); overload;

    strict private FFdName: TSFString;
    { Internal wrapper for property @link(NameField). This wrapper API may change, we advise to access simpler @link(NameField) instead. }
    public property FdName: TSFString read FFdName;
    {  }
    property NameField: String read GetNameField write SetNameField;

    strict private FFdRotation: TSFRotation;
    { Internal wrapper for property @link(Rotation). This wrapper API may change, we advise to access simpler @link(Rotation) instead. }
    public property FdRotation: TSFRotation read FFdRotation;
    {  }
    property Rotation: TVector4 read GetRotation write SetRotation;

    strict private FFdScale: TSFVec3f;
    { Internal wrapper for property @link(Scale). This wrapper API may change, we advise to access simpler @link(Scale) instead. }
    public property FdScale: TSFVec3f read FFdScale;
    {  }
    property Scale: TVector3 read GetScale write SetScale;

    strict private FFdScaleOrientation: TSFRotation;
    { Internal wrapper for property @link(ScaleOrientation). This wrapper API may change, we advise to access simpler @link(ScaleOrientation) instead. }
    public property FdScaleOrientation: TSFRotation read FFdScaleOrientation;
    {  }
    property ScaleOrientation: TVector4 read GetScaleOrientation write SetScaleOrientation;

    strict private FFdSkinCoordIndex: TMFInt32;
    { Internal wrapper for property @link(SkinCoordIndex). This wrapper API may change, we advise to access simpler @link(SkinCoordIndex) instead. }
    public property FdSkinCoordIndex: TMFInt32 read FFdSkinCoordIndex;
    {  }
    procedure SetSkinCoordIndex(const Value: array of LongInt); overload;
    {  }
    procedure SetSkinCoordIndex(const Value: TLongIntList); overload;

    strict private FFdSkinCoordWeight: TMFFloat;
    { Internal wrapper for property @link(SkinCoordWeight). This wrapper API may change, we advise to access simpler @link(SkinCoordWeight) instead. }
    public property FdSkinCoordWeight: TMFFloat read FFdSkinCoordWeight;
    {  }
    procedure SetSkinCoordWeight(const Value: array of Single); overload;
    {  }
    procedure SetSkinCoordWeight(const Value: TSingleList); overload;

    strict private FFdStiffness: TMFFloat;
    { Internal wrapper for property @link(Stiffness). This wrapper API may change, we advise to access simpler @link(Stiffness) instead. }
    public property FdStiffness: TMFFloat read FFdStiffness;
    {  }
    procedure SetStiffness(const Value: array of Single); overload;
    {  }
    procedure SetStiffness(const Value: TSingleList); overload;

    strict private FFdTranslation: TSFVec3f;
    { Internal wrapper for property @link(Translation). This wrapper API may change, we advise to access simpler @link(Translation) instead. }
    public property FdTranslation: TSFVec3f read FFdTranslation;
    {  }
    property Translation: TVector3 read GetTranslation write SetTranslation;

    strict private FFdUlimit: TMFFloat;
    { Internal wrapper for property @link(Ulimit). This wrapper API may change, we advise to access simpler @link(Ulimit) instead. }
    public property FdUlimit: TMFFloat read FFdUlimit;
    {  }
    procedure SetUlimit(const Value: array of Single); overload;
    {  }
    procedure SetUlimit(const Value: TSingleList); overload;

{$endif read_interface}

{$ifdef read_implementation}

{ THAnimJointNode ----------------------------------------------- }

function THAnimJointNode.GetCenter: TVector3;
begin
  Result := FdCenter.Value;
end;

procedure THAnimJointNode.SetCenter(const Value: TVector3);
begin
  FdCenter.Send(Value);
end;

procedure THAnimJointNode.SetDisplacers(const Value: array of THAnimDisplacerNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(THAnimDisplacerNode));
  FdDisplacers.Send(A);
end;

function THAnimJointNode.GetLimitOrientation: TVector4;
begin
  Result := FdLimitOrientation.Value;
end;

procedure THAnimJointNode.SetLimitOrientation(const Value: TVector4);
begin
  FdLimitOrientation.Send(Value);
end;

procedure THAnimJointNode.SetLlimit(const Value: array of Single);
begin
  FdLlimit.Send(Value);
end;

procedure THAnimJointNode.SetLlimit(const Value: TSingleList);
begin
  FdLlimit.Send(Value);
end;

function THAnimJointNode.GetNameField: String;
begin
  Result := FdName.Value;
end;

procedure THAnimJointNode.SetNameField(const Value: String);
begin
  FdName.Send(Value);
end;

function THAnimJointNode.GetRotation: TVector4;
begin
  Result := FdRotation.Value;
end;

procedure THAnimJointNode.SetRotation(const Value: TVector4);
begin
  FdRotation.Send(Value);
end;

function THAnimJointNode.GetScale: TVector3;
begin
  Result := FdScale.Value;
end;

procedure THAnimJointNode.SetScale(const Value: TVector3);
begin
  FdScale.Send(Value);
end;

function THAnimJointNode.GetScaleOrientation: TVector4;
begin
  Result := FdScaleOrientation.Value;
end;

procedure THAnimJointNode.SetScaleOrientation(const Value: TVector4);
begin
  FdScaleOrientation.Send(Value);
end;

procedure THAnimJointNode.SetSkinCoordIndex(const Value: array of LongInt);
begin
  FdSkinCoordIndex.Send(Value);
end;

procedure THAnimJointNode.SetSkinCoordIndex(const Value: TLongIntList);
begin
  FdSkinCoordIndex.Send(Value);
end;

procedure THAnimJointNode.SetSkinCoordWeight(const Value: array of Single);
begin
  FdSkinCoordWeight.Send(Value);
end;

procedure THAnimJointNode.SetSkinCoordWeight(const Value: TSingleList);
begin
  FdSkinCoordWeight.Send(Value);
end;

procedure THAnimJointNode.SetStiffness(const Value: array of Single);
begin
  FdStiffness.Send(Value);
end;

procedure THAnimJointNode.SetStiffness(const Value: TSingleList);
begin
  FdStiffness.Send(Value);
end;

function THAnimJointNode.GetTranslation: TVector3;
begin
  Result := FdTranslation.Value;
end;

procedure THAnimJointNode.SetTranslation(const Value: TVector3);
begin
  FdTranslation.Send(Value);
end;

procedure THAnimJointNode.SetUlimit(const Value: array of Single);
begin
  FdUlimit.Send(Value);
end;

procedure THAnimJointNode.SetUlimit(const Value: TSingleList);
begin
  FdUlimit.Send(Value);
end;

class function THAnimJointNode.ClassX3DType: String;
begin
  Result := 'HAnimJoint';
end;

procedure THAnimJointNode.CreateNode;
begin
  inherited;

  FFdCenter := TSFVec3f.Create(Self, True, 'center', Vector3(0, 0, 0));
   FdCenter.ChangeAlways := chTransform;
  AddField(FFdCenter);

  FFdDisplacers := TMFNode.Create(Self, True, 'displacers', [THAnimDisplacerNode]);
   FdDisplacers.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDisplacers);

  FFdLimitOrientation := TSFRotation.Create(Self, True, 'limitOrientation', Vector3(0, 0, 1), 0);
   FdLimitOrientation.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdLimitOrientation);

  FFdLlimit := TMFFloat.Create(Self, True, 'llimit', []);
   FdLlimit.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdLlimit);

  FFdName := TSFString.Create(Self, True, 'name', '');
   FdName.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdName);

  FFdRotation := TSFRotation.Create(Self, True, 'rotation', Vector3(0, 0, 1), 0);
   FdRotation.ChangeAlways := chTransform;
  AddField(FFdRotation);

  FFdScale := TSFVec3f.Create(Self, True, 'scale', Vector3(1, 1, 1));
   FdScale.ChangeAlways := chTransform;
  AddField(FFdScale);

  FFdScaleOrientation := TSFRotation.Create(Self, True, 'scaleOrientation', Vector3(0, 0, 1), 0);
   FdScaleOrientation.ChangeAlways := chTransform;
  AddField(FFdScaleOrientation);

  FFdSkinCoordIndex := TMFInt32.Create(Self, True, 'skinCoordIndex', []);
   FdSkinCoordIndex.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSkinCoordIndex);

  FFdSkinCoordWeight := TMFFloat.Create(Self, True, 'skinCoordWeight', []);
   FdSkinCoordWeight.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSkinCoordWeight);

  FFdStiffness := TMFFloat.Create(Self, True, 'stiffness', [0, 0, 0]);
   FdStiffness.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdStiffness);

  FFdTranslation := TSFVec3f.Create(Self, True, 'translation', Vector3(0, 0, 0));
   FdTranslation.ChangeAlways := chTransform;
  AddField(FFdTranslation);

  FFdUlimit := TMFFloat.Create(Self, True, 'ulimit', []);
   FdUlimit.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdUlimit);
end;

{$endif read_implementation}
