!! NOTES
!!  This file has been automatically generated by the @SCRIPT@
!!  script. Any change you would bring to it will systematically be
!!  overwritten. See the template file in config/etsf/template.utils_check.

!!****m* etsf_io_file/etsf_io_file_check_dielectric_function_data
!! NAME
!!  etsf_io_file_check_dielectric_function_data
!!
!! FUNCTION
!!  This is a high level routine to inquire a file about a specifications.
!!  It returns .true. in lstat if the file is a valid 'dielectric_function_data' file.
!!  It tests the existence of variables and their definition (type, shape.
!!  and dimension names).
!!
!! COPYRIGHT
!!  Copyright (C) 2006-2010 (Damien Caliste)
!!  This file is distributed under the terms of the
!!  GNU Lesser General Public License, see the COPYING file
!!  or http://www.gnu.org/copyleft/lesser.txt .
!!
!! INPUTS
!! * ncid = 
!!     an identificator of an opened ETSF file (use etsf_io_low_open_read()
!!     for instance).
!! OUTPUT
!! * lstat = 
!!     return .true. if the file matches requirement of 'dielectric_function_data'.
!! * error_data <type(etsf_io_low_error)> = 
!!     contains the details of the error is @lstat is false.
!!
!! SOURCE
subroutine etsf_io_file_check_dielectric_function_data(ncid, lstat, error_data)
  integer, intent(in)                  :: ncid
  logical, intent(out)                 :: lstat
  type(etsf_io_low_error), intent(out) :: error_data

  character(len = *), parameter        :: me = "etsf_io_file_check_dielectric_function_data"
  type(etsf_io_low_var_infos)          :: var_infos
  logical                              :: valid
  character(len = etsf_charlen)        :: string_value
  type(etsf_dims)                      :: dims
  type(etsf_split)                     :: split

  ! Read the dimensions
  call etsf_io_dims_get(ncid, dims, lstat, error_data)
  if (.not. lstat) then
     call etsf_io_low_error_update(error_data, me)
     return
  end if

  ! Allocate the split and read it (this will verify variable exist.
  call etsf_io_split_allocate(split, dims)
  call etsf_io_split_get(ncid, split, lstat, error_data)
  if (.not. lstat) then
     call etsf_io_low_error_update(error_data, me)
     return
  end if

  ! Variable basis_set
  write(var_infos%name, "(A)") "basis_set"
  var_infos%nctype  = etsf_io_low_character
  var_infos%ncshape = 1
  allocate(var_infos%ncdimnames(1))
  write(var_infos%ncdimnames(1), "(A)") "character_string_length"
  call test_var(ncid, var_infos, lstat, error_data)
  deallocate(var_infos%ncdimnames)
  if (.not. lstat) then
    call etsf_io_split_free(split)
    call etsf_io_low_error_update(error_data, me)
    return
  end if
  
  ! Variable frequencies_dielectric_function
  write(var_infos%name, "(A)") "frequencies_dielectric_function"
  var_infos%nctype  = etsf_io_low_double
  var_infos%ncshape = 2
  allocate(var_infos%ncdimnames(2))
  write(var_infos%ncdimnames(2), "(A)") "number_of_frequencies_dielectric_function"
  write(var_infos%ncdimnames(1), "(A)") "complex"
  call test_var(ncid, var_infos, lstat, error_data)
  deallocate(var_infos%ncdimnames)
  if (.not. lstat) then
    call etsf_io_split_free(split)
    call etsf_io_low_error_update(error_data, me)
    return
  end if
  
  ! Variable qpoints_dielectric_function
  write(var_infos%name, "(A)") "qpoints_dielectric_function"
  var_infos%nctype  = etsf_io_low_double
  var_infos%ncshape = 2
  allocate(var_infos%ncdimnames(2))
  write(var_infos%ncdimnames(2), "(A)") "number_of_qpoints_dielectric_function"
  write(var_infos%ncdimnames(1), "(A)") "number_of_reduced_dimensions"
  call test_var(ncid, var_infos, lstat, error_data)
  deallocate(var_infos%ncdimnames)
  if (.not. lstat) then
    call etsf_io_split_free(split)
    call etsf_io_low_error_update(error_data, me)
    return
  end if
  
  ! Variable qpoints_gamma_limit
  write(var_infos%name, "(A)") "qpoints_gamma_limit"
  var_infos%nctype  = etsf_io_low_double
  var_infos%ncshape = 2
  allocate(var_infos%ncdimnames(2))
  write(var_infos%ncdimnames(2), "(A)") "number_of_qpoints_gamma_limit"
  write(var_infos%ncdimnames(1), "(A)") "number_of_reduced_dimensions"
  call test_var(ncid, var_infos, lstat, error_data)
  deallocate(var_infos%ncdimnames)
  if (.not. lstat) then
    call etsf_io_split_free(split)
    call etsf_io_low_error_update(error_data, me)
    return
  end if
  
  ! Variable reduced_coordinates_of_plane_waves_dielectric_function
  write(var_infos%name, "(A)") "reduced_coordinates_of_plane_waves_dielectric_function"
  var_infos%nctype  = etsf_io_low_integer
  var_infos%ncshape = 3
  allocate(var_infos%ncdimnames(3))
  write(var_infos%ncdimnames(3), "(A)") "number_of_qpoints_dielectric_function"
  write(var_infos%ncdimnames(2), "(A)") "number_of_coefficients_dielectric_function"
  write(var_infos%ncdimnames(1), "(A)") "number_of_reduced_dimensions"
  call test_var(ncid, var_infos, lstat, error_data)
  deallocate(var_infos%ncdimnames)
  if (.not. lstat) then
    call etsf_io_split_free(split)
    call etsf_io_low_error_update(error_data, me)
    return
  end if
  
  ! Check from a list.
  lstat = .false.
  ! Variable dielectric_function
  write(var_infos%name, "(A)") "dielectric_function"
  var_infos%nctype  = etsf_io_low_double
  var_infos%ncshape = 7
  allocate(var_infos%ncdimnames(7))
  write(var_infos%ncdimnames(7), "(A)") "number_of_frequencies_dielectric_function"
  write(var_infos%ncdimnames(6), "(A)") "number_of_qpoints_dielectric_function"
  if (associated(split%my_spins)) then
    write(var_infos%ncdimnames(5), "(A)") "my_number_of_spins"
  else
    write(var_infos%ncdimnames(5), "(A)") "number_of_spins"
  end if
  if (associated(split%my_spins)) then
    write(var_infos%ncdimnames(4), "(A)") "my_number_of_spins"
  else
    write(var_infos%ncdimnames(4), "(A)") "number_of_spins"
  end if
  write(var_infos%ncdimnames(3), "(A)") "number_of_coefficients_dielectric_function"
  write(var_infos%ncdimnames(2), "(A)") "number_of_coefficients_dielectric_function"
  write(var_infos%ncdimnames(1), "(A)") "complex"
  call test_var(ncid, var_infos, valid, error_data)
  deallocate(var_infos%ncdimnames)
  if (.not. valid .and. error_data%access_mode_id == ERROR_MODE_SPEC) return
  lstat = lstat .or. valid
  ! Variable inverse_dielectric_function
  write(var_infos%name, "(A)") "inverse_dielectric_function"
  var_infos%nctype  = etsf_io_low_double
  var_infos%ncshape = 7
  allocate(var_infos%ncdimnames(7))
  write(var_infos%ncdimnames(7), "(A)") "number_of_frequencies_dielectric_function"
  write(var_infos%ncdimnames(6), "(A)") "number_of_qpoints_dielectric_function"
  if (associated(split%my_spins)) then
    write(var_infos%ncdimnames(5), "(A)") "my_number_of_spins"
  else
    write(var_infos%ncdimnames(5), "(A)") "number_of_spins"
  end if
  if (associated(split%my_spins)) then
    write(var_infos%ncdimnames(4), "(A)") "my_number_of_spins"
  else
    write(var_infos%ncdimnames(4), "(A)") "number_of_spins"
  end if
  write(var_infos%ncdimnames(3), "(A)") "number_of_coefficients_dielectric_function"
  write(var_infos%ncdimnames(2), "(A)") "number_of_coefficients_dielectric_function"
  write(var_infos%ncdimnames(1), "(A)") "complex"
  call test_var(ncid, var_infos, valid, error_data)
  deallocate(var_infos%ncdimnames)
  if (.not. valid .and. error_data%access_mode_id == ERROR_MODE_SPEC) return
  lstat = lstat .or. valid
  ! Variable polarizability
  write(var_infos%name, "(A)") "polarizability"
  var_infos%nctype  = etsf_io_low_double
  var_infos%ncshape = 7
  allocate(var_infos%ncdimnames(7))
  write(var_infos%ncdimnames(7), "(A)") "number_of_frequencies_dielectric_function"
  write(var_infos%ncdimnames(6), "(A)") "number_of_qpoints_dielectric_function"
  if (associated(split%my_spins)) then
    write(var_infos%ncdimnames(5), "(A)") "my_number_of_spins"
  else
    write(var_infos%ncdimnames(5), "(A)") "number_of_spins"
  end if
  if (associated(split%my_spins)) then
    write(var_infos%ncdimnames(4), "(A)") "my_number_of_spins"
  else
    write(var_infos%ncdimnames(4), "(A)") "number_of_spins"
  end if
  write(var_infos%ncdimnames(3), "(A)") "number_of_coefficients_dielectric_function"
  write(var_infos%ncdimnames(2), "(A)") "number_of_coefficients_dielectric_function"
  write(var_infos%ncdimnames(1), "(A)") "complex"
  call test_var(ncid, var_infos, valid, error_data)
  deallocate(var_infos%ncdimnames)
  if (.not. valid .and. error_data%access_mode_id == ERROR_MODE_SPEC) return
  lstat = lstat .or. valid
  ! Variable inverse_polarizability
  write(var_infos%name, "(A)") "inverse_polarizability"
  var_infos%nctype  = etsf_io_low_double
  var_infos%ncshape = 7
  allocate(var_infos%ncdimnames(7))
  write(var_infos%ncdimnames(7), "(A)") "number_of_frequencies_dielectric_function"
  write(var_infos%ncdimnames(6), "(A)") "number_of_qpoints_dielectric_function"
  if (associated(split%my_spins)) then
    write(var_infos%ncdimnames(5), "(A)") "my_number_of_spins"
  else
    write(var_infos%ncdimnames(5), "(A)") "number_of_spins"
  end if
  if (associated(split%my_spins)) then
    write(var_infos%ncdimnames(4), "(A)") "my_number_of_spins"
  else
    write(var_infos%ncdimnames(4), "(A)") "number_of_spins"
  end if
  write(var_infos%ncdimnames(3), "(A)") "number_of_coefficients_dielectric_function"
  write(var_infos%ncdimnames(2), "(A)") "number_of_coefficients_dielectric_function"
  write(var_infos%ncdimnames(1), "(A)") "complex"
  call test_var(ncid, var_infos, valid, error_data)
  deallocate(var_infos%ncdimnames)
  if (.not. valid .and. error_data%access_mode_id == ERROR_MODE_SPEC) return
  lstat = lstat .or. valid
  if (.not. lstat) then
    call etsf_io_split_free(split)
    call etsf_io_low_error_set(error_data, ERROR_MODE_SPEC, &
                             & ERROR_TYPE_ARG, me, &
   & tgtname = "dielectric_function, inverse_dielectric_function, polarizability, inverse_...", &
                             & errmess = "missing one among the list.")
    return
  end if
  
  ! Check a list of conditions if a variable is set.
  ! Test the existence of a variable.
  lstat = .false.
  call etsf_io_low_read_var_infos(ncid, "dielectric_function", var_infos, &
                                & lstat, error_data = error_data)
  if (lstat) then
    ! Apply the conditions since variable exists.
    ! Variable dielectric_function_head
    write(var_infos%name, "(A)") "dielectric_function_head"
    var_infos%nctype  = etsf_io_low_double
    var_infos%ncshape = 5
    allocate(var_infos%ncdimnames(5))
    write(var_infos%ncdimnames(5), "(A)") "number_of_frequencies_dielectric_function"
    write(var_infos%ncdimnames(4), "(A)") "number_of_qpoints_dielectric_function"
    if (associated(split%my_spins)) then
      write(var_infos%ncdimnames(3), "(A)") "my_number_of_spins"
    else
      write(var_infos%ncdimnames(3), "(A)") "number_of_spins"
    end if
    if (associated(split%my_spins)) then
      write(var_infos%ncdimnames(2), "(A)") "my_number_of_spins"
    else
      write(var_infos%ncdimnames(2), "(A)") "number_of_spins"
    end if
    write(var_infos%ncdimnames(1), "(A)") "complex"
    call test_var(ncid, var_infos, lstat, error_data)
    deallocate(var_infos%ncdimnames)
    if (.not. lstat) then
      call etsf_io_split_free(split)
      call etsf_io_low_error_update(error_data, me)
      return
    end if
    
    ! Variable dielectric_function_upper_wing
    write(var_infos%name, "(A)") "dielectric_function_upper_wing"
    var_infos%nctype  = etsf_io_low_double
    var_infos%ncshape = 6
    allocate(var_infos%ncdimnames(6))
    write(var_infos%ncdimnames(6), "(A)") "number_of_frequencies_dielectric_function"
    write(var_infos%ncdimnames(5), "(A)") "number_of_qpoints_gamma_limit"
    if (associated(split%my_spins)) then
      write(var_infos%ncdimnames(4), "(A)") "my_number_of_spins"
    else
      write(var_infos%ncdimnames(4), "(A)") "number_of_spins"
    end if
    if (associated(split%my_spins)) then
      write(var_infos%ncdimnames(3), "(A)") "my_number_of_spins"
    else
      write(var_infos%ncdimnames(3), "(A)") "number_of_spins"
    end if
    write(var_infos%ncdimnames(2), "(A)") "number_of_coefficients_dielectric_function"
    write(var_infos%ncdimnames(1), "(A)") "complex"
    call test_var(ncid, var_infos, lstat, error_data)
    deallocate(var_infos%ncdimnames)
    if (.not. lstat) then
      call etsf_io_split_free(split)
      call etsf_io_low_error_update(error_data, me)
      return
    end if
    
  end if
  ! Check a list of conditions if a variable is set.
  ! Test the existence of a variable.
  lstat = .false.
  call etsf_io_low_read_var_infos(ncid, "inverse_dielectric_function", var_infos, &
                                & lstat, error_data = error_data)
  if (lstat) then
    ! Apply the conditions since variable exists.
    ! Variable inverse_dielectric_function_head
    write(var_infos%name, "(A)") "inverse_dielectric_function_head"
    var_infos%nctype  = etsf_io_low_double
    var_infos%ncshape = 5
    allocate(var_infos%ncdimnames(5))
    write(var_infos%ncdimnames(5), "(A)") "number_of_frequencies_dielectric_function"
    write(var_infos%ncdimnames(4), "(A)") "number_of_qpoints_dielectric_function"
    if (associated(split%my_spins)) then
      write(var_infos%ncdimnames(3), "(A)") "my_number_of_spins"
    else
      write(var_infos%ncdimnames(3), "(A)") "number_of_spins"
    end if
    if (associated(split%my_spins)) then
      write(var_infos%ncdimnames(2), "(A)") "my_number_of_spins"
    else
      write(var_infos%ncdimnames(2), "(A)") "number_of_spins"
    end if
    write(var_infos%ncdimnames(1), "(A)") "complex"
    call test_var(ncid, var_infos, lstat, error_data)
    deallocate(var_infos%ncdimnames)
    if (.not. lstat) then
      call etsf_io_split_free(split)
      call etsf_io_low_error_update(error_data, me)
      return
    end if
    
    ! Variable inverse_dielectric_function_upper_wing
    write(var_infos%name, "(A)") "inverse_dielectric_function_upper_wing"
    var_infos%nctype  = etsf_io_low_double
    var_infos%ncshape = 6
    allocate(var_infos%ncdimnames(6))
    write(var_infos%ncdimnames(6), "(A)") "number_of_frequencies_dielectric_function"
    write(var_infos%ncdimnames(5), "(A)") "number_of_qpoints_gamma_limit"
    if (associated(split%my_spins)) then
      write(var_infos%ncdimnames(4), "(A)") "my_number_of_spins"
    else
      write(var_infos%ncdimnames(4), "(A)") "number_of_spins"
    end if
    if (associated(split%my_spins)) then
      write(var_infos%ncdimnames(3), "(A)") "my_number_of_spins"
    else
      write(var_infos%ncdimnames(3), "(A)") "number_of_spins"
    end if
    write(var_infos%ncdimnames(2), "(A)") "number_of_coefficients_dielectric_function"
    write(var_infos%ncdimnames(1), "(A)") "complex"
    call test_var(ncid, var_infos, lstat, error_data)
    deallocate(var_infos%ncdimnames)
    if (.not. lstat) then
      call etsf_io_split_free(split)
      call etsf_io_low_error_update(error_data, me)
      return
    end if
    
  end if
  ! Check a list of conditions if a variable is set.
  ! Test the existence of a variable.
  lstat = .false.
  call etsf_io_low_read_var_infos(ncid, "polarizability", var_infos, &
                                & lstat, error_data = error_data)
  if (lstat) then
    ! Apply the conditions since variable exists.
    ! Variable polarizability_head
    write(var_infos%name, "(A)") "polarizability_head"
    var_infos%nctype  = etsf_io_low_double
    var_infos%ncshape = 5
    allocate(var_infos%ncdimnames(5))
    write(var_infos%ncdimnames(5), "(A)") "number_of_frequencies_dielectric_function"
    write(var_infos%ncdimnames(4), "(A)") "number_of_qpoints_dielectric_function"
    if (associated(split%my_spins)) then
      write(var_infos%ncdimnames(3), "(A)") "my_number_of_spins"
    else
      write(var_infos%ncdimnames(3), "(A)") "number_of_spins"
    end if
    if (associated(split%my_spins)) then
      write(var_infos%ncdimnames(2), "(A)") "my_number_of_spins"
    else
      write(var_infos%ncdimnames(2), "(A)") "number_of_spins"
    end if
    write(var_infos%ncdimnames(1), "(A)") "complex"
    call test_var(ncid, var_infos, lstat, error_data)
    deallocate(var_infos%ncdimnames)
    if (.not. lstat) then
      call etsf_io_split_free(split)
      call etsf_io_low_error_update(error_data, me)
      return
    end if
    
    ! Variable polarizability_upper_wing
    write(var_infos%name, "(A)") "polarizability_upper_wing"
    var_infos%nctype  = etsf_io_low_double
    var_infos%ncshape = 6
    allocate(var_infos%ncdimnames(6))
    write(var_infos%ncdimnames(6), "(A)") "number_of_frequencies_dielectric_function"
    write(var_infos%ncdimnames(5), "(A)") "number_of_qpoints_gamma_limit"
    if (associated(split%my_spins)) then
      write(var_infos%ncdimnames(4), "(A)") "my_number_of_spins"
    else
      write(var_infos%ncdimnames(4), "(A)") "number_of_spins"
    end if
    if (associated(split%my_spins)) then
      write(var_infos%ncdimnames(3), "(A)") "my_number_of_spins"
    else
      write(var_infos%ncdimnames(3), "(A)") "number_of_spins"
    end if
    write(var_infos%ncdimnames(2), "(A)") "number_of_coefficients_dielectric_function"
    write(var_infos%ncdimnames(1), "(A)") "complex"
    call test_var(ncid, var_infos, lstat, error_data)
    deallocate(var_infos%ncdimnames)
    if (.not. lstat) then
      call etsf_io_split_free(split)
      call etsf_io_low_error_update(error_data, me)
      return
    end if
    
  end if
  ! Check a list of conditions if a variable is set.
  ! Test the existence of a variable.
  lstat = .false.
  call etsf_io_low_read_var_infos(ncid, "inverse_polarizability", var_infos, &
                                & lstat, error_data = error_data)
  if (lstat) then
    ! Apply the conditions since variable exists.
    ! Variable inverse_polarizability_head
    write(var_infos%name, "(A)") "inverse_polarizability_head"
    var_infos%nctype  = etsf_io_low_double
    var_infos%ncshape = 5
    allocate(var_infos%ncdimnames(5))
    write(var_infos%ncdimnames(5), "(A)") "number_of_frequencies_dielectric_function"
    write(var_infos%ncdimnames(4), "(A)") "number_of_qpoints_dielectric_function"
    if (associated(split%my_spins)) then
      write(var_infos%ncdimnames(3), "(A)") "my_number_of_spins"
    else
      write(var_infos%ncdimnames(3), "(A)") "number_of_spins"
    end if
    if (associated(split%my_spins)) then
      write(var_infos%ncdimnames(2), "(A)") "my_number_of_spins"
    else
      write(var_infos%ncdimnames(2), "(A)") "number_of_spins"
    end if
    write(var_infos%ncdimnames(1), "(A)") "complex"
    call test_var(ncid, var_infos, lstat, error_data)
    deallocate(var_infos%ncdimnames)
    if (.not. lstat) then
      call etsf_io_split_free(split)
      call etsf_io_low_error_update(error_data, me)
      return
    end if
    
    ! Variable inverse_polarizability_upper_wing
    write(var_infos%name, "(A)") "inverse_polarizability_upper_wing"
    var_infos%nctype  = etsf_io_low_double
    var_infos%ncshape = 6
    allocate(var_infos%ncdimnames(6))
    write(var_infos%ncdimnames(6), "(A)") "number_of_frequencies_dielectric_function"
    write(var_infos%ncdimnames(5), "(A)") "number_of_qpoints_gamma_limit"
    if (associated(split%my_spins)) then
      write(var_infos%ncdimnames(4), "(A)") "my_number_of_spins"
    else
      write(var_infos%ncdimnames(4), "(A)") "number_of_spins"
    end if
    if (associated(split%my_spins)) then
      write(var_infos%ncdimnames(3), "(A)") "my_number_of_spins"
    else
      write(var_infos%ncdimnames(3), "(A)") "number_of_spins"
    end if
    write(var_infos%ncdimnames(2), "(A)") "number_of_coefficients_dielectric_function"
    write(var_infos%ncdimnames(1), "(A)") "complex"
    call test_var(ncid, var_infos, lstat, error_data)
    deallocate(var_infos%ncdimnames)
    if (.not. lstat) then
      call etsf_io_split_free(split)
      call etsf_io_low_error_update(error_data, me)
      return
    end if
    
  end if


  ! Deallocate the split data.
  call etsf_io_split_free(split)

  lstat = .true.
end subroutine etsf_io_file_check_dielectric_function_data
!!***


