// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// MachineConfiguration Describes the number of vCPUs, memory size, Hyperthreading capabilities and the CPU template.
// swagger:model MachineConfiguration
type MachineConfiguration struct {

	// cpu template
	CPUTemplate CPUTemplate `json:"cpu_template,omitempty"`

	// Flag for enabling/disabling Hyperthreading
	// Required: true
	HtEnabled *bool `json:"ht_enabled"`

	// Memory size of VM
	// Required: true
	MemSizeMib *int64 `json:"mem_size_mib"`

	// Enable dirty page tracking. If this is enabled, then incremental guest memory snapshots can be created. These belong to diff snapshots, which contain, besides the microVM state, only the memory dirtied since a previous snapshot. Full snapshots each contain a full copy of the guest memory.
	TrackDirtyPages bool `json:"track_dirty_pages,omitempty"`

	// Number of vCPUs (either 1 or an even number)
	// Required: true
	// Maximum: 32
	// Minimum: 1
	VcpuCount *int64 `json:"vcpu_count"`
}

// Validate validates this machine configuration
func (m *MachineConfiguration) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCPUTemplate(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHtEnabled(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMemSizeMib(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVcpuCount(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *MachineConfiguration) validateCPUTemplate(formats strfmt.Registry) error {

	if swag.IsZero(m.CPUTemplate) { // not required
		return nil
	}

	if err := m.CPUTemplate.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("cpu_template")
		}
		return err
	}

	return nil
}

func (m *MachineConfiguration) validateHtEnabled(formats strfmt.Registry) error {

	if err := validate.Required("ht_enabled", "body", m.HtEnabled); err != nil {
		return err
	}

	return nil
}

func (m *MachineConfiguration) validateMemSizeMib(formats strfmt.Registry) error {

	if err := validate.Required("mem_size_mib", "body", m.MemSizeMib); err != nil {
		return err
	}

	return nil
}

func (m *MachineConfiguration) validateVcpuCount(formats strfmt.Registry) error {

	if err := validate.Required("vcpu_count", "body", m.VcpuCount); err != nil {
		return err
	}

	if err := validate.MinimumInt("vcpu_count", "body", int64(*m.VcpuCount), 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("vcpu_count", "body", int64(*m.VcpuCount), 32, false); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *MachineConfiguration) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *MachineConfiguration) UnmarshalBinary(b []byte) error {
	var res MachineConfiguration
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
