; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -force-streaming-compatible-sve < %s | FileCheck %s

target triple = "aarch64-unknown-linux-gnu"

;
; UCVTF H -> H
;

define <4 x half> @ucvtf_v4i16_v4f16(<4 x i16> %op1) #0 {
; CHECK-LABEL: ucvtf_v4i16_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    ucvtf z0.h, p0/m, z0.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = uitofp <4 x i16> %op1 to <4 x half>
  ret <4 x half> %res
}

define void @ucvtf_v8i16_v8f16(ptr %a, ptr %b) #0 {
; CHECK-LABEL: ucvtf_v8i16_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    ucvtf z0.h, p0/m, z0.h
; CHECK-NEXT:    str q0, [x1]
; CHECK-NEXT:    ret
  %op1 = load <8 x i16>, ptr %a
  %res = uitofp <8 x i16> %op1 to <8 x half>
  store <8 x half> %res, ptr %b
  ret void
}

define void @ucvtf_v16i16_v16f16(ptr %a, ptr %b) #0 {
; CHECK-LABEL: ucvtf_v16i16_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    ucvtf z0.h, p0/m, z0.h
; CHECK-NEXT:    ucvtf z1.h, p0/m, z1.h
; CHECK-NEXT:    stp q0, q1, [x1]
; CHECK-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %res = uitofp <16 x i16> %op1 to <16 x half>
  store <16 x half> %res, ptr %b
  ret void
}

;
; UCVTF H -> S
;

define <2 x float> @ucvtf_v2i16_v2f32(<2 x i16> %op1) #0 {
; CHECK-LABEL: ucvtf_v2i16_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    and z0.s, z0.s, #0xffff
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = uitofp <2 x i16> %op1 to <2 x float>
  ret <2 x float> %res
}

define <4 x float> @ucvtf_v4i16_v4f32(<4 x i16> %op1) #0 {
; CHECK-LABEL: ucvtf_v4i16_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = uitofp <4 x i16> %op1 to <4 x float>
  ret <4 x float> %res
}

define void @ucvtf_v8i16_v8f32(ptr %a, ptr %b) #0 {
; CHECK-LABEL: ucvtf_v8i16_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    uunpklo z1.s, z0.h
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    ucvtf z1.s, p0/m, z1.s
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    stp q1, q0, [x1]
; CHECK-NEXT:    ret
  %op1 = load <8 x i16>, ptr %a
  %res = uitofp <8 x i16> %op1 to <8 x float>
  store <8 x float> %res, ptr %b
  ret void
}

define void @ucvtf_v16i16_v16f32(ptr %a, ptr %b) #0 {
; CHECK-LABEL: ucvtf_v16i16_v16f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    uunpklo z2.s, z0.h
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    uunpklo z3.s, z1.h
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    uunpklo z1.s, z1.h
; CHECK-NEXT:    ucvtf z3.s, p0/m, z3.s
; CHECK-NEXT:    ucvtf z1.s, p0/m, z1.s
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    stp q3, q1, [x1, #32]
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    ucvtf z1.s, p0/m, z2.s
; CHECK-NEXT:    stp q1, q0, [x1]
; CHECK-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %res = uitofp <16 x i16> %op1 to <16 x float>
  store <16 x float> %res, ptr %b
  ret void
}

;
; UCVTF H -> D
;

define <1 x double> @ucvtf_v1i16_v1f64(<1 x i16> %op1) #0 {
; CHECK-LABEL: ucvtf_v1i16_v1f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    fmov w8, s0
; CHECK-NEXT:    and w8, w8, #0xffff
; CHECK-NEXT:    ucvtf d0, w8
; CHECK-NEXT:    ret
  %res = uitofp <1 x i16> %op1 to <1 x double>
  ret <1 x double> %res
}

define <2 x double> @ucvtf_v2i16_v2f64(<2 x i16> %op1) #0 {
; CHECK-LABEL: ucvtf_v2i16_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    and z0.s, z0.s, #0xffff
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    ucvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = uitofp <2 x i16> %op1 to <2 x double>
  ret <2 x double> %res
}

define void @ucvtf_v4i16_v4f64(ptr %a, ptr %b) #0 {
; CHECK-LABEL: ucvtf_v4i16_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    uunpklo z1.d, z0.s
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    ucvtf z1.d, p0/m, z1.d
; CHECK-NEXT:    ucvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    stp q1, q0, [x1]
; CHECK-NEXT:    ret
  %op1 = load <4 x i16>, ptr %a
  %res = uitofp <4 x i16> %op1 to <4 x double>
  store <4 x double> %res, ptr %b
  ret void
}

define void @ucvtf_v8i16_v8f64(ptr %a, ptr %b) #0 {
; CHECK-LABEL: ucvtf_v8i16_v8f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    uunpklo z1.s, z0.h
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    uunpklo z2.d, z1.s
; CHECK-NEXT:    uunpklo z3.d, z0.s
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    ucvtf z3.d, p0/m, z3.d
; CHECK-NEXT:    ucvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    ucvtf z2.d, p0/m, z2.d
; CHECK-NEXT:    uunpklo z1.d, z1.s
; CHECK-NEXT:    stp q3, q0, [x1, #32]
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    ucvtf z0.d, p0/m, z1.d
; CHECK-NEXT:    stp q2, q0, [x1]
; CHECK-NEXT:    ret
  %op1 = load <8 x i16>, ptr %a
  %res = uitofp <8 x i16> %op1 to <8 x double>
  store <8 x double> %res, ptr %b
  ret void
}

define void @ucvtf_v16i16_v16f64(ptr %a, ptr %b) #0 {
; CHECK-LABEL: ucvtf_v16i16_v16f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    uunpklo z2.s, z0.h
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    uunpklo z4.d, z2.s
; CHECK-NEXT:    uunpklo z3.s, z1.h
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    uunpklo z1.s, z1.h
; CHECK-NEXT:    uunpklo z6.d, z0.s
; CHECK-NEXT:    uunpklo z7.d, z1.s
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z1.d, z1.s
; CHECK-NEXT:    uunpklo z5.d, z3.s
; CHECK-NEXT:    ext z3.b, z3.b, z3.b, #8
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    ucvtf z7.d, p0/m, z7.d
; CHECK-NEXT:    ucvtf z1.d, p0/m, z1.d
; CHECK-NEXT:    ext z2.b, z2.b, z2.b, #8
; CHECK-NEXT:    uunpklo z3.d, z3.s
; CHECK-NEXT:    stp q7, q1, [x1, #96]
; CHECK-NEXT:    ucvtf z5.d, p0/m, z5.d
; CHECK-NEXT:    movprfx z1, z3
; CHECK-NEXT:    ucvtf z1.d, p0/m, z3.d
; CHECK-NEXT:    ucvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    uunpklo z2.d, z2.s
; CHECK-NEXT:    stp q5, q1, [x1, #64]
; CHECK-NEXT:    movprfx z3, z6
; CHECK-NEXT:    ucvtf z3.d, p0/m, z6.d
; CHECK-NEXT:    stp q3, q0, [x1, #32]
; CHECK-NEXT:    movprfx z1, z4
; CHECK-NEXT:    ucvtf z1.d, p0/m, z4.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    ucvtf z0.d, p0/m, z2.d
; CHECK-NEXT:    stp q1, q0, [x1]
; CHECK-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %res = uitofp <16 x i16> %op1 to <16 x double>
  store <16 x double> %res, ptr %b
  ret void
}

;
; UCVTF S -> H
;

define <2 x half> @ucvtf_v2i32_v2f16(<2 x i32> %op1) #0 {
; CHECK-LABEL: ucvtf_v2i32_v2f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ucvtf z0.h, p0/m, z0.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = uitofp <2 x i32> %op1 to <2 x half>
  ret <2 x half> %res
}

define <4 x half> @ucvtf_v4i32_v4f16(<4 x i32> %op1) #0 {
; CHECK-LABEL: ucvtf_v4i32_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ucvtf z0.h, p0/m, z0.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = uitofp <4 x i32> %op1 to <4 x half>
  ret <4 x half> %res
}

define <8 x half> @ucvtf_v8i32_v8f16(ptr %a) #0 {
; CHECK-LABEL: ucvtf_v8i32_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ucvtf z1.h, p0/m, z1.s
; CHECK-NEXT:    ucvtf z0.h, p0/m, z0.s
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    uzp1 z2.h, z0.h, z0.h
; CHECK-NEXT:    uzp1 z0.h, z1.h, z1.h
; CHECK-NEXT:    splice z0.h, p0, z0.h, z2.h
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %res = uitofp <8 x i32> %op1 to <8 x half>
  ret <8 x half> %res
}

define void @ucvtf_v16i32_v16f16(ptr %a, ptr %b) #0 {
; CHECK-LABEL: ucvtf_v16i32_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ptrue p1.h, vl4
; CHECK-NEXT:    ucvtf z0.h, p0/m, z0.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    ldp q3, q2, [x0, #32]
; CHECK-NEXT:    ucvtf z1.h, p0/m, z1.s
; CHECK-NEXT:    uzp1 z1.h, z1.h, z1.h
; CHECK-NEXT:    splice z0.h, p1, z0.h, z1.h
; CHECK-NEXT:    ucvtf z3.h, p0/m, z3.s
; CHECK-NEXT:    uzp1 z3.h, z3.h, z3.h
; CHECK-NEXT:    ucvtf z2.h, p0/m, z2.s
; CHECK-NEXT:    uzp1 z2.h, z2.h, z2.h
; CHECK-NEXT:    splice z3.h, p1, z3.h, z2.h
; CHECK-NEXT:    stp q0, q3, [x1]
; CHECK-NEXT:    ret
  %op1 = load <16 x i32>, ptr %a
  %res = uitofp <16 x i32> %op1 to <16 x half>
  store <16 x half> %res, ptr %b
  ret void
}

;
; UCVTF S -> S
;

define <2 x float> @ucvtf_v2i32_v2f32(<2 x i32> %op1) #0 {
; CHECK-LABEL: ucvtf_v2i32_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = uitofp <2 x i32> %op1 to <2 x float>
  ret <2 x float> %res
}

define <4 x float> @ucvtf_v4i32_v4f32(<4 x i32> %op1) #0 {
; CHECK-LABEL: ucvtf_v4i32_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = uitofp <4 x i32> %op1 to <4 x float>
  ret <4 x float> %res
}

define void @ucvtf_v8i32_v8f32(ptr %a, ptr %b) #0 {
; CHECK-LABEL: ucvtf_v8i32_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    ucvtf z1.s, p0/m, z1.s
; CHECK-NEXT:    stp q0, q1, [x1]
; CHECK-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %res = uitofp <8 x i32> %op1 to <8 x float>
  store <8 x float> %res, ptr %b
  ret void
}

;
; UCVTF S -> D
;

define <2 x double> @ucvtf_v2i32_v2f64(<2 x i32> %op1) #0 {
; CHECK-LABEL: ucvtf_v2i32_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    ucvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = uitofp <2 x i32> %op1 to <2 x double>
  ret <2 x double> %res
}

define void @ucvtf_v4i32_v4f64(ptr %a, ptr %b) #0 {
; CHECK-LABEL: ucvtf_v4i32_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    uunpklo z1.d, z0.s
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    ucvtf z1.d, p0/m, z1.d
; CHECK-NEXT:    ucvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    stp q1, q0, [x1]
; CHECK-NEXT:    ret
  %op1 = load <4 x i32>, ptr %a
  %res = uitofp <4 x i32> %op1 to <4 x double>
  store <4 x double> %res, ptr %b
  ret void
}

define void @ucvtf_v8i32_v8f64(ptr %a, ptr %b) #0 {
; CHECK-LABEL: ucvtf_v8i32_v8f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    uunpklo z2.d, z0.s
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    uunpklo z3.d, z1.s
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    uunpklo z1.d, z1.s
; CHECK-NEXT:    ucvtf z3.d, p0/m, z3.d
; CHECK-NEXT:    ucvtf z1.d, p0/m, z1.d
; CHECK-NEXT:    ucvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    stp q3, q1, [x1, #32]
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    ucvtf z1.d, p0/m, z2.d
; CHECK-NEXT:    stp q1, q0, [x1]
; CHECK-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %res = uitofp <8 x i32> %op1 to <8 x double>
  store <8 x double> %res, ptr %b
  ret void
}

;
; UCVTF D -> H
;

define <2 x half> @ucvtf_v2i64_v2f16(<2 x i64> %op1) #0 {
; CHECK-LABEL: ucvtf_v2i64_v2f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    mov z1.d, z0.d[1]
; CHECK-NEXT:    fmov x8, d0
; CHECK-NEXT:    fmov x9, d1
; CHECK-NEXT:    ucvtf h0, x8
; CHECK-NEXT:    ucvtf h1, x9
; CHECK-NEXT:    str h0, [sp, #8]
; CHECK-NEXT:    str h1, [sp, #10]
; CHECK-NEXT:    ldr d0, [sp, #8]
; CHECK-NEXT:    add sp, sp, #16
; CHECK-NEXT:    ret
  %res = uitofp <2 x i64> %op1 to <2 x half>
  ret <2 x half> %res
}

define <4 x half> @ucvtf_v4i64_v4f16(ptr %a) #0 {
; CHECK-LABEL: ucvtf_v4i64_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ucvtf z1.s, p0/m, z1.d
; CHECK-NEXT:    uzp1 z1.s, z1.s, z1.s
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.d
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    uzp1 z0.s, z0.s, z0.s
; CHECK-NEXT:    splice z1.s, p0, z1.s, z0.s
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    fcvt z0.h, p0/m, z1.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %res = uitofp <4 x i64> %op1 to <4 x half>
  ret <4 x half> %res
}

define <8 x half> @ucvtf_v8i64_v8f16(ptr %a) #0 {
; CHECK-LABEL: ucvtf_v8i64_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0, #32]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ptrue p1.s, vl2
; CHECK-NEXT:    ptrue p2.s
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.d
; CHECK-NEXT:    uzp1 z0.s, z0.s, z0.s
; CHECK-NEXT:    ldp q3, q2, [x0]
; CHECK-NEXT:    ucvtf z1.s, p0/m, z1.d
; CHECK-NEXT:    uzp1 z1.s, z1.s, z1.s
; CHECK-NEXT:    splice z0.s, p1, z0.s, z1.s
; CHECK-NEXT:    ucvtf z3.s, p0/m, z3.d
; CHECK-NEXT:    fcvt z0.h, p2/m, z0.s
; CHECK-NEXT:    uzp1 z3.s, z3.s, z3.s
; CHECK-NEXT:    ucvtf z2.s, p0/m, z2.d
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    uzp1 z2.s, z2.s, z2.s
; CHECK-NEXT:    splice z3.s, p1, z3.s, z2.s
; CHECK-NEXT:    movprfx z1, z3
; CHECK-NEXT:    fcvt z1.h, p2/m, z3.s
; CHECK-NEXT:    uzp1 z2.h, z0.h, z0.h
; CHECK-NEXT:    uzp1 z0.h, z1.h, z1.h
; CHECK-NEXT:    splice z0.h, p0, z0.h, z2.h
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %op1 = load <8 x i64>, ptr %a
  %res = uitofp <8 x i64> %op1 to <8 x half>
  ret <8 x half> %res
}

;
; UCVTF D -> S
;

define <2 x float> @ucvtf_v2i64_v2f32(<2 x i64> %op1) #0 {
; CHECK-LABEL: ucvtf_v2i64_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.d
; CHECK-NEXT:    uzp1 z0.s, z0.s, z0.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = uitofp <2 x i64> %op1 to <2 x float>
  ret <2 x float> %res
}

define <4 x float> @ucvtf_v4i64_v4f32(ptr %a) #0 {
; CHECK-LABEL: ucvtf_v4i64_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ucvtf z1.s, p0/m, z1.d
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.d
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    uzp1 z2.s, z0.s, z0.s
; CHECK-NEXT:    uzp1 z0.s, z1.s, z1.s
; CHECK-NEXT:    splice z0.s, p0, z0.s, z2.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %res = uitofp <4 x i64> %op1 to <4 x float>
  ret <4 x float> %res
}

define void @ucvtf_v8i64_v8f32(ptr %a, ptr %b) #0 {
; CHECK-LABEL: ucvtf_v8i64_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ptrue p1.s, vl2
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.d
; CHECK-NEXT:    uzp1 z0.s, z0.s, z0.s
; CHECK-NEXT:    ldp q3, q2, [x0, #32]
; CHECK-NEXT:    ucvtf z1.s, p0/m, z1.d
; CHECK-NEXT:    uzp1 z1.s, z1.s, z1.s
; CHECK-NEXT:    splice z0.s, p1, z0.s, z1.s
; CHECK-NEXT:    ucvtf z3.s, p0/m, z3.d
; CHECK-NEXT:    uzp1 z3.s, z3.s, z3.s
; CHECK-NEXT:    ucvtf z2.s, p0/m, z2.d
; CHECK-NEXT:    uzp1 z2.s, z2.s, z2.s
; CHECK-NEXT:    splice z3.s, p1, z3.s, z2.s
; CHECK-NEXT:    stp q0, q3, [x1]
; CHECK-NEXT:    ret
  %op1 = load <8 x i64>, ptr %a
  %res = uitofp <8 x i64> %op1 to <8 x float>
  store <8 x float> %res, ptr %b
  ret void
}

;
; UCVTF D -> D
;

define <2 x double> @ucvtf_v2i64_v2f64(<2 x i64> %op1) #0 {
; CHECK-LABEL: ucvtf_v2i64_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ucvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = uitofp <2 x i64> %op1 to <2 x double>
  ret <2 x double> %res
}

define void @ucvtf_v4i64_v4f64(ptr %a, ptr %b) #0 {
; CHECK-LABEL: ucvtf_v4i64_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ucvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    ucvtf z1.d, p0/m, z1.d
; CHECK-NEXT:    stp q0, q1, [x1]
; CHECK-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %res = uitofp <4 x i64> %op1 to <4 x double>
  store <4 x double> %res, ptr %b
  ret void
}

;
; SCVTF H -> H
;

define <4 x half> @scvtf_v4i16_v4f16(<4 x i16> %op1) #0 {
; CHECK-LABEL: scvtf_v4i16_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    scvtf z0.h, p0/m, z0.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = sitofp <4 x i16> %op1 to <4 x half>
  ret <4 x half> %res
}

define void @scvtf_v8i16_v8f16(ptr %a, ptr %b) #0 {
; CHECK-LABEL: scvtf_v8i16_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    scvtf z0.h, p0/m, z0.h
; CHECK-NEXT:    str q0, [x1]
; CHECK-NEXT:    ret
  %op1 = load <8 x i16>, ptr %a
  %res = sitofp <8 x i16> %op1 to <8 x half>
  store <8 x half> %res, ptr %b
  ret void
}

define void @scvtf_v16i16_v16f16(ptr %a, ptr %b) #0 {
; CHECK-LABEL: scvtf_v16i16_v16f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    scvtf z0.h, p0/m, z0.h
; CHECK-NEXT:    scvtf z1.h, p0/m, z1.h
; CHECK-NEXT:    stp q0, q1, [x1]
; CHECK-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %res = sitofp <16 x i16> %op1 to <16 x half>
  store <16 x half> %res, ptr %b
  ret void
}

; SCVTF H -> S
;

define <2 x float> @scvtf_v2i16_v2f32(<2 x i16> %op1) #0 {
; CHECK-LABEL: scvtf_v2i16_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    lsl z0.s, p0/m, z0.s, #16
; CHECK-NEXT:    asr z0.s, p0/m, z0.s, #16
; CHECK-NEXT:    scvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = sitofp <2 x i16> %op1 to <2 x float>
  ret <2 x float> %res
}

define <4 x float> @scvtf_v4i16_v4f32(<4 x i16> %op1) #0 {
; CHECK-LABEL: scvtf_v4i16_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    sunpklo z0.s, z0.h
; CHECK-NEXT:    scvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = sitofp <4 x i16> %op1 to <4 x float>
  ret <4 x float> %res
}

define void @scvtf_v8i16_v8f32(ptr %a, ptr %b) #0 {
; CHECK-LABEL: scvtf_v8i16_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    sunpklo z1.s, z0.h
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    sunpklo z0.s, z0.h
; CHECK-NEXT:    scvtf z1.s, p0/m, z1.s
; CHECK-NEXT:    scvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    stp q1, q0, [x1]
; CHECK-NEXT:    ret
  %op1 = load <8 x i16>, ptr %a
  %res = sitofp <8 x i16> %op1 to <8 x float>
  store <8 x float> %res, ptr %b
  ret void
}

define void @scvtf_v16i16_v16f32(ptr %a, ptr %b) #0 {
; CHECK-LABEL: scvtf_v16i16_v16f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    sunpklo z2.s, z0.h
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    sunpklo z0.s, z0.h
; CHECK-NEXT:    sunpklo z3.s, z1.h
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    sunpklo z1.s, z1.h
; CHECK-NEXT:    scvtf z3.s, p0/m, z3.s
; CHECK-NEXT:    scvtf z1.s, p0/m, z1.s
; CHECK-NEXT:    scvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    stp q3, q1, [x1, #32]
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    scvtf z1.s, p0/m, z2.s
; CHECK-NEXT:    stp q1, q0, [x1]
; CHECK-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %res = sitofp <16 x i16> %op1 to <16 x float>
  store <16 x float> %res, ptr %b
  ret void
}

;
; SCVTF H -> D
;

define <2 x double> @scvtf_v2i16_v2f64(<2 x i16> %op1) #0 {
; CHECK-LABEL: scvtf_v2i16_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    lsl z0.s, p0/m, z0.s, #16
; CHECK-NEXT:    asr z0.s, p0/m, z0.s, #16
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    sunpklo z0.d, z0.s
; CHECK-NEXT:    scvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = sitofp <2 x i16> %op1 to <2 x double>
  ret <2 x double> %res
}

define void @scvtf_v4i16_v4f64(ptr %a, ptr %b) #0 {
; CHECK-LABEL: scvtf_v4i16_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr d0, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    sunpklo z0.s, z0.h
; CHECK-NEXT:    sunpklo z1.d, z0.s
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    sunpklo z0.d, z0.s
; CHECK-NEXT:    scvtf z1.d, p0/m, z1.d
; CHECK-NEXT:    scvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    stp q1, q0, [x1]
; CHECK-NEXT:    ret
  %op1 = load <4 x i16>, ptr %a
  %res = sitofp <4 x i16> %op1 to <4 x double>
  store <4 x double> %res, ptr %b
  ret void
}

define void @scvtf_v8i16_v8f64(ptr %a, ptr %b) #0 {
; CHECK-LABEL: scvtf_v8i16_v8f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    sunpklo z1.s, z0.h
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    sunpklo z0.s, z0.h
; CHECK-NEXT:    sunpklo z2.d, z1.s
; CHECK-NEXT:    sunpklo z3.d, z0.s
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    sunpklo z0.d, z0.s
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    scvtf z3.d, p0/m, z3.d
; CHECK-NEXT:    scvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    scvtf z2.d, p0/m, z2.d
; CHECK-NEXT:    sunpklo z1.d, z1.s
; CHECK-NEXT:    stp q3, q0, [x1, #32]
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    scvtf z0.d, p0/m, z1.d
; CHECK-NEXT:    stp q2, q0, [x1]
; CHECK-NEXT:    ret
  %op1 = load <8 x i16>, ptr %a
  %res = sitofp <8 x i16> %op1 to <8 x double>
  store <8 x double> %res, ptr %b
  ret void
}

define void @scvtf_v16i16_v16f64(ptr %a, ptr %b) #0 {
; CHECK-LABEL: scvtf_v16i16_v16f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    sunpklo z2.s, z0.h
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    sunpklo z0.s, z0.h
; CHECK-NEXT:    sunpklo z4.d, z2.s
; CHECK-NEXT:    sunpklo z3.s, z1.h
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    sunpklo z1.s, z1.h
; CHECK-NEXT:    sunpklo z6.d, z0.s
; CHECK-NEXT:    sunpklo z7.d, z1.s
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    sunpklo z1.d, z1.s
; CHECK-NEXT:    sunpklo z5.d, z3.s
; CHECK-NEXT:    ext z3.b, z3.b, z3.b, #8
; CHECK-NEXT:    sunpklo z0.d, z0.s
; CHECK-NEXT:    scvtf z7.d, p0/m, z7.d
; CHECK-NEXT:    scvtf z1.d, p0/m, z1.d
; CHECK-NEXT:    ext z2.b, z2.b, z2.b, #8
; CHECK-NEXT:    sunpklo z3.d, z3.s
; CHECK-NEXT:    stp q7, q1, [x1, #96]
; CHECK-NEXT:    scvtf z5.d, p0/m, z5.d
; CHECK-NEXT:    movprfx z1, z3
; CHECK-NEXT:    scvtf z1.d, p0/m, z3.d
; CHECK-NEXT:    scvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    sunpklo z2.d, z2.s
; CHECK-NEXT:    stp q5, q1, [x1, #64]
; CHECK-NEXT:    movprfx z3, z6
; CHECK-NEXT:    scvtf z3.d, p0/m, z6.d
; CHECK-NEXT:    stp q3, q0, [x1, #32]
; CHECK-NEXT:    movprfx z1, z4
; CHECK-NEXT:    scvtf z1.d, p0/m, z4.d
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    scvtf z0.d, p0/m, z2.d
; CHECK-NEXT:    stp q1, q0, [x1]
; CHECK-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %res = sitofp <16 x i16> %op1 to <16 x double>
  store <16 x double> %res, ptr %b
  ret void
}

;
; SCVTF S -> H
;

define <2 x half> @scvtf_v2i32_v2f16(<2 x i32> %op1) #0 {
; CHECK-LABEL: scvtf_v2i32_v2f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    scvtf z0.h, p0/m, z0.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = sitofp <2 x i32> %op1 to <2 x half>
  ret <2 x half> %res
}

define <4 x half> @scvtf_v4i32_v4f16(<4 x i32> %op1) #0 {
; CHECK-LABEL: scvtf_v4i32_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    scvtf z0.h, p0/m, z0.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = sitofp <4 x i32> %op1 to <4 x half>
  ret <4 x half> %res
}

define <8 x half> @scvtf_v8i32_v8f16(ptr %a) #0 {
; CHECK-LABEL: scvtf_v8i32_v8f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    scvtf z1.h, p0/m, z1.s
; CHECK-NEXT:    scvtf z0.h, p0/m, z0.s
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    uzp1 z2.h, z0.h, z0.h
; CHECK-NEXT:    uzp1 z0.h, z1.h, z1.h
; CHECK-NEXT:    splice z0.h, p0, z0.h, z2.h
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %res = sitofp <8 x i32> %op1 to <8 x half>
  ret <8 x half> %res
}

;
; SCVTF S -> S
;

define <2 x float> @scvtf_v2i32_v2f32(<2 x i32> %op1) #0 {
; CHECK-LABEL: scvtf_v2i32_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    scvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = sitofp <2 x i32> %op1 to <2 x float>
  ret <2 x float> %res
}

define <4 x float> @scvtf_v4i32_v4f32(<4 x i32> %op1) #0 {
; CHECK-LABEL: scvtf_v4i32_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    scvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = sitofp <4 x i32> %op1 to <4 x float>
  ret <4 x float> %res
}

define void @scvtf_v8i32_v8f32(ptr %a, ptr %b) #0 {
; CHECK-LABEL: scvtf_v8i32_v8f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    scvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    scvtf z1.s, p0/m, z1.s
; CHECK-NEXT:    stp q0, q1, [x1]
; CHECK-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %res = sitofp <8 x i32> %op1 to <8 x float>
  store <8 x float> %res, ptr %b
  ret void
}

;
; SCVTF S -> D
;

define <2 x double> @scvtf_v2i32_v2f64(<2 x i32> %op1) #0 {
; CHECK-LABEL: scvtf_v2i32_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    sunpklo z0.d, z0.s
; CHECK-NEXT:    scvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = sitofp <2 x i32> %op1 to <2 x double>
  ret <2 x double> %res
}

define void @scvtf_v4i32_v4f64(ptr %a, ptr %b) #0 {
; CHECK-LABEL: scvtf_v4i32_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldr q0, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    sunpklo z1.d, z0.s
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    sunpklo z0.d, z0.s
; CHECK-NEXT:    scvtf z1.d, p0/m, z1.d
; CHECK-NEXT:    scvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    stp q1, q0, [x1]
; CHECK-NEXT:    ret
  %op1 = load <4 x i32>, ptr %a
  %res = sitofp <4 x i32> %op1 to <4 x double>
  store <4 x double> %res, ptr %b
  ret void
}

define void @scvtf_v8i32_v8f64(ptr %a, ptr %b) #0 {
; CHECK-LABEL: scvtf_v8i32_v8f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    sunpklo z2.d, z0.s
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    sunpklo z0.d, z0.s
; CHECK-NEXT:    sunpklo z3.d, z1.s
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    sunpklo z1.d, z1.s
; CHECK-NEXT:    scvtf z3.d, p0/m, z3.d
; CHECK-NEXT:    scvtf z1.d, p0/m, z1.d
; CHECK-NEXT:    scvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    stp q3, q1, [x1, #32]
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    scvtf z1.d, p0/m, z2.d
; CHECK-NEXT:    stp q1, q0, [x1]
; CHECK-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %res = sitofp <8 x i32> %op1 to <8 x double>
  store <8 x double> %res, ptr %b
  ret void
}

define void @scvtf_v16i32_v16f64(ptr %a, ptr %b) #0 {
; CHECK-LABEL: scvtf_v16i32_v16f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q2, q3, [x0, #32]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    mov z6.d, z2.d
; CHECK-NEXT:    sunpklo z2.d, z2.s
; CHECK-NEXT:    ext z6.b, z6.b, z6.b, #8
; CHECK-NEXT:    scvtf z2.d, p0/m, z2.d
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    mov z7.d, z3.d
; CHECK-NEXT:    sunpklo z3.d, z3.s
; CHECK-NEXT:    ext z7.b, z7.b, z7.b, #8
; CHECK-NEXT:    scvtf z3.d, p0/m, z3.d
; CHECK-NEXT:    sunpklo z7.d, z7.s
; CHECK-NEXT:    sunpklo z6.d, z6.s
; CHECK-NEXT:    sunpklo z4.d, z0.s
; CHECK-NEXT:    ext z0.b, z0.b, z0.b, #8
; CHECK-NEXT:    sunpklo z0.d, z0.s
; CHECK-NEXT:    scvtf z7.d, p0/m, z7.d
; CHECK-NEXT:    sunpklo z5.d, z1.s
; CHECK-NEXT:    ext z1.b, z1.b, z1.b, #8
; CHECK-NEXT:    sunpklo z1.d, z1.s
; CHECK-NEXT:    stp q3, q7, [x1, #96]
; CHECK-NEXT:    movprfx z3, z6
; CHECK-NEXT:    scvtf z3.d, p0/m, z6.d
; CHECK-NEXT:    stp q2, q3, [x1, #64]
; CHECK-NEXT:    movprfx z2, z5
; CHECK-NEXT:    scvtf z2.d, p0/m, z5.d
; CHECK-NEXT:    scvtf z1.d, p0/m, z1.d
; CHECK-NEXT:    scvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    stp q2, q1, [x1, #32]
; CHECK-NEXT:    movprfx z2, z4
; CHECK-NEXT:    scvtf z2.d, p0/m, z4.d
; CHECK-NEXT:    stp q2, q0, [x1]
; CHECK-NEXT:    ret
  %op1 = load <16 x i32>, ptr %a
  %res = sitofp <16 x i32> %op1 to <16 x double>
  store <16 x double> %res, ptr %b
  ret void
}

;
; SCVTF D -> H
;

define <2 x half> @scvtf_v2i64_v2f16(<2 x i64> %op1) #0 {
; CHECK-LABEL: scvtf_v2i64_v2f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    mov z1.d, z0.d[1]
; CHECK-NEXT:    fmov x8, d0
; CHECK-NEXT:    fmov x9, d1
; CHECK-NEXT:    scvtf h0, x8
; CHECK-NEXT:    scvtf h1, x9
; CHECK-NEXT:    str h0, [sp, #8]
; CHECK-NEXT:    str h1, [sp, #10]
; CHECK-NEXT:    ldr d0, [sp, #8]
; CHECK-NEXT:    add sp, sp, #16
; CHECK-NEXT:    ret
  %res = sitofp <2 x i64> %op1 to <2 x half>
  ret <2 x half> %res
}

define <4 x half> @scvtf_v4i64_v4f16(ptr %a) #0 {
; CHECK-LABEL: scvtf_v4i64_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    scvtf z1.s, p0/m, z1.d
; CHECK-NEXT:    uzp1 z1.s, z1.s, z1.s
; CHECK-NEXT:    scvtf z0.s, p0/m, z0.d
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    uzp1 z0.s, z0.s, z0.s
; CHECK-NEXT:    splice z1.s, p0, z1.s, z0.s
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    fcvt z0.h, p0/m, z1.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z0.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %res = sitofp <4 x i64> %op1 to <4 x half>
  ret <4 x half> %res
}

;
; SCVTF D -> S
;

define <2 x float> @scvtf_v2i64_v2f32(<2 x i64> %op1) #0 {
; CHECK-LABEL: scvtf_v2i64_v2f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    scvtf z0.s, p0/m, z0.d
; CHECK-NEXT:    uzp1 z0.s, z0.s, z0.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = sitofp <2 x i64> %op1 to <2 x float>
  ret <2 x float> %res
}

define <4 x float> @scvtf_v4i64_v4f32(ptr %a) #0 {
; CHECK-LABEL: scvtf_v4i64_v4f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    scvtf z1.s, p0/m, z1.d
; CHECK-NEXT:    scvtf z0.s, p0/m, z0.d
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    uzp1 z2.s, z0.s, z0.s
; CHECK-NEXT:    uzp1 z0.s, z1.s, z1.s
; CHECK-NEXT:    splice z0.s, p0, z0.s, z2.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %res = sitofp <4 x i64> %op1 to <4 x float>
  ret <4 x float> %res
}

;
; SCVTF D -> D
;

define <2 x double> @scvtf_v2i64_v2f64(<2 x i64> %op1) #0 {
; CHECK-LABEL: scvtf_v2i64_v2f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    scvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = sitofp <2 x i64> %op1 to <2 x double>
  ret <2 x double> %res
}

define void @scvtf_v4i64_v4f64(ptr %a, ptr %b) #0 {
; CHECK-LABEL: scvtf_v4i64_v4f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    scvtf z0.d, p0/m, z0.d
; CHECK-NEXT:    scvtf z1.d, p0/m, z1.d
; CHECK-NEXT:    stp q0, q1, [x1]
; CHECK-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %res = sitofp <4 x i64> %op1 to <4 x double>
  store <4 x double> %res, ptr %b
  ret void
}

attributes #0 = { "target-features"="+sve" }
