; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=indvars -scalar-evolution-use-expensive-range-sharpening -S | FileCheck %s

target triple = "aarch64--linux-gnu"

; Provide legal integer types.
target datalayout = "n8:16:32:64"


; Check the loop exit i32 compare instruction and operand are widened to i64
; instead of truncating IV before its use in the i32 compare instruction.

@idx = common global i32 0, align 4
@e = common global i32 0, align 4
@ptr = common global ptr null, align 8


define i32 @test1() {
; CHECK-LABEL: @test1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store i32 -1, ptr @idx, align 4
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr @e, align 4
; CHECK-NEXT:    [[CMP4:%.*]] = icmp slt i32 [[TMP0]], 0
; CHECK-NEXT:    br i1 [[CMP4]], label [[FOR_END_LOOPEXIT:%.*]], label [[FOR_BODY_LR_PH:%.*]]
; CHECK:       for.body.lr.ph:
; CHECK-NEXT:    [[TMP1:%.*]] = load ptr, ptr @ptr, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i32, ptr @e, align 4
; CHECK-NEXT:    [[SMAX:%.*]] = call i32 @llvm.smax.i32(i32 [[TMP2]], i32 0)
; CHECK-NEXT:    [[TMP3:%.*]] = add nuw i32 [[SMAX]], 1
; CHECK-NEXT:    [[WIDE_TRIP_COUNT:%.*]] = zext i32 [[TMP3]] to i64
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.cond:
; CHECK-NEXT:    [[INDVARS_IV_NEXT:%.*]] = add nuw nsw i64 [[INDVARS_IV:%.*]], 1
; CHECK-NEXT:    [[EXITCOND:%.*]] = icmp ne i64 [[INDVARS_IV_NEXT]], [[WIDE_TRIP_COUNT]]
; CHECK-NEXT:    br i1 [[EXITCOND]], label [[FOR_BODY]], label [[FOR_COND_FOR_END_LOOPEXIT_CRIT_EDGE:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[INDVARS_IV]] = phi i64 [ [[INDVARS_IV_NEXT]], [[FOR_COND:%.*]] ], [ 0, [[FOR_BODY_LR_PH]] ]
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[TMP1]], i64 [[INDVARS_IV]]
; CHECK-NEXT:    [[TMP4:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp eq i32 [[TMP4]], 0
; CHECK-NEXT:    br i1 [[TOBOOL]], label [[IF_THEN:%.*]], label [[FOR_COND]]
; CHECK:       if.then:
; CHECK-NEXT:    [[I_05_LCSSA_WIDE:%.*]] = phi i64 [ [[INDVARS_IV]], [[FOR_BODY]] ]
; CHECK-NEXT:    [[TMP5:%.*]] = trunc i64 [[I_05_LCSSA_WIDE]] to i32
; CHECK-NEXT:    store i32 [[TMP5]], ptr @idx, align 4
; CHECK-NEXT:    br label [[FOR_END:%.*]]
; CHECK:       for.cond.for.end.loopexit_crit_edge:
; CHECK-NEXT:    br label [[FOR_END_LOOPEXIT]]
; CHECK:       for.end.loopexit:
; CHECK-NEXT:    br label [[FOR_END]]
; CHECK:       for.end:
; CHECK-NEXT:    [[TMP6:%.*]] = load i32, ptr @idx, align 4
; CHECK-NEXT:    ret i32 [[TMP6]]
;
entry:
  store i32 -1, ptr @idx, align 4
  %0 = load i32, ptr @e, align 4
  %cmp4 = icmp slt i32 %0, 0
  br i1 %cmp4, label %for.end.loopexit, label %for.body.lr.ph

for.body.lr.ph:
  %1 = load ptr, ptr @ptr, align 8
  %2 = load i32, ptr @e, align 4
  br label %for.body

for.cond:
  %inc = add nsw i32 %i.05, 1
  %cmp = icmp slt i32 %i.05, %2
  br i1 %cmp, label %for.body, label %for.cond.for.end.loopexit_crit_edge

for.body:
  %i.05 = phi i32 [ 0, %for.body.lr.ph ], [ %inc, %for.cond ]
  %idxprom = sext i32 %i.05 to i64
  %arrayidx = getelementptr inbounds i32, ptr %1, i64 %idxprom
  %3 = load i32, ptr %arrayidx, align 4
  %tobool = icmp eq i32 %3, 0
  br i1 %tobool, label %if.then, label %for.cond

if.then:
  %i.05.lcssa = phi i32 [ %i.05, %for.body ]
  store i32 %i.05.lcssa, ptr @idx, align 4
  br label %for.end

for.cond.for.end.loopexit_crit_edge:
  br label %for.end.loopexit

for.end.loopexit:
  br label %for.end

for.end:
  %4 = load i32, ptr @idx, align 4
  ret i32 %4
}


define void @test2(ptr %a, ptr %b, i8 %limit) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CONV:%.*]] = zext i8 [[LIMIT:%.*]] to i32
; CHECK-NEXT:    br i1 undef, label [[FOR_COND1_PREHEADER_PREHEADER:%.*]], label [[FOR_COND1_PREHEADER_US_PREHEADER:%.*]]
; CHECK:       for.cond1.preheader.us.preheader:
; CHECK-NEXT:    [[SMAX:%.*]] = call i32 @llvm.smax.i32(i32 [[CONV]], i32 1)
; CHECK-NEXT:    br label [[FOR_COND1_PREHEADER_US:%.*]]
; CHECK:       for.cond1.preheader.preheader:
; CHECK-NEXT:    br label [[FOR_COND1_PREHEADER:%.*]]
; CHECK:       for.cond1.preheader.us:
; CHECK-NEXT:    [[INDVARS_IV3:%.*]] = phi i64 [ 0, [[FOR_COND1_PREHEADER_US_PREHEADER]] ], [ [[INDVARS_IV_NEXT4:%.*]], [[FOR_INC13_US:%.*]] ]
; CHECK-NEXT:    br i1 true, label [[FOR_BODY4_LR_PH_US:%.*]], label [[FOR_INC13_US]]
; CHECK:       for.inc13.us.loopexit:
; CHECK-NEXT:    br label [[FOR_INC13_US]]
; CHECK:       for.inc13.us:
; CHECK-NEXT:    [[INDVARS_IV_NEXT4]] = add nuw nsw i64 [[INDVARS_IV3]], 1
; CHECK-NEXT:    [[EXITCOND6:%.*]] = icmp ne i64 [[INDVARS_IV_NEXT4]], 4
; CHECK-NEXT:    br i1 [[EXITCOND6]], label [[FOR_COND1_PREHEADER_US]], label [[FOR_END_LOOPEXIT1:%.*]]
; CHECK:       for.body4.us:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ 0, [[FOR_BODY4_LR_PH_US]] ], [ [[INDVARS_IV_NEXT:%.*]], [[FOR_BODY4_US:%.*]] ]
; CHECK-NEXT:    [[ARRAYIDX6_US:%.*]] = getelementptr inbounds [8 x i8], ptr [[A:%.*]], i64 [[INDVARS_IV3]], i64 [[INDVARS_IV]]
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[ARRAYIDX6_US]], align 1
; CHECK-NEXT:    [[IDXPROM7_US:%.*]] = zext i8 [[TMP0]] to i64
; CHECK-NEXT:    [[ARRAYIDX8_US:%.*]] = getelementptr inbounds i8, ptr [[B:%.*]], i64 [[IDXPROM7_US]]
; CHECK-NEXT:    [[TMP1:%.*]] = load i8, ptr [[ARRAYIDX8_US]], align 1
; CHECK-NEXT:    store i8 [[TMP1]], ptr [[ARRAYIDX6_US]], align 1
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; CHECK-NEXT:    [[EXITCOND:%.*]] = icmp ne i64 [[INDVARS_IV_NEXT]], [[WIDE_TRIP_COUNT:%.*]]
; CHECK-NEXT:    br i1 [[EXITCOND]], label [[FOR_BODY4_US]], label [[FOR_INC13_US_LOOPEXIT:%.*]]
; CHECK:       for.body4.lr.ph.us:
; CHECK-NEXT:    [[WIDE_TRIP_COUNT]] = zext i32 [[SMAX]] to i64
; CHECK-NEXT:    br label [[FOR_BODY4_US]]
; CHECK:       for.cond1.preheader:
; CHECK-NEXT:    br i1 false, label [[FOR_INC13:%.*]], label [[FOR_INC13]]
; CHECK:       for.inc13:
; CHECK-NEXT:    br i1 false, label [[FOR_COND1_PREHEADER]], label [[FOR_END_LOOPEXIT:%.*]]
; CHECK:       for.end.loopexit:
; CHECK-NEXT:    br label [[FOR_END:%.*]]
; CHECK:       for.end.loopexit1:
; CHECK-NEXT:    br label [[FOR_END]]
; CHECK:       for.end:
; CHECK-NEXT:    ret void
;
entry:
  %conv = zext i8 %limit to i32
  br i1 undef, label %for.cond1.preheader, label %for.cond1.preheader.us

for.cond1.preheader.us:
  %storemerge5.us = phi i32 [ 0, %entry ], [ %inc14.us, %for.inc13.us ]
  br i1 true, label %for.body4.lr.ph.us, label %for.inc13.us

for.inc13.us:
  %inc14.us = add nsw i32 %storemerge5.us, 1
  %cmp.us = icmp slt i32 %inc14.us, 4
  br i1 %cmp.us, label %for.cond1.preheader.us, label %for.end

for.body4.us:
  %storemerge14.us = phi i32 [ 0, %for.body4.lr.ph.us ], [ %inc.us, %for.body4.us ]
  %idxprom.us = sext i32 %storemerge14.us to i64
  %arrayidx6.us = getelementptr inbounds [8 x i8], ptr %a, i64 %idxprom5.us, i64 %idxprom.us
  %0 = load i8, ptr %arrayidx6.us, align 1
  %idxprom7.us = zext i8 %0 to i64
  %arrayidx8.us = getelementptr inbounds i8, ptr %b, i64 %idxprom7.us
  %1 = load i8, ptr %arrayidx8.us, align 1
  store i8 %1, ptr %arrayidx6.us, align 1
  %inc.us = add nsw i32 %storemerge14.us, 1
  %cmp2.us = icmp slt i32 %inc.us, %conv
  br i1 %cmp2.us, label %for.body4.us, label %for.inc13.us

for.body4.lr.ph.us:
  %idxprom5.us = sext i32 %storemerge5.us to i64
  br label %for.body4.us

for.cond1.preheader:
  %storemerge5 = phi i32 [ 0, %entry ], [ %inc14, %for.inc13 ]
  br i1 false, label %for.inc13, label %for.inc13

for.inc13:
  %inc14 = add nsw i32 %storemerge5, 1
  %cmp = icmp slt i32 %inc14, 4
  br i1 %cmp, label %for.cond1.preheader, label %for.end

for.end:
  ret void
}


define i32 @test3(ptr %a, i32 %b) {
; CHECK-LABEL: @test3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SMAX:%.*]] = call i32 @llvm.smax.i32(i32 [[B:%.*]], i32 0)
; CHECK-NEXT:    [[WIDE_TRIP_COUNT:%.*]] = zext i32 [[SMAX]] to i64
; CHECK-NEXT:    br label [[FOR_COND:%.*]]
; CHECK:       for.cond:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ [[INDVARS_IV_NEXT:%.*]], [[FOR_BODY:%.*]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[SUM_0:%.*]] = phi i32 [ 0, [[ENTRY]] ], [ [[ADD:%.*]], [[FOR_BODY]] ]
; CHECK-NEXT:    [[EXITCOND:%.*]] = icmp ne i64 [[INDVARS_IV]], [[WIDE_TRIP_COUNT]]
; CHECK-NEXT:    br i1 [[EXITCOND]], label [[FOR_BODY]], label [[FOR_END:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[A:%.*]], i64 [[INDVARS_IV]]
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
; CHECK-NEXT:    [[ADD]] = add nsw i32 [[SUM_0]], [[TMP0]]
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; CHECK-NEXT:    br label [[FOR_COND]]
; CHECK:       for.end:
; CHECK-NEXT:    [[SUM_0_LCSSA:%.*]] = phi i32 [ [[SUM_0]], [[FOR_COND]] ]
; CHECK-NEXT:    ret i32 [[SUM_0_LCSSA]]
;
entry:
  br label %for.cond

for.cond:
  %sum.0 = phi i32 [ 0, %entry ], [ %add, %for.body ]
  %i.0 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
  %cmp = icmp slt i32 %i.0, %b
  br i1 %cmp, label %for.body, label %for.end

for.body:
  %idxprom = sext i32 %i.0 to i64
  %arrayidx = getelementptr inbounds i32, ptr %a, i64 %idxprom
  %0 = load i32, ptr %arrayidx, align 4
  %add = add nsw i32 %sum.0, %0
  %inc = add nsw i32 %i.0, 1
  br label %for.cond

for.end:
  ret i32 %sum.0
}

declare i32 @fn1(i8 signext)

; PR21030

define i32 @test4(i32 %a) {
; CHECK-LABEL: @test4(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i32 [ [[INDVARS_IV_NEXT:%.*]], [[FOR_BODY]] ], [ 253, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[A:%.*]], [[INDVARS_IV]]
; CHECK-NEXT:    [[CONV3:%.*]] = trunc i32 [[OR]] to i8
; CHECK-NEXT:    [[CALL:%.*]] = call i32 @fn1(i8 signext [[CONV3]])
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add nsw i32 [[INDVARS_IV]], -1
; CHECK-NEXT:    [[TMP0:%.*]] = trunc i32 [[INDVARS_IV_NEXT]] to i8
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i8 [[TMP0]], -14
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[FOR_END:%.*]]
; CHECK:       for.end:
; CHECK-NEXT:    ret i32 0
;
entry:
  br label %for.body

for.body:
  %c.07 = phi i8 [ -3, %entry ], [ %dec, %for.body ]
  %conv6 = zext i8 %c.07 to i32
  %or = or i32 %a, %conv6
  %conv3 = trunc i32 %or to i8
  %call = call i32 @fn1(i8 signext %conv3)
  %dec = add i8 %c.07, -1
  %cmp = icmp sgt i8 %dec, -14
  br i1 %cmp, label %for.body, label %for.end

for.end:
  ret i32 0
}


define i32 @test5(ptr %a, i32 %b) {
; CHECK-LABEL: @test5(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = zext i32 [[B:%.*]] to i64
; CHECK-NEXT:    br label [[FOR_COND:%.*]]
; CHECK:       for.cond:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ [[INDVARS_IV_NEXT:%.*]], [[FOR_BODY:%.*]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[SUM_0:%.*]] = phi i32 [ 0, [[ENTRY]] ], [ [[ADD:%.*]], [[FOR_BODY]] ]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ule i64 [[INDVARS_IV]], [[TMP0]]
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[FOR_END:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[A:%.*]], i64 [[INDVARS_IV]]
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
; CHECK-NEXT:    [[ADD]] = add nsw i32 [[SUM_0]], [[TMP1]]
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; CHECK-NEXT:    br label [[FOR_COND]]
; CHECK:       for.end:
; CHECK-NEXT:    [[SUM_0_LCSSA:%.*]] = phi i32 [ [[SUM_0]], [[FOR_COND]] ]
; CHECK-NEXT:    ret i32 [[SUM_0_LCSSA]]
;
entry:
  br label %for.cond

for.cond:
  %sum.0 = phi i32 [ 0, %entry ], [ %add, %for.body ]
  %i.0 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
  %cmp = icmp ule i32 %i.0, %b
  br i1 %cmp, label %for.body, label %for.end

for.body:
  %idxprom = zext i32 %i.0 to i64
  %arrayidx = getelementptr inbounds i32, ptr %a, i64 %idxprom
  %0 = load i32, ptr %arrayidx, align 4
  %add = add nsw i32 %sum.0, %0
  %inc = add nsw i32 %i.0, 1
  br label %for.cond

for.end:
  ret i32 %sum.0
}

define i32 @test6(ptr %a, i32 %b) {
; CHECK-LABEL: @test6(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SMAX:%.*]] = call i32 @llvm.smax.i32(i32 [[B:%.*]], i32 -1)
; CHECK-NEXT:    [[TMP0:%.*]] = add i32 [[SMAX]], 1
; CHECK-NEXT:    [[WIDE_TRIP_COUNT:%.*]] = zext i32 [[TMP0]] to i64
; CHECK-NEXT:    br label [[FOR_COND:%.*]]
; CHECK:       for.cond:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ [[INDVARS_IV_NEXT:%.*]], [[FOR_BODY:%.*]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[SUM_0:%.*]] = phi i32 [ 0, [[ENTRY]] ], [ [[ADD:%.*]], [[FOR_BODY]] ]
; CHECK-NEXT:    [[EXITCOND:%.*]] = icmp ne i64 [[INDVARS_IV]], [[WIDE_TRIP_COUNT]]
; CHECK-NEXT:    br i1 [[EXITCOND]], label [[FOR_BODY]], label [[FOR_END:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[A:%.*]], i64 [[INDVARS_IV]]
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
; CHECK-NEXT:    [[ADD]] = add nsw i32 [[SUM_0]], [[TMP1]]
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; CHECK-NEXT:    br label [[FOR_COND]]
; CHECK:       for.end:
; CHECK-NEXT:    [[SUM_0_LCSSA:%.*]] = phi i32 [ [[SUM_0]], [[FOR_COND]] ]
; CHECK-NEXT:    ret i32 [[SUM_0_LCSSA]]
;
entry:
  br label %for.cond

for.cond:
  %sum.0 = phi i32 [ 0, %entry ], [ %add, %for.body ]
  %i.0 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
  %cmp = icmp sle i32 %i.0, %b
  br i1 %cmp, label %for.body, label %for.end

for.body:
  %idxprom = zext i32 %i.0 to i64
  %arrayidx = getelementptr inbounds i32, ptr %a, i64 %idxprom
  %0 = load i32, ptr %arrayidx, align 4
  %add = add nsw i32 %sum.0, %0
  %inc = add nsw i32 %i.0, 1
  br label %for.cond

for.end:
  ret i32 %sum.0
}

define i32 @test7(ptr %a, i32 %b) {
; CHECK-LABEL: @test7(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = zext i32 [[B:%.*]] to i64
; CHECK-NEXT:    [[SMAX:%.*]] = call i32 @llvm.smax.i32(i32 [[B]], i32 -1)
; CHECK-NEXT:    [[TMP1:%.*]] = add i32 [[SMAX]], 2
; CHECK-NEXT:    [[WIDE_TRIP_COUNT:%.*]] = zext i32 [[TMP1]] to i64
; CHECK-NEXT:    br label [[FOR_COND:%.*]]
; CHECK:       for.cond:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ [[INDVARS_IV_NEXT:%.*]], [[FOR_BODY:%.*]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[SUM_0:%.*]] = phi i32 [ 0, [[ENTRY]] ], [ [[ADD:%.*]], [[FOR_BODY]] ]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ule i64 [[INDVARS_IV]], [[TMP0]]
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[FOR_END:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[A:%.*]], i64 [[INDVARS_IV]]
; CHECK-NEXT:    [[TMP2:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
; CHECK-NEXT:    [[ADD]] = add nsw i32 [[SUM_0]], [[TMP2]]
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; CHECK-NEXT:    [[EXITCOND:%.*]] = icmp ne i64 [[INDVARS_IV_NEXT]], [[WIDE_TRIP_COUNT]]
; CHECK-NEXT:    br i1 [[EXITCOND]], label [[FOR_COND]], label [[FOR_END]]
; CHECK:       for.end:
; CHECK-NEXT:    [[SUM_0_LCSSA:%.*]] = phi i32 [ [[SUM_0]], [[FOR_BODY]] ], [ [[SUM_0]], [[FOR_COND]] ]
; CHECK-NEXT:    ret i32 [[SUM_0_LCSSA]]
;
entry:
  br label %for.cond

for.cond:
  %sum.0 = phi i32 [ 0, %entry ], [ %add, %for.body ]
  %i.0 = phi i32 [ 0, %entry ], [ %inc, %for.body ]
  %cmp = icmp ule i32 %i.0, %b
  br i1 %cmp, label %for.body, label %for.end

for.body:
  %idxprom = sext i32 %i.0 to i64
  %arrayidx = getelementptr inbounds i32, ptr %a, i64 %idxprom
  %0 = load i32, ptr %arrayidx, align 4
  %add = add nsw i32 %sum.0, %0
  %inc = add nsw i32 %i.0, 1
  %cmp2 = icmp sle i32 %i.0, %b
  br i1 %cmp2, label %for.cond, label %for.end

for.end:
  ret i32 %sum.0
}

define i32 @test8(ptr %a, i32 %b, i32 %init) {
;     Note: %indvars.iv is the sign extension of %i.0
; CHECK-LABEL: @test8(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[E:%.*]] = icmp sgt i32 [[INIT:%.*]], 0
; CHECK-NEXT:    br i1 [[E]], label [[FOR_COND_PREHEADER:%.*]], label [[LEAVE:%.*]]
; CHECK:       for.cond.preheader:
; CHECK-NEXT:    [[TMP0:%.*]] = sext i32 [[INIT]] to i64
; CHECK-NEXT:    [[TMP1:%.*]] = zext i32 [[B:%.*]] to i64
; CHECK-NEXT:    br label [[FOR_COND:%.*]]
; CHECK:       for.cond:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ [[TMP0]], [[FOR_COND_PREHEADER]] ], [ [[INDVARS_IV_NEXT:%.*]], [[FOR_BODY:%.*]] ]
; CHECK-NEXT:    [[SUM_0:%.*]] = phi i32 [ [[ADD:%.*]], [[FOR_BODY]] ], [ 0, [[FOR_COND_PREHEADER]] ]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ule i64 [[INDVARS_IV]], [[TMP1]]
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[FOR_END:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[A:%.*]], i64 [[INDVARS_IV]]
; CHECK-NEXT:    [[TMP2:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
; CHECK-NEXT:    [[ADD]] = add nsw i32 [[SUM_0]], [[TMP2]]
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; CHECK-NEXT:    [[CMP2:%.*]] = icmp slt i64 0, [[INDVARS_IV_NEXT]]
; CHECK-NEXT:    br i1 [[CMP2]], label [[FOR_COND]], label [[FOR_END]]
; CHECK:       for.end:
; CHECK-NEXT:    [[SUM_0_LCSSA:%.*]] = phi i32 [ [[SUM_0]], [[FOR_BODY]] ], [ [[SUM_0]], [[FOR_COND]] ]
; CHECK-NEXT:    ret i32 [[SUM_0_LCSSA]]
; CHECK:       leave:
; CHECK-NEXT:    ret i32 0
;
entry:
  %e = icmp sgt i32 %init, 0
  br i1 %e, label %for.cond, label %leave

for.cond:
  %sum.0 = phi i32 [ 0, %entry ], [ %add, %for.body ]
  %i.0 = phi i32 [ %init, %entry ], [ %inc, %for.body ]
  %cmp = icmp ule i32 %i.0, %b
  br i1 %cmp, label %for.body, label %for.end

for.body:
  %idxprom = sext i32 %i.0 to i64
  %arrayidx = getelementptr inbounds i32, ptr %a, i64 %idxprom
  %0 = load i32, ptr %arrayidx, align 4
  %add = add nsw i32 %sum.0, %0
  %inc = add nsw i32 %i.0, 1
  %cmp2 = icmp slt i32 0, %inc
  br i1 %cmp2, label %for.cond, label %for.end

for.end:
  ret i32 %sum.0

leave:
  ret i32 0
}

define i32 @test9(ptr %a, i32 %b, i32 %init) {
;     Note: %indvars.iv is the zero extension of %i.0
; CHECK-LABEL: @test9(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[E:%.*]] = icmp sgt i32 [[INIT:%.*]], 0
; CHECK-NEXT:    br i1 [[E]], label [[FOR_COND_PREHEADER:%.*]], label [[LEAVE:%.*]]
; CHECK:       for.cond.preheader:
; CHECK-NEXT:    [[TMP0:%.*]] = zext i32 [[INIT]] to i64
; CHECK-NEXT:    [[SMAX:%.*]] = call i32 @llvm.smax.i32(i32 [[INIT]], i32 [[B:%.*]])
; CHECK-NEXT:    [[WIDE_TRIP_COUNT:%.*]] = zext i32 [[SMAX]] to i64
; CHECK-NEXT:    br label [[FOR_COND:%.*]]
; CHECK:       for.cond:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ [[TMP0]], [[FOR_COND_PREHEADER]] ], [ [[INDVARS_IV_NEXT:%.*]], [[FOR_BODY:%.*]] ]
; CHECK-NEXT:    [[SUM_0:%.*]] = phi i32 [ [[ADD:%.*]], [[FOR_BODY]] ], [ 0, [[FOR_COND_PREHEADER]] ]
; CHECK-NEXT:    [[EXITCOND:%.*]] = icmp ne i64 [[INDVARS_IV]], [[WIDE_TRIP_COUNT]]
; CHECK-NEXT:    br i1 [[EXITCOND]], label [[FOR_BODY]], label [[FOR_END:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[ARRAYIDX:%.*]] = getelementptr inbounds i32, ptr [[A:%.*]], i64 [[INDVARS_IV]]
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr [[ARRAYIDX]], align 4
; CHECK-NEXT:    [[ADD]] = add nsw i32 [[SUM_0]], [[TMP1]]
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; CHECK-NEXT:    [[TMP2:%.*]] = trunc i64 [[INDVARS_IV_NEXT]] to i32
; CHECK-NEXT:    [[CMP2:%.*]] = icmp slt i32 0, [[TMP2]]
; CHECK-NEXT:    br i1 [[CMP2]], label [[FOR_COND]], label [[FOR_END]]
; CHECK:       for.end:
; CHECK-NEXT:    [[SUM_0_LCSSA:%.*]] = phi i32 [ [[SUM_0]], [[FOR_BODY]] ], [ [[SUM_0]], [[FOR_COND]] ]
; CHECK-NEXT:    ret i32 [[SUM_0_LCSSA]]
; CHECK:       leave:
; CHECK-NEXT:    ret i32 0
;
entry:
  %e = icmp sgt i32 %init, 0
  br i1 %e, label %for.cond, label %leave

for.cond:
  %sum.0 = phi i32 [ 0, %entry ], [ %add, %for.body ]
  %i.0 = phi i32 [ %init, %entry ], [ %inc, %for.body ]
  %cmp = icmp slt i32 %i.0, %b
  br i1 %cmp, label %for.body, label %for.end

for.body:
  %idxprom = zext i32 %i.0 to i64
  %arrayidx = getelementptr inbounds i32, ptr %a, i64 %idxprom
  %0 = load i32, ptr %arrayidx, align 4
  %add = add nsw i32 %sum.0, %0
  %inc = add nsw i32 %i.0, 1
  %cmp2 = icmp slt i32 0, %inc
  br i1 %cmp2, label %for.cond, label %for.end

for.end:
  ret i32 %sum.0

leave:
  ret i32 0
}

declare void @consume.i64(i64)
declare void @consume.i1(i1)

define i32 @test10(i32 %v) {
; CHECK-LABEL: @test10(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SEXT:%.*]] = sext i32 [[V:%.*]] to i64
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ [[INDVARS_IV_NEXT:%.*]], [[LOOP]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; CHECK-NEXT:    [[TMP0:%.*]] = mul nsw i64 [[INDVARS_IV]], -1
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i64 [[TMP0]], [[SEXT]]
; CHECK-NEXT:    call void @consume.i1(i1 [[TMP1]])
; CHECK-NEXT:    call void @consume.i64(i64 [[TMP0]])
; CHECK-NEXT:    [[EXITCOND:%.*]] = icmp ne i64 [[INDVARS_IV_NEXT]], 11
; CHECK-NEXT:    br i1 [[EXITCOND]], label [[LOOP]], label [[LEAVE:%.*]]
; CHECK:       leave:
; CHECK-NEXT:    ret i32 22
;
  entry:
  br label %loop

  loop:

  %i = phi i32 [ 0, %entry ], [ %i.inc, %loop ]
  %i.inc = add i32 %i, 1
  %iv = mul i32 %i, -1
  %cmp = icmp eq i32 %iv, %v
  call void @consume.i1(i1 %cmp)
  %be.cond = icmp slt i32 %i.inc, 11
  %ext = sext i32 %iv to i64
  call void @consume.i64(i64 %ext)
  br i1 %be.cond, label %loop, label %leave

  leave:
  ret i32 22
}

; TODO: We don't really need trunc/zext here because when iv.next overflows,
; its value is not used.
define i32 @test11(i32 %start, ptr %p, ptr %q) {
; CHECK-LABEL: @test11(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = zext i32 [[START:%.*]] to i64
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ [[INDVARS_IV_NEXT:%.*]], [[BACKEDGE:%.*]] ], [ [[TMP0]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[TMP1:%.*]] = add nsw i64 [[INDVARS_IV]], -1
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add nsw i64 [[INDVARS_IV]], -1
; CHECK-NEXT:    [[COND:%.*]] = icmp eq i64 [[INDVARS_IV]], 0
; CHECK-NEXT:    br i1 [[COND]], label [[EXIT:%.*]], label [[BACKEDGE]]
; CHECK:       backedge:
; CHECK-NEXT:    [[STORE_ADDR:%.*]] = getelementptr i32, ptr [[P:%.*]], i64 [[TMP1]]
; CHECK-NEXT:    store i32 1, ptr [[STORE_ADDR]], align 4
; CHECK-NEXT:    [[STOP:%.*]] = load i32, ptr [[Q:%.*]], align 4
; CHECK-NEXT:    [[LOOP_COND:%.*]] = icmp eq i32 [[STOP]], 0
; CHECK-NEXT:    br i1 [[LOOP_COND]], label [[LOOP]], label [[FAILURE:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    ret i32 0
; CHECK:       failure:
; CHECK-NEXT:    unreachable
;
entry:
  br label %loop

loop:
  %iv = phi i32 [%start, %entry], [%iv.next, %backedge]
  %iv.next = add i32 %iv, -1
  %cond = icmp eq i32 %iv, 0
  br i1 %cond, label %exit, label %backedge

backedge:
  %index = zext i32 %iv.next to i64
  %store.addr = getelementptr i32, ptr %p, i64 %index
  store i32 1, ptr %store.addr
  %load.addr = getelementptr i32, ptr %q, i64 %index
  %stop = load i32, ptr %q
  %loop.cond = icmp eq i32 %stop, 0
  br i1 %loop.cond, label %loop, label %failure

exit:
  ret i32 0

failure:
  unreachable
}

define i32 @test12(i32 %start, ptr %p, ptr %q) {
; CHECK-LABEL: @test12(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = zext i32 [[START:%.*]] to i64
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ [[INDVARS_IV_NEXT:%.*]], [[BACKEDGE:%.*]] ], [ [[TMP0]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[COND:%.*]] = icmp eq i64 [[INDVARS_IV]], 0
; CHECK-NEXT:    br i1 [[COND]], label [[EXIT:%.*]], label [[BACKEDGE]]
; CHECK:       backedge:
; CHECK-NEXT:    [[TMP1:%.*]] = add nsw i64 [[INDVARS_IV]], -1
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add nsw i64 [[INDVARS_IV]], -1
; CHECK-NEXT:    [[STORE_ADDR:%.*]] = getelementptr i32, ptr [[P:%.*]], i64 [[TMP1]]
; CHECK-NEXT:    store i32 1, ptr [[STORE_ADDR]], align 4
; CHECK-NEXT:    [[STOP:%.*]] = load i32, ptr [[Q:%.*]], align 4
; CHECK-NEXT:    [[LOOP_COND:%.*]] = icmp eq i32 [[STOP]], 0
; CHECK-NEXT:    br i1 [[LOOP_COND]], label [[LOOP]], label [[FAILURE:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    ret i32 0
; CHECK:       failure:
; CHECK-NEXT:    unreachable
;
entry:
  br label %loop

loop:
  %iv = phi i32 [%start, %entry], [%iv.next, %backedge]
  %cond = icmp eq i32 %iv, 0
  br i1 %cond, label %exit, label %backedge

backedge:
  %iv.next = add i32 %iv, -1
  %index = zext i32 %iv.next to i64
  %store.addr = getelementptr i32, ptr %p, i64 %index
  store i32 1, ptr %store.addr
  %load.addr = getelementptr i32, ptr %q, i64 %index
  %stop = load i32, ptr %q
  %loop.cond = icmp eq i32 %stop, 0
  br i1 %loop.cond, label %loop, label %failure

exit:
  ret i32 0

failure:
  unreachable
}

define i32 @test13(i32 %start, ptr %p, ptr %q) {
; CHECK-LABEL: @test13(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = zext i32 [[START:%.*]] to i64
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ [[INDVARS_IV_NEXT:%.*]], [[BACKEDGE:%.*]] ], [ [[TMP0]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[COND:%.*]] = icmp eq i64 [[INDVARS_IV]], 0
; CHECK-NEXT:    br i1 [[COND]], label [[EXIT:%.*]], label [[BACKEDGE]]
; CHECK:       backedge:
; CHECK-NEXT:    [[TMP1:%.*]] = add nsw i64 [[INDVARS_IV]], -1
; CHECK-NEXT:    [[STORE_ADDR:%.*]] = getelementptr i32, ptr [[P:%.*]], i64 [[TMP1]]
; CHECK-NEXT:    store i32 1, ptr [[STORE_ADDR]], align 4
; CHECK-NEXT:    [[STOP:%.*]] = load i32, ptr [[Q:%.*]], align 4
; CHECK-NEXT:    [[LOOP_COND:%.*]] = icmp eq i32 [[STOP]], 0
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add nsw i64 [[INDVARS_IV]], -1
; CHECK-NEXT:    br i1 [[LOOP_COND]], label [[LOOP]], label [[FAILURE:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    ret i32 0
; CHECK:       failure:
; CHECK-NEXT:    unreachable
;
entry:
  br label %loop

loop:
  %iv = phi i32 [%start, %entry], [%iv.next.1, %backedge]
  %cond = icmp eq i32 %iv, 0
  br i1 %cond, label %exit, label %backedge

backedge:
  %foo = add i32 %iv, -1
  %index = zext i32 %foo to i64
  %store.addr = getelementptr i32, ptr %p, i64 %index
  store i32 1, ptr %store.addr
  %load.addr = getelementptr i32, ptr %q, i64 %index
  %stop = load i32, ptr %q
  %loop.cond = icmp eq i32 %stop, 0
  %iv.next.1 = add i32 %iv, -1
  br i1 %loop.cond, label %loop, label %failure

exit:
  ret i32 0

failure:
  unreachable
}

define i32 @test14(i32 %start, ptr %p, ptr %q) {
; CHECK-LABEL: @test14(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = zext i32 [[START:%.*]] to i64
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ [[INDVARS_IV_NEXT:%.*]], [[BACKEDGE:%.*]] ], [ [[TMP0]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[COND:%.*]] = icmp eq i64 [[INDVARS_IV]], 0
; CHECK-NEXT:    [[TMP1:%.*]] = add nsw i64 [[INDVARS_IV]], -1
; CHECK-NEXT:    br i1 [[COND]], label [[EXIT:%.*]], label [[BACKEDGE]]
; CHECK:       backedge:
; CHECK-NEXT:    [[STORE_ADDR:%.*]] = getelementptr i32, ptr [[P:%.*]], i64 [[TMP1]]
; CHECK-NEXT:    store i32 1, ptr [[STORE_ADDR]], align 4
; CHECK-NEXT:    [[STOP:%.*]] = load i32, ptr [[Q:%.*]], align 4
; CHECK-NEXT:    [[LOOP_COND:%.*]] = icmp eq i32 [[STOP]], 0
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add nsw i64 [[INDVARS_IV]], -1
; CHECK-NEXT:    br i1 [[LOOP_COND]], label [[LOOP]], label [[FAILURE:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    [[TMP2:%.*]] = trunc i64 -1 to i32
; CHECK-NEXT:    ret i32 [[TMP2]]
; CHECK:       failure:
; CHECK-NEXT:    unreachable
;
entry:
  br label %loop

loop:
  %iv = phi i32 [%start, %entry], [%iv.next.1, %backedge]
  %cond = icmp eq i32 %iv, 0
  %foo = add i32 %iv, -1
  br i1 %cond, label %exit, label %backedge

backedge:
  %index = zext i32 %foo to i64
  %store.addr = getelementptr i32, ptr %p, i64 %index
  store i32 1, ptr %store.addr
  %load.addr = getelementptr i32, ptr %q, i64 %index
  %stop = load i32, ptr %q
  %loop.cond = icmp eq i32 %stop, 0
  %iv.next.1 = add i32 %iv, -1
  br i1 %loop.cond, label %loop, label %failure

exit:
  ret i32 %foo

failure:
  unreachable
}

declare void @test14a-callee(i1 %cond)

; Same as @test14 but with unwind exit.
; Trunc instructions must be added below the landing pad.
define i32 @test14a(i32 %start, ptr %p, ptr %q, i1 %c) personality i1 1 {
; CHECK-LABEL: @test14a(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = zext i32 [[START:%.*]] to i64
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ [[INDVARS_IV_NEXT:%.*]], [[BACKEDGE:%.*]] ], [ [[TMP0]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[COND:%.*]] = icmp eq i64 [[INDVARS_IV]], 0
; CHECK-NEXT:    [[TMP1:%.*]] = add nsw i64 [[INDVARS_IV]], -1
; CHECK-NEXT:    br i1 [[COND]], label [[EXIT:%.*]], label [[BACKEDGE]]
; CHECK:       backedge:
; CHECK-NEXT:    [[STORE_ADDR:%.*]] = getelementptr i32, ptr [[P:%.*]], i64 [[TMP1]]
; CHECK-NEXT:    store i32 1, ptr [[STORE_ADDR]], align 4
; CHECK-NEXT:    [[STOP:%.*]] = load i32, ptr [[Q:%.*]], align 4
; CHECK-NEXT:    [[LOOP_COND:%.*]] = icmp eq i32 [[STOP]], 0
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add nsw i64 [[INDVARS_IV]], -1
; CHECK-NEXT:    invoke void @test14a-callee(i1 [[LOOP_COND]])
; CHECK-NEXT:    to label [[LOOP]] unwind label [[EXCEPTION:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    [[TMP2:%.*]] = trunc i64 -1 to i32
; CHECK-NEXT:    ret i32 [[TMP2]]
; CHECK:       exception:
; CHECK-NEXT:    [[FOO_LCSSA1_WIDE:%.*]] = phi i64 [ [[TMP1]], [[BACKEDGE]] ]
; CHECK-NEXT:    [[TMP3:%.*]] = landingpad i1
; CHECK-NEXT:    cleanup
; CHECK-NEXT:    [[TMP4:%.*]] = trunc i64 [[FOO_LCSSA1_WIDE]] to i32
; CHECK-NEXT:    ret i32 [[TMP4]]
;
entry:
  br label %loop

loop:
  %iv = phi i32 [%start, %entry], [%iv.next.1, %backedge]
  %cond = icmp eq i32 %iv, 0
  %foo = add i32 %iv, -1
  br i1 %cond, label %exit, label %backedge

backedge:
  %index = zext i32 %foo to i64
  %store.addr = getelementptr i32, ptr %p, i64 %index
  store i32 1, ptr %store.addr
  %load.addr = getelementptr i32, ptr %q, i64 %index
  %stop = load i32, ptr %q
  %loop.cond = icmp eq i32 %stop, 0
  %iv.next.1 = add i32 %iv, -1
  invoke void @test14a-callee(i1 %loop.cond) to label %loop unwind label %exception

exit:
  ret i32 %foo

exception:
  landingpad i1
  cleanup
  ret i32 %foo
}

declare void @use(i32 %arg)

define i32 @test15(i32 %start, ptr %p, ptr %q) {
; CHECK-LABEL: @test15(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = zext i32 [[START:%.*]] to i64
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ [[INDVARS_IV_NEXT:%.*]], [[BACKEDGE:%.*]] ], [ [[TMP0]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[COND:%.*]] = icmp eq i64 [[INDVARS_IV]], 0
; CHECK-NEXT:    [[TMP1:%.*]] = add nsw i64 [[INDVARS_IV]], -1
; CHECK-NEXT:    br i1 [[COND]], label [[EXIT:%.*]], label [[BACKEDGE]]
; CHECK:       backedge:
; CHECK-NEXT:    [[STORE_ADDR:%.*]] = getelementptr i32, ptr [[P:%.*]], i64 [[TMP1]]
; CHECK-NEXT:    store i32 1, ptr [[STORE_ADDR]], align 4
; CHECK-NEXT:    [[STOP:%.*]] = load i32, ptr [[Q:%.*]], align 4
; CHECK-NEXT:    [[LOOP_COND:%.*]] = icmp eq i32 [[STOP]], 0
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add nsw i64 [[INDVARS_IV]], -1
; CHECK-NEXT:    br i1 [[LOOP_COND]], label [[LOOP]], label [[FAILURE:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    [[TMP2:%.*]] = trunc i64 -1 to i32
; CHECK-NEXT:    call void @use(i32 [[TMP2]])
; CHECK-NEXT:    ret i32 [[TMP2]]
; CHECK:       failure:
; CHECK-NEXT:    [[FOO_LCSSA1_WIDE:%.*]] = phi i64 [ [[TMP1]], [[BACKEDGE]] ]
; CHECK-NEXT:    [[TMP3:%.*]] = trunc i64 [[FOO_LCSSA1_WIDE]] to i32
; CHECK-NEXT:    call void @use(i32 [[TMP3]])
; CHECK-NEXT:    unreachable
;
entry:
  br label %loop

loop:
  %iv = phi i32 [%start, %entry], [%iv.next.1, %backedge]
  %cond = icmp eq i32 %iv, 0
  %foo = add i32 %iv, -1
  br i1 %cond, label %exit, label %backedge

backedge:
  %index = zext i32 %foo to i64
  %store.addr = getelementptr i32, ptr %p, i64 %index
  store i32 1, ptr %store.addr
  %load.addr = getelementptr i32, ptr %q, i64 %index
  %stop = load i32, ptr %q
  %loop.cond = icmp eq i32 %stop, 0
  %iv.next.1 = add i32 %iv, -1
  br i1 %loop.cond, label %loop, label %failure

exit:
  call void @use(i32 %foo)
  ret i32 %foo

failure:
  call void @use(i32 %foo)
  unreachable
}

define i32 @test16_unsigned_pos1(i32 %start, ptr %p, ptr %q, i32 %x) {
; CHECK-LABEL: @test16_unsigned_pos1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = zext i32 [[START:%.*]] to i64
; CHECK-NEXT:    [[TMP1:%.*]] = add nsw i64 [[TMP0]], -1
; CHECK-NEXT:    [[TMP2:%.*]] = zext i32 [[X:%.*]] to i64
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ [[INDVARS_IV_NEXT:%.*]], [[BACKEDGE:%.*]] ], [ [[TMP0]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[COND:%.*]] = icmp eq i64 [[INDVARS_IV]], 0
; CHECK-NEXT:    [[TMP3:%.*]] = add nsw i64 [[INDVARS_IV]], -1
; CHECK-NEXT:    br i1 [[COND]], label [[EXIT:%.*]], label [[GUARDED:%.*]]
; CHECK:       guarded:
; CHECK-NEXT:    [[ICMP_USER_WIDE5:%.*]] = icmp ult i64 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    br i1 [[ICMP_USER_WIDE5]], label [[BACKEDGE]], label [[SIDE_EXIT:%.*]]
; CHECK:       backedge:
; CHECK-NEXT:    [[STORE_ADDR:%.*]] = getelementptr i32, ptr [[P:%.*]], i64 [[TMP3]]
; CHECK-NEXT:    store i32 1, ptr [[STORE_ADDR]], align 4
; CHECK-NEXT:    [[STOP:%.*]] = load i32, ptr [[Q:%.*]], align 4
; CHECK-NEXT:    [[LOOP_COND:%.*]] = icmp eq i32 [[STOP]], 0
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add nsw i64 [[INDVARS_IV]], -1
; CHECK-NEXT:    br i1 [[LOOP_COND]], label [[LOOP]], label [[FAILURE:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    [[TMP4:%.*]] = trunc i64 -1 to i32
; CHECK-NEXT:    call void @use(i32 [[TMP4]])
; CHECK-NEXT:    ret i32 [[TMP4]]
; CHECK:       failure:
; CHECK-NEXT:    [[FOO_LCSSA2_WIDE:%.*]] = phi i64 [ [[TMP3]], [[BACKEDGE]] ]
; CHECK-NEXT:    [[TMP5:%.*]] = trunc i64 [[FOO_LCSSA2_WIDE]] to i32
; CHECK-NEXT:    call void @use(i32 [[TMP5]])
; CHECK-NEXT:    unreachable
; CHECK:       side_exit:
; CHECK-NEXT:    ret i32 0
;
entry:
  br label %loop

loop:
  %iv = phi i32 [%start, %entry], [%iv.next.1, %backedge]
  %cond = icmp eq i32 %iv, 0
  %foo = add i32 %iv, -1
  br i1 %cond, label %exit, label %guarded

guarded:
  %icmp_user = icmp ult i32 %foo, %x
  br i1 %icmp_user, label %backedge, label %side_exit

backedge:
  %index = zext i32 %foo to i64
  %store.addr = getelementptr i32, ptr %p, i64 %index
  store i32 1, ptr %store.addr
  %load.addr = getelementptr i32, ptr %q, i64 %index
  %stop = load i32, ptr %q
  %loop.cond = icmp eq i32 %stop, 0
  %iv.next.1 = add i32 %iv, -1
  br i1 %loop.cond, label %loop, label %failure

exit:
  call void @use(i32 %foo)
  ret i32 %foo

failure:
  call void @use(i32 %foo)
  unreachable

side_exit:
  ret i32 0
}

; TODO: We can widen here despite the icmp user of %foo in guarded block.
define i32 @test16_unsigned_pos2(i32 %start, ptr %p, ptr %q, i32 %x) {
; CHECK-LABEL: @test16_unsigned_pos2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = zext i32 [[START:%.*]] to i64
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ [[INDVARS_IV_NEXT:%.*]], [[BACKEDGE:%.*]] ], [ [[TMP0]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[COND:%.*]] = icmp eq i64 [[INDVARS_IV]], 0
; CHECK-NEXT:    [[TMP1:%.*]] = add nsw i64 [[INDVARS_IV]], -1
; CHECK-NEXT:    br i1 [[COND]], label [[EXIT:%.*]], label [[GUARDED:%.*]]
; CHECK:       guarded:
; CHECK-NEXT:    [[TMP2:%.*]] = zext i32 [[X:%.*]] to i64
; CHECK-NEXT:    [[ICMP_USER_WIDE:%.*]] = icmp ne i64 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    br i1 [[ICMP_USER_WIDE]], label [[BACKEDGE]], label [[SIDE_EXIT:%.*]]
; CHECK:       backedge:
; CHECK-NEXT:    [[STORE_ADDR:%.*]] = getelementptr i32, ptr [[P:%.*]], i64 [[TMP1]]
; CHECK-NEXT:    store i32 1, ptr [[STORE_ADDR]], align 4
; CHECK-NEXT:    [[STOP:%.*]] = load i32, ptr [[Q:%.*]], align 4
; CHECK-NEXT:    [[LOOP_COND:%.*]] = icmp eq i32 [[STOP]], 0
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add nsw i64 [[INDVARS_IV]], -1
; CHECK-NEXT:    br i1 [[LOOP_COND]], label [[LOOP]], label [[FAILURE:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    [[TMP3:%.*]] = trunc i64 -1 to i32
; CHECK-NEXT:    call void @use(i32 [[TMP3]])
; CHECK-NEXT:    ret i32 [[TMP3]]
; CHECK:       failure:
; CHECK-NEXT:    [[FOO_LCSSA2_WIDE:%.*]] = phi i64 [ [[TMP1]], [[BACKEDGE]] ]
; CHECK-NEXT:    [[TMP4:%.*]] = trunc i64 [[FOO_LCSSA2_WIDE]] to i32
; CHECK-NEXT:    call void @use(i32 [[TMP4]])
; CHECK-NEXT:    unreachable
; CHECK:       side_exit:
; CHECK-NEXT:    ret i32 0
;
entry:
  br label %loop

loop:
  %iv = phi i32 [%start, %entry], [%iv.next.1, %backedge]
  %cond = icmp eq i32 %iv, 0
  %foo = add i32 %iv, -1
  br i1 %cond, label %exit, label %guarded

guarded:
  %icmp_user = icmp ne i32 %foo, %x
  br i1 %icmp_user, label %backedge, label %side_exit

backedge:
  %index = zext i32 %foo to i64
  %store.addr = getelementptr i32, ptr %p, i64 %index
  store i32 1, ptr %store.addr
  %load.addr = getelementptr i32, ptr %q, i64 %index
  %stop = load i32, ptr %q
  %loop.cond = icmp eq i32 %stop, 0
  %iv.next.1 = add i32 %iv, -1
  br i1 %loop.cond, label %loop, label %failure

exit:
  call void @use(i32 %foo)
  ret i32 %foo

failure:
  call void @use(i32 %foo)
  unreachable

side_exit:
  ret i32 0
}

; icmp slt user in guarded block prevents widening.
define i32 @test16_unsigned_neg(i32 %start, ptr %p, ptr %q, i32 %x) {
; CHECK-LABEL: @test16_unsigned_neg(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = zext i32 [[START:%.*]] to i64
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ [[INDVARS_IV_NEXT:%.*]], [[BACKEDGE:%.*]] ], [ [[TMP0]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[COND:%.*]] = icmp eq i64 [[INDVARS_IV]], 0
; CHECK-NEXT:    [[TMP1:%.*]] = trunc i64 [[INDVARS_IV]] to i32
; CHECK-NEXT:    [[FOO:%.*]] = add i32 [[TMP1]], -1
; CHECK-NEXT:    br i1 [[COND]], label [[EXIT:%.*]], label [[GUARDED:%.*]]
; CHECK:       guarded:
; CHECK-NEXT:    [[ICMP_USER:%.*]] = icmp slt i32 [[FOO]], [[X:%.*]]
; CHECK-NEXT:    br i1 [[ICMP_USER]], label [[BACKEDGE]], label [[SIDE_EXIT:%.*]]
; CHECK:       backedge:
; CHECK-NEXT:    [[INDEX:%.*]] = zext i32 [[FOO]] to i64
; CHECK-NEXT:    [[STORE_ADDR:%.*]] = getelementptr i32, ptr [[P:%.*]], i64 [[INDEX]]
; CHECK-NEXT:    store i32 1, ptr [[STORE_ADDR]], align 4
; CHECK-NEXT:    [[LOAD_ADDR:%.*]] = getelementptr i32, ptr [[Q:%.*]], i64 [[INDEX]]
; CHECK-NEXT:    [[STOP:%.*]] = load i32, ptr [[Q]], align 4
; CHECK-NEXT:    [[LOOP_COND:%.*]] = icmp eq i32 [[STOP]], 0
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add nsw i64 [[INDVARS_IV]], -1
; CHECK-NEXT:    br i1 [[LOOP_COND]], label [[LOOP]], label [[FAILURE:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    call void @use(i32 -1)
; CHECK-NEXT:    ret i32 -1
; CHECK:       failure:
; CHECK-NEXT:    [[FOO_LCSSA2:%.*]] = phi i32 [ [[FOO]], [[BACKEDGE]] ]
; CHECK-NEXT:    call void @use(i32 [[FOO_LCSSA2]])
; CHECK-NEXT:    unreachable
; CHECK:       side_exit:
; CHECK-NEXT:    ret i32 0
;
entry:
  br label %loop

loop:
  %iv = phi i32 [%start, %entry], [%iv.next.1, %backedge]
  %cond = icmp eq i32 %iv, 0
  %foo = add i32 %iv, -1
  br i1 %cond, label %exit, label %guarded

guarded:
  %icmp_user = icmp slt i32 %foo, %x
  br i1 %icmp_user, label %backedge, label %side_exit

backedge:
  %index = zext i32 %foo to i64
  %store.addr = getelementptr i32, ptr %p, i64 %index
  store i32 1, ptr %store.addr
  %load.addr = getelementptr i32, ptr %q, i64 %index
  %stop = load i32, ptr %q
  %loop.cond = icmp eq i32 %stop, 0
  %iv.next.1 = add i32 %iv, -1
  br i1 %loop.cond, label %loop, label %failure

exit:
  call void @use(i32 %foo)
  ret i32 %foo

failure:
  call void @use(i32 %foo)
  unreachable

side_exit:
  ret i32 0
}

; TODO: We can widen here despite the icmp user of %foo in guarded block.
define i32 @test16_signed_pos1(i32 %start, ptr %p, ptr %q, i32 %x) {
; CHECK-LABEL: @test16_signed_pos1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ [[START:%.*]], [[ENTRY:%.*]] ], [ [[IV_NEXT_1:%.*]], [[BACKEDGE:%.*]] ]
; CHECK-NEXT:    [[COND:%.*]] = icmp eq i32 [[IV]], 0
; CHECK-NEXT:    [[FOO:%.*]] = add i32 [[IV]], -1
; CHECK-NEXT:    br i1 [[COND]], label [[EXIT:%.*]], label [[GUARDED:%.*]]
; CHECK:       guarded:
; CHECK-NEXT:    [[ICMP_USER:%.*]] = icmp slt i32 [[FOO]], [[X:%.*]]
; CHECK-NEXT:    br i1 [[ICMP_USER]], label [[BACKEDGE]], label [[SIDE_EXIT:%.*]]
; CHECK:       backedge:
; CHECK-NEXT:    [[INDEX:%.*]] = sext i32 [[FOO]] to i64
; CHECK-NEXT:    [[STORE_ADDR:%.*]] = getelementptr i32, ptr [[P:%.*]], i64 [[INDEX]]
; CHECK-NEXT:    store i32 1, ptr [[STORE_ADDR]], align 4
; CHECK-NEXT:    [[LOAD_ADDR:%.*]] = getelementptr i32, ptr [[Q:%.*]], i64 [[INDEX]]
; CHECK-NEXT:    [[STOP:%.*]] = load i32, ptr [[Q]], align 4
; CHECK-NEXT:    [[LOOP_COND:%.*]] = icmp eq i32 [[STOP]], 0
; CHECK-NEXT:    [[IV_NEXT_1]] = add i32 [[IV]], -1
; CHECK-NEXT:    br i1 [[LOOP_COND]], label [[LOOP]], label [[FAILURE:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    call void @use(i32 -1)
; CHECK-NEXT:    ret i32 -1
; CHECK:       failure:
; CHECK-NEXT:    [[FOO_LCSSA2:%.*]] = phi i32 [ [[FOO]], [[BACKEDGE]] ]
; CHECK-NEXT:    call void @use(i32 [[FOO_LCSSA2]])
; CHECK-NEXT:    unreachable
; CHECK:       side_exit:
; CHECK-NEXT:    ret i32 0
;
entry:
  br label %loop

loop:
  %iv = phi i32 [%start, %entry], [%iv.next.1, %backedge]
  %cond = icmp eq i32 %iv, 0
  %foo = add i32 %iv, -1
  br i1 %cond, label %exit, label %guarded

guarded:
  %icmp_user = icmp slt i32 %foo, %x
  br i1 %icmp_user, label %backedge, label %side_exit

backedge:
  %index = sext i32 %foo to i64
  %store.addr = getelementptr i32, ptr %p, i64 %index
  store i32 1, ptr %store.addr
  %load.addr = getelementptr i32, ptr %q, i64 %index
  %stop = load i32, ptr %q
  %loop.cond = icmp eq i32 %stop, 0
  %iv.next.1 = add i32 %iv, -1
  br i1 %loop.cond, label %loop, label %failure

exit:
  call void @use(i32 %foo)
  ret i32 %foo

failure:
  call void @use(i32 %foo)
  unreachable

side_exit:
  ret i32 0
}

; TODO: We can widen here despite the icmp user of %foo in guarded block.
define i32 @test16_signed_pos2(i32 %start, ptr %p, ptr %q, i32 %x) {
; CHECK-LABEL: @test16_signed_pos2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ [[START:%.*]], [[ENTRY:%.*]] ], [ [[IV_NEXT_1:%.*]], [[BACKEDGE:%.*]] ]
; CHECK-NEXT:    [[COND:%.*]] = icmp eq i32 [[IV]], 0
; CHECK-NEXT:    [[FOO:%.*]] = add i32 [[IV]], -1
; CHECK-NEXT:    br i1 [[COND]], label [[EXIT:%.*]], label [[GUARDED:%.*]]
; CHECK:       guarded:
; CHECK-NEXT:    [[ICMP_USER:%.*]] = icmp ne i32 [[FOO]], [[X:%.*]]
; CHECK-NEXT:    br i1 [[ICMP_USER]], label [[BACKEDGE]], label [[SIDE_EXIT:%.*]]
; CHECK:       backedge:
; CHECK-NEXT:    [[INDEX:%.*]] = sext i32 [[FOO]] to i64
; CHECK-NEXT:    [[STORE_ADDR:%.*]] = getelementptr i32, ptr [[P:%.*]], i64 [[INDEX]]
; CHECK-NEXT:    store i32 1, ptr [[STORE_ADDR]], align 4
; CHECK-NEXT:    [[LOAD_ADDR:%.*]] = getelementptr i32, ptr [[Q:%.*]], i64 [[INDEX]]
; CHECK-NEXT:    [[STOP:%.*]] = load i32, ptr [[Q]], align 4
; CHECK-NEXT:    [[LOOP_COND:%.*]] = icmp eq i32 [[STOP]], 0
; CHECK-NEXT:    [[IV_NEXT_1]] = add i32 [[IV]], -1
; CHECK-NEXT:    br i1 [[LOOP_COND]], label [[LOOP]], label [[FAILURE:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    call void @use(i32 -1)
; CHECK-NEXT:    ret i32 -1
; CHECK:       failure:
; CHECK-NEXT:    [[FOO_LCSSA2:%.*]] = phi i32 [ [[FOO]], [[BACKEDGE]] ]
; CHECK-NEXT:    call void @use(i32 [[FOO_LCSSA2]])
; CHECK-NEXT:    unreachable
; CHECK:       side_exit:
; CHECK-NEXT:    ret i32 0
;
entry:
  br label %loop

loop:
  %iv = phi i32 [%start, %entry], [%iv.next.1, %backedge]
  %cond = icmp eq i32 %iv, 0
  %foo = add i32 %iv, -1
  br i1 %cond, label %exit, label %guarded

guarded:
  %icmp_user = icmp ne i32 %foo, %x
  br i1 %icmp_user, label %backedge, label %side_exit

backedge:
  %index = sext i32 %foo to i64
  %store.addr = getelementptr i32, ptr %p, i64 %index
  store i32 1, ptr %store.addr
  %load.addr = getelementptr i32, ptr %q, i64 %index
  %stop = load i32, ptr %q
  %loop.cond = icmp eq i32 %stop, 0
  %iv.next.1 = add i32 %iv, -1
  br i1 %loop.cond, label %loop, label %failure

exit:
  call void @use(i32 %foo)
  ret i32 %foo

failure:
  call void @use(i32 %foo)
  unreachable

side_exit:
  ret i32 0
}

; icmp ult user in guarded block prevents widening.
define i32 @test16_signed_neg(i32 %start, ptr %p, ptr %q, i32 %x) {
; CHECK-LABEL: @test16_signed_neg(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = add i32 [[START:%.*]], -1
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ [[START]], [[ENTRY:%.*]] ], [ [[IV_NEXT_1:%.*]], [[BACKEDGE:%.*]] ]
; CHECK-NEXT:    [[COND:%.*]] = icmp eq i32 [[IV]], 0
; CHECK-NEXT:    [[FOO:%.*]] = add i32 [[IV]], -1
; CHECK-NEXT:    br i1 [[COND]], label [[EXIT:%.*]], label [[GUARDED:%.*]]
; CHECK:       guarded:
; CHECK-NEXT:    [[ICMP_USER3:%.*]] = icmp ult i32 [[TMP0]], [[X:%.*]]
; CHECK-NEXT:    br i1 [[ICMP_USER3]], label [[BACKEDGE]], label [[SIDE_EXIT:%.*]]
; CHECK:       backedge:
; CHECK-NEXT:    [[INDEX:%.*]] = sext i32 [[FOO]] to i64
; CHECK-NEXT:    [[STORE_ADDR:%.*]] = getelementptr i32, ptr [[P:%.*]], i64 [[INDEX]]
; CHECK-NEXT:    store i32 1, ptr [[STORE_ADDR]], align 4
; CHECK-NEXT:    [[LOAD_ADDR:%.*]] = getelementptr i32, ptr [[Q:%.*]], i64 [[INDEX]]
; CHECK-NEXT:    [[STOP:%.*]] = load i32, ptr [[Q]], align 4
; CHECK-NEXT:    [[LOOP_COND:%.*]] = icmp eq i32 [[STOP]], 0
; CHECK-NEXT:    [[IV_NEXT_1]] = add i32 [[IV]], -1
; CHECK-NEXT:    br i1 [[LOOP_COND]], label [[LOOP]], label [[FAILURE:%.*]]
; CHECK:       exit:
; CHECK-NEXT:    call void @use(i32 -1)
; CHECK-NEXT:    ret i32 -1
; CHECK:       failure:
; CHECK-NEXT:    [[FOO_LCSSA2:%.*]] = phi i32 [ [[FOO]], [[BACKEDGE]] ]
; CHECK-NEXT:    call void @use(i32 [[FOO_LCSSA2]])
; CHECK-NEXT:    unreachable
; CHECK:       side_exit:
; CHECK-NEXT:    ret i32 0
;
entry:
  br label %loop

loop:
  %iv = phi i32 [%start, %entry], [%iv.next.1, %backedge]
  %cond = icmp eq i32 %iv, 0
  %foo = add i32 %iv, -1
  br i1 %cond, label %exit, label %guarded

guarded:
  %icmp_user = icmp ult i32 %foo, %x
  br i1 %icmp_user, label %backedge, label %side_exit

backedge:
  %index = sext i32 %foo to i64
  %store.addr = getelementptr i32, ptr %p, i64 %index
  store i32 1, ptr %store.addr
  %load.addr = getelementptr i32, ptr %q, i64 %index
  %stop = load i32, ptr %q
  %loop.cond = icmp eq i32 %stop, 0
  %iv.next.1 = add i32 %iv, -1
  br i1 %loop.cond, label %loop, label %failure

exit:
  call void @use(i32 %foo)
  ret i32 %foo

failure:
  call void @use(i32 %foo)
  unreachable

side_exit:
  ret i32 0
}

define i32 @test17(ptr %p, i32 %len) {
; CHECK-LABEL: @test17(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = zext i32 [[LEN:%.*]] to i64
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ [[INDVARS_IV_NEXT:%.*]], [[BACKEDGE:%.*]] ], [ [[TMP0]], [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[TMP1:%.*]] = add nsw i64 [[INDVARS_IV]], -1
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add nsw i64 [[INDVARS_IV]], -1
; CHECK-NEXT:    [[COND_1:%.*]] = icmp eq i64 [[INDVARS_IV]], 0
; CHECK-NEXT:    br i1 [[COND_1]], label [[EXIT:%.*]], label [[BACKEDGE]]
; CHECK:       backedge:
; CHECK-NEXT:    [[ADDR:%.*]] = getelementptr inbounds i32, ptr [[P:%.*]], i64 [[TMP1]]
; CHECK-NEXT:    [[LOADED:%.*]] = load atomic i32, ptr [[ADDR]] unordered, align 4
; CHECK-NEXT:    [[COND_2:%.*]] = icmp eq i32 [[LOADED]], 0
; CHECK-NEXT:    br i1 [[COND_2]], label [[FAILURE:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    [[TMP2:%.*]] = trunc i64 -1 to i32
; CHECK-NEXT:    ret i32 [[TMP2]]
; CHECK:       failure:
; CHECK-NEXT:    unreachable
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ %iv.next, %backedge ], [ %len, %entry ]
  %iv.next = add i32 %iv, -1
  %cond_1 = icmp eq i32 %iv, 0
  br i1 %cond_1, label %exit, label %backedge

backedge:
  %iv.next.wide = zext i32 %iv.next to i64
  %addr = getelementptr inbounds i32, ptr %p, i64 %iv.next.wide
  %loaded = load atomic i32, ptr %addr unordered, align 4
  %cond_2 = icmp eq i32 %loaded, 0
  br i1 %cond_2, label %failure, label %loop

exit:
  ret i32 %iv.next

failure:
  unreachable
}

declare void @foo(i64 %v)
declare void @bar(i32 %v)

define void @test18() {
; CHECK-LABEL: @test18(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ [[INDVARS_IV_NEXT:%.*]], [[LOOP]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; CHECK-NEXT:    [[INDVARS2:%.*]] = trunc i64 [[INDVARS_IV_NEXT]] to i32
; CHECK-NEXT:    call void @bar(i32 [[INDVARS2]])
; CHECK-NEXT:    call void @foo(i64 [[INDVARS_IV]])
; CHECK-NEXT:    [[LOOP_COND:%.*]] = icmp eq i64 [[INDVARS_IV]], 1000
; CHECK-NEXT:    br i1 [[LOOP_COND]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:                                             ; preds = %loop, %entry
  %iv = phi i32 [ %iv.next, %loop ], [ 0, %entry ]
  %val1 = phi i32 [ %val1.inc, %loop ], [ 0, %entry ]
  %val1.inc = add i32 %val1, 1
  %iv.next = add i32 %iv, 1
  call void @bar(i32 %val1.inc)
  %iv.wide = zext i32 %iv to i64
  call void @foo(i64 %iv.wide)
  %loop.cond = icmp eq i32 %iv, 1000
  br i1 %loop.cond, label %exit, label %loop

exit:                                             ; preds = %loop
  ret void
}

define void @test19() {
; CHECK-LABEL: @test19(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[VAL1:%.*]] = phi i64 [ [[VAL1_INC:%.*]], [[LOOP]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[VAL1_INC]] = add nuw nsw i64 [[VAL1]], 1
; CHECK-NEXT:    call void @foo(i64 [[VAL1_INC]])
; CHECK-NEXT:    call void @foo(i64 [[VAL1]])
; CHECK-NEXT:    [[LOOP_COND:%.*]] = icmp eq i64 [[VAL1]], 1000
; CHECK-NEXT:    br i1 [[LOOP_COND]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:                                             ; preds = %loop, %entry
  %iv = phi i32 [ %iv.next, %loop ], [ 0, %entry ]
  %val1 = phi i64 [ %val1.inc, %loop ], [ 0, %entry ]
  %val1.inc = add i64 %val1, 1
  %iv.next = add i32 %iv, 1
  call void @foo(i64 %val1.inc)
  %iv.wide = zext i32 %iv to i64
  call void @foo(i64 %iv.wide)
  %loop.cond = icmp eq i32 %iv, 1000
  br i1 %loop.cond, label %exit, label %loop

exit:                                             ; preds = %loop
  ret void
}

define void @test20() {
; CHECK-LABEL: @test20(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ [[INDVARS_IV_NEXT:%.*]], [[LOOP]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; CHECK-NEXT:    call void @foo(i64 [[INDVARS_IV]])
; CHECK-NEXT:    call void @foo(i64 [[INDVARS_IV]])
; CHECK-NEXT:    [[LOOP_COND:%.*]] = icmp eq i64 [[INDVARS_IV]], 1000
; CHECK-NEXT:    br i1 [[LOOP_COND]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop

loop:                                             ; preds = %loop, %entry
  %iv = phi i32 [ %iv.next, %loop ], [ 0, %entry ]
  %val1 = phi i32 [ %val1.inc, %loop ], [ 0, %entry ]
  %val1.inc = add i32 %val1, 1
  %iv.next = add i32 %iv, 1
  %val1.wide = zext i32 %val1 to i64
  call void @foo(i64 %val1.wide)
  %iv.wide = zext i32 %iv to i64
  call void @foo(i64 %iv.wide)
  %loop.cond = icmp eq i32 %iv, 1000
  br i1 %loop.cond, label %exit, label %loop

exit:                                             ; preds = %loop
  ret void
}

define void @test21(ptr %ptr) {
; CHECK-LABEL: @test21(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store i32 0, ptr [[PTR:%.*]], align 4
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[INDVARS_IV:%.*]] = phi i64 [ [[INDVARS_IV_NEXT:%.*]], [[LOOP]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[INDVARS_IV_NEXT]] = add nuw nsw i64 [[INDVARS_IV]], 1
; CHECK-NEXT:    [[INDVARS:%.*]] = trunc i64 [[INDVARS_IV_NEXT]] to i32
; CHECK-NEXT:    store i32 [[INDVARS]], ptr [[PTR]], align 4
; CHECK-NEXT:    call void @foo(i64 [[INDVARS_IV]])
; CHECK-NEXT:    [[LOOP_COND:%.*]] = icmp eq i64 [[INDVARS_IV]], 1000
; CHECK-NEXT:    br i1 [[LOOP_COND]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  store i32 0, ptr %ptr, align 4
  br label %loop

loop:                                             ; preds = %loop, %entry
  %val = phi i32 [ %val.inc, %loop ], [ 0, %entry ]
  %iv = phi i32 [ %iv.next, %loop ], [ 0, %entry ]
  %val.inc = add i32 %val, 1
  store i32 %val.inc, ptr %ptr, align 4
  %iv.wide = zext i32 %iv to i64
  call void @foo(i64 %iv.wide)
  %iv.next = add i32 %iv, 1
  %loop.cond = icmp eq i32 %iv, 1000
  br i1 %loop.cond, label %exit, label %loop

exit:                                             ; preds = %loop
  ret void
}

define void @test22(ptr %ptr) {
; CHECK-LABEL: @test22(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store i16 0, ptr [[PTR:%.*]], align 4
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ [[IV_NEXT:%.*]], [[LOOP]] ], [ 0, [[ENTRY:%.*]] ]
; CHECK-NEXT:    [[INDVARS:%.*]] = trunc i32 [[IV]] to i16
; CHECK-NEXT:    [[VAL_INC:%.*]] = add i16 [[INDVARS]], 1
; CHECK-NEXT:    store i16 [[VAL_INC]], ptr [[PTR]], align 4
; CHECK-NEXT:    [[IV_WIDE:%.*]] = zext i32 [[IV]] to i64
; CHECK-NEXT:    call void @foo(i64 [[IV_WIDE]])
; CHECK-NEXT:    [[IV_NEXT]] = zext i16 [[VAL_INC]] to i32
; CHECK-NEXT:    [[LOOP_COND:%.*]] = icmp eq i32 [[IV]], 1000
; CHECK-NEXT:    br i1 [[LOOP_COND]], label [[EXIT:%.*]], label [[LOOP]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  store i16 0, ptr %ptr, align 4
  br label %loop

loop:                                             ; preds = %loop, %entry
  %val = phi i16 [ %val.inc, %loop ], [ 0, %entry ]
  %iv = phi i32 [ %iv.next, %loop ], [ 0, %entry ]
  %val.inc = add i16 %val, 1
  store i16 %val.inc, ptr %ptr, align 4
  %iv.wide = zext i32 %iv to i64
  call void @foo(i64 %iv.wide)
  %iv.next = zext i16 %val.inc to i32
  %loop.cond = icmp eq i32 %iv, 1000
  br i1 %loop.cond, label %exit, label %loop

exit:                                             ; preds = %loop
  ret void
}
