// Copyright 2019 Google LLC.
// Use of this source code is governed by a BSD-style license that can be found in the LICENSE file.
#include "tools/fiddle/examples.h"
// HASH=7000b501f49341629bfdd9f80e686103
REG_FIDDLE(Path_Iter_isCloseLine, 256, 256, true, 0) {
void draw(SkCanvas* canvas) {
   SkPath path;
   path.moveTo(6, 7);
   path.conicTo(1, 2, 3, 4, .5f);
   path.close();
   SkPath::Iter iter(path, false);
   SkPoint p[4];
   SkDebugf("1st verb is " "%s" "move\n", SkPath::kMove_Verb == iter.next(p) ? "" : "not ");
   SkDebugf("moveTo point: {%g,%g}\n", p[0].fX, p[0].fY);
   SkDebugf("2nd verb is " "%s" "conic\n", SkPath::kConic_Verb == iter.next(p) ? "" : "not ");
   SkDebugf("3rd verb is " "%s" "line\n", SkPath::kLine_Verb == iter.next(p) ? "" : "not ");
   SkDebugf("line points: {%g,%g}, {%g,%g}\n", p[0].fX, p[0].fY, p[1].fX, p[1].fY);
   SkDebugf("line " "%s" "generated by close\n", iter.isCloseLine() ? "" : "not ");
   SkDebugf("4th verb is " "%s" "close\n", SkPath::kClose_Verb == iter.next(p) ? "" : "not ");
}
}  // END FIDDLE
