"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _chalk = _interopRequireDefault(require("chalk"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* eslint-disable camelcase */
const Text = ({
  bold,
  italic,
  underline,
  strikethrough,
  children,
  unstable__transformChildren
}) => {
  const transformChildren = children => {
    if (bold) {
      children = _chalk.default.bold(children);
    }

    if (italic) {
      children = _chalk.default.italic(children);
    }

    if (underline) {
      children = _chalk.default.underline(children);
    }

    if (strikethrough) {
      children = _chalk.default.strikethrough(children);
    }

    if (unstable__transformChildren) {
      children = unstable__transformChildren(children);
    }

    return children;
  };

  return _react.default.createElement("span", {
    style: {
      flexDirection: 'row'
    },
    unstable__transformChildren: transformChildren
  }, children);
};
/* eslint-disable react/boolean-prop-naming */


Text.propTypes = {
  bold: _propTypes.default.bool,
  italic: _propTypes.default.bool,
  underline: _propTypes.default.bool,
  strikethrough: _propTypes.default.bool,
  children: _propTypes.default.node.isRequired,
  unstable__transformChildren: _propTypes.default.func
};
/* eslint-enable react/boolean-prop-naming */

Text.defaultProps = {
  bold: false,
  italic: false,
  underline: false,
  strikethrough: false,
  unstable__transformChildren: undefined
};
var _default = Text;
exports.default = _default;