/*
 * Decompiled with CFR 0.152.
 */
package org.scidac.cmcs.tools.bse.translators;

import com.sourceforge.knecs.util.converters.FormatException;
import java.io.IOException;
import java.util.Vector;
import org.jdom.Element;
import org.scidac.cmcs.tools.bse.Matrix;
import org.scidac.cmcs.tools.bse.translators.AbstractBasisSetXmlToText;

public class BasisXmlToMeldfEcpInput
extends AbstractBasisSetXmlToText {
    @Override
    public String convert(String filename, Vector elementList, boolean optimize) throws IOException, FormatException {
        return this.readECP(filename, elementList);
    }

    @Override
    protected void addHeaderECP(StringBuffer output, Element root) {
        output.append("Effective core Potentials \n");
        output.append("------------------------- \n");
    }

    @Override
    protected void addElementDescriptionECP(StringBuffer output, Element potentials, String element) {
        String nelec = potentials.getAttributeValue("numElectronsReplaced");
        output.append("! EFFECTIVE CORE POTENTIAL FOR ATOM " + element.toUpperCase() + "\n");
        output.append("! MAXIMUM L VALUE - 1 = !  1\n");
        output.append("! NO. OF CORE ELECTRONS = " + nelec + "\n");
    }

    @Override
    protected void readCmlMatrixECP(StringBuffer output, Matrix matrix, String element, String shell, String potentialType) throws FormatException {
        int rows = matrix.getNumRows();
        int columns = matrix.getNumColumns();
        output.append("! TYPE OF POTENTIAL = " + potentialType + "\n");
        output.append("! NO. OF TERMS = ! " + rows + "\n");
        try {
            for (int j = 0; j < columns; ++j) {
                for (int i = 0; i < rows; ++i) {
                    if (j == 0) {
                        output.append(" " + matrix.getValue(i, j));
                        continue;
                    }
                    String value = this.formattedValue(matrix.getValue(i, j));
                    output.append(value);
                }
                output.append("\n");
            }
        }
        catch (IndexOutOfBoundsException ie) {
            throw new FormatException(ie.getMessage());
        }
    }
}

