use core:debug; // TODO: remove!
use core:lang;
use core:asm;
use lang:bs; // TODO: Extract a generic code generation interface so that we do not have to rely on Expr from BS.

/**
 * Assembler listing. Stores a set of asm instructions for later conversion into the real asm
 * listing format.
 */
class AsmListing extends Expr {
	AsmAtom[] data;

	init(SrcPos pos) {
		init(pos);
	}

	void add(AsmAtom instr) {
		data << instr;
	}

	ExprResult result() {
		ExprResult(); // Always returns void.
	}

	void code(CodeGen state, CodeResult r) {
		Labels l(state);
		// Create all labels.
		for (Nat i = 0; i < data.count; i++) {
			data[i].create(l);
		}

		for (Nat i = 0; i < data.count; i++) {
			data[i].output(state, l);
		}
	}

	Str toS() {
		StrBuf r;
		for (Nat i = 0; i < data.count; i++) {
			r.add(data[i].toS);
			r.add("\n");
		}
		r.toS;
	}
}

/**
 * Class keeping track of all labels.
 * TODO: Check for mismatched labels!
 */
class Labels on Compiler {
	CodeGen gen;
	Str->Label labels;

	init(CodeGen g) {
		init() { gen = g; }
	}

	void create(SrcPos pos, Str name) {
		if (labels.has(name)) {
			throw SyntaxError(pos, "Duplicate label " # name);
		}

		labels.put(name, gen.l.label());
	}

	Label get(Str name) {
		labels.get(name);
	}
}


/**
 * Base class for a single assembler instruction or label.
 */
class AsmAtom on Compiler {

	// Create any resources we need.
	void create(Labels l) {}

	// Generate code.
	void output(CodeGen to, Labels l) {}
}

/**
 * Label for an asm listing.
 */
class AsmLabel extends AsmAtom {
	SrcPos pos;
	Str name;

	init(SrcPos pos, Str name) {
		init() { pos = pos; name = name; }
	}

	void create(Labels l) {
		l.create(pos, name);
	}

	void output(CodeGen to, Labels l) {
		to.l << l.get(name);
	}
}

/**
 * Wrapper for the Operand type so that we can use it as a heap-allocated object.
 */
class AsmOperand on Compiler {
	Operand value;

	init() {
		init();
	}

	cast(Operand v) {
		init() { value = v; }
	}

	// May be overridden.
	Operand v(Labels l) {
		value;
	}

	Str toS() {
		value.toS;
	}
}


/**
 * Label reference.
 */
class AsmLabelRef extends AsmOperand {
	Str name;

	init(Str name) {
		init() { name = name; }
	}

	Operand v(Labels l) {
		Operand(l.get(name));
	}

	Str toS() {
		name # ":";
	}
}
