// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SSRA_8H_2OPIMM_TRACE_AARCH64_H_
#define VIXL_SIM_SSRA_8H_2OPIMM_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_ssra_8H_2OPIMM[] = {
  0xffc0, 0xffc1, 0xffc1, 0xfff8, 0xfffe, 0xffff, 0xffff, 0x0000,
  0xffa0, 0xffa1, 0xffa1, 0xfff4, 0xfffd, 0xfffe, 0xfffe, 0x0000,
  0xff90, 0xff91, 0xff91, 0xfff2, 0xfffc, 0xfffd, 0xfffd, 0x0000,
  0xff88, 0xff89, 0xff89, 0xfff1, 0xfffb, 0xfffc, 0xfffc, 0x0000,
  0xff84, 0xff85, 0xff85, 0xfff0, 0xfffa, 0xfffb, 0xfffb, 0x0000,
  0xff82, 0xff83, 0xff83, 0xffef, 0xfff9, 0xfffa, 0xfffa, 0x0000,
  0xff81, 0xff82, 0xff82, 0xffee, 0xfff8, 0xfff9, 0xfff9, 0x0000,
  0xff80, 0xff81, 0xff81, 0xffed, 0xfff7, 0xfff8, 0xfff8, 0x0000,
  0xff7f, 0xff80, 0xff80, 0xffec, 0xfff6, 0xfff7, 0xfff7, 0x0000,
  0xff7e, 0xff7f, 0xff7f, 0xffeb, 0xfff5, 0xfff6, 0xfff6, 0x0000,
  0xff7d, 0xff7e, 0xff7e, 0xffea, 0xfff4, 0xfff5, 0xfff5, 0x0000,
  0xff7c, 0xff7d, 0xff7d, 0xffe9, 0xfff3, 0xfff4, 0xfff4, 0x0000,
  0xff7b, 0xff7c, 0xff7c, 0xffe8, 0xfff2, 0xfff3, 0xfff3, 0x0000,
  0xff7a, 0xff7b, 0xff7b, 0xffe7, 0xfff1, 0xfff2, 0xfff2, 0x0000,
  0xff79, 0xff7a, 0xff7a, 0xffe6, 0xfff0, 0xfff1, 0xfff1, 0x0000,
  0xff78, 0xff79, 0xff79, 0xffe5, 0xffef, 0xfff0, 0xfff0, 0x0000,
  0xffc1, 0xffc1, 0xfff8, 0xfffe, 0xffff, 0xffff, 0x0000, 0x0000,
  0xffa1, 0xffa1, 0xfff4, 0xfffd, 0xfffe, 0xfffe, 0x0000, 0x0000,
  0xff91, 0xff91, 0xfff2, 0xfffc, 0xfffd, 0xfffd, 0x0000, 0x0000,
  0xff89, 0xff89, 0xfff1, 0xfffb, 0xfffc, 0xfffc, 0x0000, 0x0000,
  0xff85, 0xff85, 0xfff0, 0xfffa, 0xfffb, 0xfffb, 0x0000, 0x0000,
  0xff83, 0xff83, 0xffef, 0xfff9, 0xfffa, 0xfffa, 0x0000, 0x0000,
  0xff82, 0xff82, 0xffee, 0xfff8, 0xfff9, 0xfff9, 0x0000, 0x0000,
  0xff81, 0xff81, 0xffed, 0xfff7, 0xfff8, 0xfff8, 0x0000, 0x0000,
  0xff80, 0xff80, 0xffec, 0xfff6, 0xfff7, 0xfff7, 0x0000, 0x0000,
  0xff7f, 0xff7f, 0xffeb, 0xfff5, 0xfff6, 0xfff6, 0x0000, 0x0000,
  0xff7e, 0xff7e, 0xffea, 0xfff4, 0xfff5, 0xfff5, 0x0000, 0x0000,
  0xff7d, 0xff7d, 0xffe9, 0xfff3, 0xfff4, 0xfff4, 0x0000, 0x0000,
  0xff7c, 0xff7c, 0xffe8, 0xfff2, 0xfff3, 0xfff3, 0x0000, 0x0000,
  0xff7b, 0xff7b, 0xffe7, 0xfff1, 0xfff2, 0xfff2, 0x0000, 0x0000,
  0xff7a, 0xff7a, 0xffe6, 0xfff0, 0xfff1, 0xfff1, 0x0000, 0x0000,
  0xff79, 0xff79, 0xffe5, 0xffef, 0xfff0, 0xfff0, 0x0000, 0x0000,
  0xffc1, 0xfff8, 0xfffe, 0xffff, 0xffff, 0x0000, 0x0000, 0x0001,
  0xffa1, 0xfff4, 0xfffd, 0xfffe, 0xfffe, 0x0000, 0x0000, 0x0001,
  0xff91, 0xfff2, 0xfffc, 0xfffd, 0xfffd, 0x0000, 0x0000, 0x0001,
  0xff89, 0xfff1, 0xfffb, 0xfffc, 0xfffc, 0x0000, 0x0000, 0x0001,
  0xff85, 0xfff0, 0xfffa, 0xfffb, 0xfffb, 0x0000, 0x0000, 0x0001,
  0xff83, 0xffef, 0xfff9, 0xfffa, 0xfffa, 0x0000, 0x0000, 0x0001,
  0xff82, 0xffee, 0xfff8, 0xfff9, 0xfff9, 0x0000, 0x0000, 0x0001,
  0xff81, 0xffed, 0xfff7, 0xfff8, 0xfff8, 0x0000, 0x0000, 0x0001,
  0xff80, 0xffec, 0xfff6, 0xfff7, 0xfff7, 0x0000, 0x0000, 0x0001,
  0xff7f, 0xffeb, 0xfff5, 0xfff6, 0xfff6, 0x0000, 0x0000, 0x0001,
  0xff7e, 0xffea, 0xfff4, 0xfff5, 0xfff5, 0x0000, 0x0000, 0x0001,
  0xff7d, 0xffe9, 0xfff3, 0xfff4, 0xfff4, 0x0000, 0x0000, 0x0001,
  0xff7c, 0xffe8, 0xfff2, 0xfff3, 0xfff3, 0x0000, 0x0000, 0x0001,
  0xff7b, 0xffe7, 0xfff1, 0xfff2, 0xfff2, 0x0000, 0x0000, 0x0001,
  0xff7a, 0xffe6, 0xfff0, 0xfff1, 0xfff1, 0x0000, 0x0000, 0x0001,
  0xff79, 0xffe5, 0xffef, 0xfff0, 0xfff0, 0x0000, 0x0000, 0x0001,
  0xfff8, 0xfffe, 0xffff, 0xffff, 0x0000, 0x0000, 0x0001, 0x0008,
  0xfff4, 0xfffd, 0xfffe, 0xfffe, 0x0000, 0x0000, 0x0001, 0x000c,
  0xfff2, 0xfffc, 0xfffd, 0xfffd, 0x0000, 0x0000, 0x0001, 0x000e,
  0xfff1, 0xfffb, 0xfffc, 0xfffc, 0x0000, 0x0000, 0x0001, 0x000f,
  0xfff0, 0xfffa, 0xfffb, 0xfffb, 0x0000, 0x0000, 0x0001, 0x000f,
  0xffef, 0xfff9, 0xfffa, 0xfffa, 0x0000, 0x0000, 0x0001, 0x000f,
  0xffee, 0xfff8, 0xfff9, 0xfff9, 0x0000, 0x0000, 0x0001, 0x000f,
  0xffed, 0xfff7, 0xfff8, 0xfff8, 0x0000, 0x0000, 0x0001, 0x000f,
  0xffec, 0xfff6, 0xfff7, 0xfff7, 0x0000, 0x0000, 0x0001, 0x000f,
  0xffeb, 0xfff5, 0xfff6, 0xfff6, 0x0000, 0x0000, 0x0001, 0x000f,
  0xffea, 0xfff4, 0xfff5, 0xfff5, 0x0000, 0x0000, 0x0001, 0x000f,
  0xffe9, 0xfff3, 0xfff4, 0xfff4, 0x0000, 0x0000, 0x0001, 0x000f,
  0xffe8, 0xfff2, 0xfff3, 0xfff3, 0x0000, 0x0000, 0x0001, 0x000f,
  0xffe7, 0xfff1, 0xfff2, 0xfff2, 0x0000, 0x0000, 0x0001, 0x000f,
  0xffe6, 0xfff0, 0xfff1, 0xfff1, 0x0000, 0x0000, 0x0001, 0x000f,
  0xffe5, 0xffef, 0xfff0, 0xfff0, 0x0000, 0x0000, 0x0001, 0x000f,
  0xfffe, 0xffff, 0xffff, 0x0000, 0x0000, 0x0001, 0x0008, 0x003e,
  0xfffd, 0xfffe, 0xfffe, 0x0000, 0x0000, 0x0001, 0x000c, 0x005d,
  0xfffc, 0xfffd, 0xfffd, 0x0000, 0x0000, 0x0001, 0x000e, 0x006c,
  0xfffb, 0xfffc, 0xfffc, 0x0000, 0x0000, 0x0001, 0x000f, 0x0073,
  0xfffa, 0xfffb, 0xfffb, 0x0000, 0x0000, 0x0001, 0x000f, 0x0076,
  0xfff9, 0xfffa, 0xfffa, 0x0000, 0x0000, 0x0001, 0x000f, 0x0077,
  0xfff8, 0xfff9, 0xfff9, 0x0000, 0x0000, 0x0001, 0x000f, 0x0077,
  0xfff7, 0xfff8, 0xfff8, 0x0000, 0x0000, 0x0001, 0x000f, 0x0077,
  0xfff6, 0xfff7, 0xfff7, 0x0000, 0x0000, 0x0001, 0x000f, 0x0077,
  0xfff5, 0xfff6, 0xfff6, 0x0000, 0x0000, 0x0001, 0x000f, 0x0077,
  0xfff4, 0xfff5, 0xfff5, 0x0000, 0x0000, 0x0001, 0x000f, 0x0077,
  0xfff3, 0xfff4, 0xfff4, 0x0000, 0x0000, 0x0001, 0x000f, 0x0077,
  0xfff2, 0xfff3, 0xfff3, 0x0000, 0x0000, 0x0001, 0x000f, 0x0077,
  0xfff1, 0xfff2, 0xfff2, 0x0000, 0x0000, 0x0001, 0x000f, 0x0077,
  0xfff0, 0xfff1, 0xfff1, 0x0000, 0x0000, 0x0001, 0x000f, 0x0077,
  0xffef, 0xfff0, 0xfff0, 0x0000, 0x0000, 0x0001, 0x000f, 0x0077,
  0xffff, 0xffff, 0x0000, 0x0000, 0x0001, 0x0008, 0x003e, 0x003f,
  0xfffe, 0xfffe, 0x0000, 0x0000, 0x0001, 0x000c, 0x005d, 0x005e,
  0xfffd, 0xfffd, 0x0000, 0x0000, 0x0001, 0x000e, 0x006c, 0x006d,
  0xfffc, 0xfffc, 0x0000, 0x0000, 0x0001, 0x000f, 0x0073, 0x0074,
  0xfffb, 0xfffb, 0x0000, 0x0000, 0x0001, 0x000f, 0x0076, 0x0077,
  0xfffa, 0xfffa, 0x0000, 0x0000, 0x0001, 0x000f, 0x0077, 0x0078,
  0xfff9, 0xfff9, 0x0000, 0x0000, 0x0001, 0x000f, 0x0077, 0x0078,
  0xfff8, 0xfff8, 0x0000, 0x0000, 0x0001, 0x000f, 0x0077, 0x0078,
  0xfff7, 0xfff7, 0x0000, 0x0000, 0x0001, 0x000f, 0x0077, 0x0078,
  0xfff6, 0xfff6, 0x0000, 0x0000, 0x0001, 0x000f, 0x0077, 0x0078,
  0xfff5, 0xfff5, 0x0000, 0x0000, 0x0001, 0x000f, 0x0077, 0x0078,
  0xfff4, 0xfff4, 0x0000, 0x0000, 0x0001, 0x000f, 0x0077, 0x0078,
  0xfff3, 0xfff3, 0x0000, 0x0000, 0x0001, 0x000f, 0x0077, 0x0078,
  0xfff2, 0xfff2, 0x0000, 0x0000, 0x0001, 0x000f, 0x0077, 0x0078,
  0xfff1, 0xfff1, 0x0000, 0x0000, 0x0001, 0x000f, 0x0077, 0x0078,
  0xfff0, 0xfff0, 0x0000, 0x0000, 0x0001, 0x000f, 0x0077, 0x0078,
  0xffff, 0x0000, 0x0000, 0x0001, 0x0008, 0x003e, 0x003f, 0x003f,
  0xfffe, 0x0000, 0x0000, 0x0001, 0x000c, 0x005d, 0x005e, 0x005e,
  0xfffd, 0x0000, 0x0000, 0x0001, 0x000e, 0x006c, 0x006d, 0x006d,
  0xfffc, 0x0000, 0x0000, 0x0001, 0x000f, 0x0073, 0x0074, 0x0074,
  0xfffb, 0x0000, 0x0000, 0x0001, 0x000f, 0x0076, 0x0077, 0x0077,
  0xfffa, 0x0000, 0x0000, 0x0001, 0x000f, 0x0077, 0x0078, 0x0078,
  0xfff9, 0x0000, 0x0000, 0x0001, 0x000f, 0x0077, 0x0078, 0x0078,
  0xfff8, 0x0000, 0x0000, 0x0001, 0x000f, 0x0077, 0x0078, 0x0078,
  0xfff7, 0x0000, 0x0000, 0x0001, 0x000f, 0x0077, 0x0078, 0x0078,
  0xfff6, 0x0000, 0x0000, 0x0001, 0x000f, 0x0077, 0x0078, 0x0078,
  0xfff5, 0x0000, 0x0000, 0x0001, 0x000f, 0x0077, 0x0078, 0x0078,
  0xfff4, 0x0000, 0x0000, 0x0001, 0x000f, 0x0077, 0x0078, 0x0078,
  0xfff3, 0x0000, 0x0000, 0x0001, 0x000f, 0x0077, 0x0078, 0x0078,
  0xfff2, 0x0000, 0x0000, 0x0001, 0x000f, 0x0077, 0x0078, 0x0078,
  0xfff1, 0x0000, 0x0000, 0x0001, 0x000f, 0x0077, 0x0078, 0x0078,
  0xfff0, 0x0000, 0x0000, 0x0001, 0x000f, 0x0077, 0x0078, 0x0078,
  0x0000, 0x0000, 0x0001, 0x0008, 0x003e, 0x003f, 0x003f, 0x1999,
  0x0000, 0x0000, 0x0001, 0x000c, 0x005d, 0x005e, 0x005e, 0x2665,
  0x0000, 0x0000, 0x0001, 0x000e, 0x006c, 0x006d, 0x006d, 0x2ccb,
  0x0000, 0x0000, 0x0001, 0x000f, 0x0073, 0x0074, 0x0074, 0x2ffe,
  0x0000, 0x0000, 0x0001, 0x000f, 0x0076, 0x0077, 0x0077, 0x3197,
  0x0000, 0x0000, 0x0001, 0x000f, 0x0077, 0x0078, 0x0078, 0x3263,
  0x0000, 0x0000, 0x0001, 0x000f, 0x0077, 0x0078, 0x0078, 0x32c9,
  0x0000, 0x0000, 0x0001, 0x000f, 0x0077, 0x0078, 0x0078, 0x32fc,
  0x0000, 0x0000, 0x0001, 0x000f, 0x0077, 0x0078, 0x0078, 0x3315,
  0x0000, 0x0000, 0x0001, 0x000f, 0x0077, 0x0078, 0x0078, 0x3321,
  0x0000, 0x0000, 0x0001, 0x000f, 0x0077, 0x0078, 0x0078, 0x3327,
  0x0000, 0x0000, 0x0001, 0x000f, 0x0077, 0x0078, 0x0078, 0x332a,
  0x0000, 0x0000, 0x0001, 0x000f, 0x0077, 0x0078, 0x0078, 0x332b,
  0x0000, 0x0000, 0x0001, 0x000f, 0x0077, 0x0078, 0x0078, 0x332b,
  0x0000, 0x0000, 0x0001, 0x000f, 0x0077, 0x0078, 0x0078, 0x332b,
  0x0000, 0x0000, 0x0001, 0x000f, 0x0077, 0x0078, 0x0078, 0x332b,
  0x0000, 0x0001, 0x0008, 0x003e, 0x003f, 0x003f, 0x1999, 0x2aaa,
  0x0000, 0x0001, 0x000c, 0x005d, 0x005e, 0x005e, 0x2665, 0x3fff,
  0x0000, 0x0001, 0x000e, 0x006c, 0x006d, 0x006d, 0x2ccb, 0x4aa9,
  0x0000, 0x0001, 0x000f, 0x0073, 0x0074, 0x0074, 0x2ffe, 0x4ffe,
  0x0000, 0x0001, 0x000f, 0x0076, 0x0077, 0x0077, 0x3197, 0x52a8,
  0x0000, 0x0001, 0x000f, 0x0077, 0x0078, 0x0078, 0x3263, 0x53fd,
  0x0000, 0x0001, 0x000f, 0x0077, 0x0078, 0x0078, 0x32c9, 0x54a7,
  0x0000, 0x0001, 0x000f, 0x0077, 0x0078, 0x0078, 0x32fc, 0x54fc,
  0x0000, 0x0001, 0x000f, 0x0077, 0x0078, 0x0078, 0x3315, 0x5526,
  0x0000, 0x0001, 0x000f, 0x0077, 0x0078, 0x0078, 0x3321, 0x553b,
  0x0000, 0x0001, 0x000f, 0x0077, 0x0078, 0x0078, 0x3327, 0x5545,
  0x0000, 0x0001, 0x000f, 0x0077, 0x0078, 0x0078, 0x332a, 0x554a,
  0x0000, 0x0001, 0x000f, 0x0077, 0x0078, 0x0078, 0x332b, 0x554c,
  0x0000, 0x0001, 0x000f, 0x0077, 0x0078, 0x0078, 0x332b, 0x554d,
  0x0000, 0x0001, 0x000f, 0x0077, 0x0078, 0x0078, 0x332b, 0x554d,
  0x0000, 0x0001, 0x000f, 0x0077, 0x0078, 0x0078, 0x332b, 0x554d,
  0x0001, 0x0008, 0x003e, 0x003f, 0x003f, 0x1999, 0x2aaa, 0x3ffe,
  0x0001, 0x000c, 0x005d, 0x005e, 0x005e, 0x2665, 0x3fff, 0x5ffd,
  0x0001, 0x000e, 0x006c, 0x006d, 0x006d, 0x2ccb, 0x4aa9, 0x6ffc,
  0x0001, 0x000f, 0x0073, 0x0074, 0x0074, 0x2ffe, 0x4ffe, 0x77fb,
  0x0001, 0x000f, 0x0076, 0x0077, 0x0077, 0x3197, 0x52a8, 0x7bfa,
  0x0001, 0x000f, 0x0077, 0x0078, 0x0078, 0x3263, 0x53fd, 0x7df9,
  0x0001, 0x000f, 0x0077, 0x0078, 0x0078, 0x32c9, 0x54a7, 0x7ef8,
  0x0001, 0x000f, 0x0077, 0x0078, 0x0078, 0x32fc, 0x54fc, 0x7f77,
  0x0001, 0x000f, 0x0077, 0x0078, 0x0078, 0x3315, 0x5526, 0x7fb6,
  0x0001, 0x000f, 0x0077, 0x0078, 0x0078, 0x3321, 0x553b, 0x7fd5,
  0x0001, 0x000f, 0x0077, 0x0078, 0x0078, 0x3327, 0x5545, 0x7fe4,
  0x0001, 0x000f, 0x0077, 0x0078, 0x0078, 0x332a, 0x554a, 0x7feb,
  0x0001, 0x000f, 0x0077, 0x0078, 0x0078, 0x332b, 0x554c, 0x7fee,
  0x0001, 0x000f, 0x0077, 0x0078, 0x0078, 0x332b, 0x554d, 0x7fef,
  0x0001, 0x000f, 0x0077, 0x0078, 0x0078, 0x332b, 0x554d, 0x7fef,
  0x0001, 0x000f, 0x0077, 0x0078, 0x0078, 0x332b, 0x554d, 0x7fef,
  0x0008, 0x003e, 0x003f, 0x003f, 0x1999, 0x2aaa, 0x3ffe, 0x3fff,
  0x000c, 0x005d, 0x005e, 0x005e, 0x2665, 0x3fff, 0x5ffd, 0x5ffe,
  0x000e, 0x006c, 0x006d, 0x006d, 0x2ccb, 0x4aa9, 0x6ffc, 0x6ffd,
  0x000f, 0x0073, 0x0074, 0x0074, 0x2ffe, 0x4ffe, 0x77fb, 0x77fc,
  0x000f, 0x0076, 0x0077, 0x0077, 0x3197, 0x52a8, 0x7bfa, 0x7bfb,
  0x000f, 0x0077, 0x0078, 0x0078, 0x3263, 0x53fd, 0x7df9, 0x7dfa,
  0x000f, 0x0077, 0x0078, 0x0078, 0x32c9, 0x54a7, 0x7ef8, 0x7ef9,
  0x000f, 0x0077, 0x0078, 0x0078, 0x32fc, 0x54fc, 0x7f77, 0x7f78,
  0x000f, 0x0077, 0x0078, 0x0078, 0x3315, 0x5526, 0x7fb6, 0x7fb7,
  0x000f, 0x0077, 0x0078, 0x0078, 0x3321, 0x553b, 0x7fd5, 0x7fd6,
  0x000f, 0x0077, 0x0078, 0x0078, 0x3327, 0x5545, 0x7fe4, 0x7fe5,
  0x000f, 0x0077, 0x0078, 0x0078, 0x332a, 0x554a, 0x7feb, 0x7fec,
  0x000f, 0x0077, 0x0078, 0x0078, 0x332b, 0x554c, 0x7fee, 0x7fef,
  0x000f, 0x0077, 0x0078, 0x0078, 0x332b, 0x554d, 0x7fef, 0x7ff0,
  0x000f, 0x0077, 0x0078, 0x0078, 0x332b, 0x554d, 0x7fef, 0x7ff0,
  0x000f, 0x0077, 0x0078, 0x0078, 0x332b, 0x554d, 0x7fef, 0x7ff0,
  0x003e, 0x003f, 0x003f, 0x1999, 0x2aaa, 0x3ffe, 0x3fff, 0x3fff,
  0x005d, 0x005e, 0x005e, 0x2665, 0x3fff, 0x5ffd, 0x5ffe, 0x5ffe,
  0x006c, 0x006d, 0x006d, 0x2ccb, 0x4aa9, 0x6ffc, 0x6ffd, 0x6ffd,
  0x0073, 0x0074, 0x0074, 0x2ffe, 0x4ffe, 0x77fb, 0x77fc, 0x77fc,
  0x0076, 0x0077, 0x0077, 0x3197, 0x52a8, 0x7bfa, 0x7bfb, 0x7bfb,
  0x0077, 0x0078, 0x0078, 0x3263, 0x53fd, 0x7df9, 0x7dfa, 0x7dfa,
  0x0077, 0x0078, 0x0078, 0x32c9, 0x54a7, 0x7ef8, 0x7ef9, 0x7ef9,
  0x0077, 0x0078, 0x0078, 0x32fc, 0x54fc, 0x7f77, 0x7f78, 0x7f78,
  0x0077, 0x0078, 0x0078, 0x3315, 0x5526, 0x7fb6, 0x7fb7, 0x7fb7,
  0x0077, 0x0078, 0x0078, 0x3321, 0x553b, 0x7fd5, 0x7fd6, 0x7fd6,
  0x0077, 0x0078, 0x0078, 0x3327, 0x5545, 0x7fe4, 0x7fe5, 0x7fe5,
  0x0077, 0x0078, 0x0078, 0x332a, 0x554a, 0x7feb, 0x7fec, 0x7fec,
  0x0077, 0x0078, 0x0078, 0x332b, 0x554c, 0x7fee, 0x7fef, 0x7fef,
  0x0077, 0x0078, 0x0078, 0x332b, 0x554d, 0x7fef, 0x7ff0, 0x7ff0,
  0x0077, 0x0078, 0x0078, 0x332b, 0x554d, 0x7fef, 0x7ff0, 0x7ff0,
  0x0077, 0x0078, 0x0078, 0x332b, 0x554d, 0x7fef, 0x7ff0, 0x7ff0,
  0x003f, 0x003f, 0x1999, 0x2aaa, 0x3ffe, 0x3fff, 0x3fff, 0xc000,
  0x005e, 0x005e, 0x2665, 0x3fff, 0x5ffd, 0x5ffe, 0x5ffe, 0xa000,
  0x006d, 0x006d, 0x2ccb, 0x4aa9, 0x6ffc, 0x6ffd, 0x6ffd, 0x9000,
  0x0074, 0x0074, 0x2ffe, 0x4ffe, 0x77fb, 0x77fc, 0x77fc, 0x8800,
  0x0077, 0x0077, 0x3197, 0x52a8, 0x7bfa, 0x7bfb, 0x7bfb, 0x8400,
  0x0078, 0x0078, 0x3263, 0x53fd, 0x7df9, 0x7dfa, 0x7dfa, 0x8200,
  0x0078, 0x0078, 0x32c9, 0x54a7, 0x7ef8, 0x7ef9, 0x7ef9, 0x8100,
  0x0078, 0x0078, 0x32fc, 0x54fc, 0x7f77, 0x7f78, 0x7f78, 0x8080,
  0x0078, 0x0078, 0x3315, 0x5526, 0x7fb6, 0x7fb7, 0x7fb7, 0x8040,
  0x0078, 0x0078, 0x3321, 0x553b, 0x7fd5, 0x7fd6, 0x7fd6, 0x8020,
  0x0078, 0x0078, 0x3327, 0x5545, 0x7fe4, 0x7fe5, 0x7fe5, 0x8010,
  0x0078, 0x0078, 0x332a, 0x554a, 0x7feb, 0x7fec, 0x7fec, 0x8008,
  0x0078, 0x0078, 0x332b, 0x554c, 0x7fee, 0x7fef, 0x7fef, 0x8004,
  0x0078, 0x0078, 0x332b, 0x554d, 0x7fef, 0x7ff0, 0x7ff0, 0x8002,
  0x0078, 0x0078, 0x332b, 0x554d, 0x7fef, 0x7ff0, 0x7ff0, 0x8001,
  0x0078, 0x0078, 0x332b, 0x554d, 0x7fef, 0x7ff0, 0x7ff0, 0x8000,
  0x003f, 0x1999, 0x2aaa, 0x3ffe, 0x3fff, 0x3fff, 0xc000, 0xc000,
  0x005e, 0x2665, 0x3fff, 0x5ffd, 0x5ffe, 0x5ffe, 0xa000, 0xa000,
  0x006d, 0x2ccb, 0x4aa9, 0x6ffc, 0x6ffd, 0x6ffd, 0x9000, 0x9000,
  0x0074, 0x2ffe, 0x4ffe, 0x77fb, 0x77fc, 0x77fc, 0x8800, 0x8800,
  0x0077, 0x3197, 0x52a8, 0x7bfa, 0x7bfb, 0x7bfb, 0x8400, 0x8400,
  0x0078, 0x3263, 0x53fd, 0x7df9, 0x7dfa, 0x7dfa, 0x8200, 0x8200,
  0x0078, 0x32c9, 0x54a7, 0x7ef8, 0x7ef9, 0x7ef9, 0x8100, 0x8100,
  0x0078, 0x32fc, 0x54fc, 0x7f77, 0x7f78, 0x7f78, 0x8080, 0x8080,
  0x0078, 0x3315, 0x5526, 0x7fb6, 0x7fb7, 0x7fb7, 0x8040, 0x8040,
  0x0078, 0x3321, 0x553b, 0x7fd5, 0x7fd6, 0x7fd6, 0x8020, 0x8020,
  0x0078, 0x3327, 0x5545, 0x7fe4, 0x7fe5, 0x7fe5, 0x8010, 0x8010,
  0x0078, 0x332a, 0x554a, 0x7feb, 0x7fec, 0x7fec, 0x8008, 0x8008,
  0x0078, 0x332b, 0x554c, 0x7fee, 0x7fef, 0x7fef, 0x8004, 0x8004,
  0x0078, 0x332b, 0x554d, 0x7fef, 0x7ff0, 0x7ff0, 0x8002, 0x8002,
  0x0078, 0x332b, 0x554d, 0x7fef, 0x7ff0, 0x7ff0, 0x8001, 0x8001,
  0x0078, 0x332b, 0x554d, 0x7fef, 0x7ff0, 0x7ff0, 0x8000, 0x8000,
  0x1999, 0x2aaa, 0x3ffe, 0x3fff, 0x3fff, 0xc000, 0xc000, 0xd555,
  0x2665, 0x3fff, 0x5ffd, 0x5ffe, 0x5ffe, 0xa000, 0xa000, 0xbfff,
  0x2ccb, 0x4aa9, 0x6ffc, 0x6ffd, 0x6ffd, 0x9000, 0x9000, 0xb554,
  0x2ffe, 0x4ffe, 0x77fb, 0x77fc, 0x77fc, 0x8800, 0x8800, 0xaffe,
  0x3197, 0x52a8, 0x7bfa, 0x7bfb, 0x7bfb, 0x8400, 0x8400, 0xad53,
  0x3263, 0x53fd, 0x7df9, 0x7dfa, 0x7dfa, 0x8200, 0x8200, 0xabfd,
  0x32c9, 0x54a7, 0x7ef8, 0x7ef9, 0x7ef9, 0x8100, 0x8100, 0xab52,
  0x32fc, 0x54fc, 0x7f77, 0x7f78, 0x7f78, 0x8080, 0x8080, 0xaafc,
  0x3315, 0x5526, 0x7fb6, 0x7fb7, 0x7fb7, 0x8040, 0x8040, 0xaad1,
  0x3321, 0x553b, 0x7fd5, 0x7fd6, 0x7fd6, 0x8020, 0x8020, 0xaabb,
  0x3327, 0x5545, 0x7fe4, 0x7fe5, 0x7fe5, 0x8010, 0x8010, 0xaab0,
  0x332a, 0x554a, 0x7feb, 0x7fec, 0x7fec, 0x8008, 0x8008, 0xaaaa,
  0x332b, 0x554c, 0x7fee, 0x7fef, 0x7fef, 0x8004, 0x8004, 0xaaa7,
  0x332b, 0x554d, 0x7fef, 0x7ff0, 0x7ff0, 0x8002, 0x8002, 0xaaa5,
  0x332b, 0x554d, 0x7fef, 0x7ff0, 0x7ff0, 0x8001, 0x8001, 0xaaa4,
  0x332b, 0x554d, 0x7fef, 0x7ff0, 0x7ff0, 0x8000, 0x8000, 0xaaa3,
  0x2aaa, 0x3ffe, 0x3fff, 0x3fff, 0xc000, 0xc000, 0xd555, 0xe666,
  0x3fff, 0x5ffd, 0x5ffe, 0x5ffe, 0xa000, 0xa000, 0xbfff, 0xd999,
  0x4aa9, 0x6ffc, 0x6ffd, 0x6ffd, 0x9000, 0x9000, 0xb554, 0xd332,
  0x4ffe, 0x77fb, 0x77fc, 0x77fc, 0x8800, 0x8800, 0xaffe, 0xcffe,
  0x52a8, 0x7bfa, 0x7bfb, 0x7bfb, 0x8400, 0x8400, 0xad53, 0xce64,
  0x53fd, 0x7df9, 0x7dfa, 0x7dfa, 0x8200, 0x8200, 0xabfd, 0xcd97,
  0x54a7, 0x7ef8, 0x7ef9, 0x7ef9, 0x8100, 0x8100, 0xab52, 0xcd30,
  0x54fc, 0x7f77, 0x7f78, 0x7f78, 0x8080, 0x8080, 0xaafc, 0xccfc,
  0x5526, 0x7fb6, 0x7fb7, 0x7fb7, 0x8040, 0x8040, 0xaad1, 0xcce2,
  0x553b, 0x7fd5, 0x7fd6, 0x7fd6, 0x8020, 0x8020, 0xaabb, 0xccd5,
  0x5545, 0x7fe4, 0x7fe5, 0x7fe5, 0x8010, 0x8010, 0xaab0, 0xccce,
  0x554a, 0x7feb, 0x7fec, 0x7fec, 0x8008, 0x8008, 0xaaaa, 0xccca,
  0x554c, 0x7fee, 0x7fef, 0x7fef, 0x8004, 0x8004, 0xaaa7, 0xccc8,
  0x554d, 0x7fef, 0x7ff0, 0x7ff0, 0x8002, 0x8002, 0xaaa5, 0xccc7,
  0x554d, 0x7fef, 0x7ff0, 0x7ff0, 0x8001, 0x8001, 0xaaa4, 0xccc6,
  0x554d, 0x7fef, 0x7ff0, 0x7ff0, 0x8000, 0x8000, 0xaaa3, 0xccc5,
  0x3ffe, 0x3fff, 0x3fff, 0xc000, 0xc000, 0xd555, 0xe666, 0xffc0,
  0x5ffd, 0x5ffe, 0x5ffe, 0xa000, 0xa000, 0xbfff, 0xd999, 0xffa0,
  0x6ffc, 0x6ffd, 0x6ffd, 0x9000, 0x9000, 0xb554, 0xd332, 0xff90,
  0x77fb, 0x77fc, 0x77fc, 0x8800, 0x8800, 0xaffe, 0xcffe, 0xff88,
  0x7bfa, 0x7bfb, 0x7bfb, 0x8400, 0x8400, 0xad53, 0xce64, 0xff84,
  0x7df9, 0x7dfa, 0x7dfa, 0x8200, 0x8200, 0xabfd, 0xcd97, 0xff82,
  0x7ef8, 0x7ef9, 0x7ef9, 0x8100, 0x8100, 0xab52, 0xcd30, 0xff81,
  0x7f77, 0x7f78, 0x7f78, 0x8080, 0x8080, 0xaafc, 0xccfc, 0xff80,
  0x7fb6, 0x7fb7, 0x7fb7, 0x8040, 0x8040, 0xaad1, 0xcce2, 0xff7f,
  0x7fd5, 0x7fd6, 0x7fd6, 0x8020, 0x8020, 0xaabb, 0xccd5, 0xff7e,
  0x7fe4, 0x7fe5, 0x7fe5, 0x8010, 0x8010, 0xaab0, 0xccce, 0xff7d,
  0x7feb, 0x7fec, 0x7fec, 0x8008, 0x8008, 0xaaaa, 0xccca, 0xff7c,
  0x7fee, 0x7fef, 0x7fef, 0x8004, 0x8004, 0xaaa7, 0xccc8, 0xff7b,
  0x7fef, 0x7ff0, 0x7ff0, 0x8002, 0x8002, 0xaaa5, 0xccc7, 0xff7a,
  0x7fef, 0x7ff0, 0x7ff0, 0x8001, 0x8001, 0xaaa4, 0xccc6, 0xff79,
  0x7fef, 0x7ff0, 0x7ff0, 0x8000, 0x8000, 0xaaa3, 0xccc5, 0xff78,
  0x3fff, 0x3fff, 0xc000, 0xc000, 0xd555, 0xe666, 0xffc0, 0xffc0,
  0x5ffe, 0x5ffe, 0xa000, 0xa000, 0xbfff, 0xd999, 0xffa0, 0xffa0,
  0x6ffd, 0x6ffd, 0x9000, 0x9000, 0xb554, 0xd332, 0xff90, 0xff90,
  0x77fc, 0x77fc, 0x8800, 0x8800, 0xaffe, 0xcffe, 0xff88, 0xff88,
  0x7bfb, 0x7bfb, 0x8400, 0x8400, 0xad53, 0xce64, 0xff84, 0xff84,
  0x7dfa, 0x7dfa, 0x8200, 0x8200, 0xabfd, 0xcd97, 0xff82, 0xff82,
  0x7ef9, 0x7ef9, 0x8100, 0x8100, 0xab52, 0xcd30, 0xff81, 0xff81,
  0x7f78, 0x7f78, 0x8080, 0x8080, 0xaafc, 0xccfc, 0xff80, 0xff80,
  0x7fb7, 0x7fb7, 0x8040, 0x8040, 0xaad1, 0xcce2, 0xff7f, 0xff7f,
  0x7fd6, 0x7fd6, 0x8020, 0x8020, 0xaabb, 0xccd5, 0xff7e, 0xff7e,
  0x7fe5, 0x7fe5, 0x8010, 0x8010, 0xaab0, 0xccce, 0xff7d, 0xff7d,
  0x7fec, 0x7fec, 0x8008, 0x8008, 0xaaaa, 0xccca, 0xff7c, 0xff7c,
  0x7fef, 0x7fef, 0x8004, 0x8004, 0xaaa7, 0xccc8, 0xff7b, 0xff7b,
  0x7ff0, 0x7ff0, 0x8002, 0x8002, 0xaaa5, 0xccc7, 0xff7a, 0xff7a,
  0x7ff0, 0x7ff0, 0x8001, 0x8001, 0xaaa4, 0xccc6, 0xff79, 0xff79,
  0x7ff0, 0x7ff0, 0x8000, 0x8000, 0xaaa3, 0xccc5, 0xff78, 0xff78,
  0x3fff, 0xc000, 0xc000, 0xd555, 0xe666, 0xffc0, 0xffc0, 0xffc1,
  0x5ffe, 0xa000, 0xa000, 0xbfff, 0xd999, 0xffa0, 0xffa0, 0xffa1,
  0x6ffd, 0x9000, 0x9000, 0xb554, 0xd332, 0xff90, 0xff90, 0xff91,
  0x77fc, 0x8800, 0x8800, 0xaffe, 0xcffe, 0xff88, 0xff88, 0xff89,
  0x7bfb, 0x8400, 0x8400, 0xad53, 0xce64, 0xff84, 0xff84, 0xff85,
  0x7dfa, 0x8200, 0x8200, 0xabfd, 0xcd97, 0xff82, 0xff82, 0xff83,
  0x7ef9, 0x8100, 0x8100, 0xab52, 0xcd30, 0xff81, 0xff81, 0xff82,
  0x7f78, 0x8080, 0x8080, 0xaafc, 0xccfc, 0xff80, 0xff80, 0xff81,
  0x7fb7, 0x8040, 0x8040, 0xaad1, 0xcce2, 0xff7f, 0xff7f, 0xff80,
  0x7fd6, 0x8020, 0x8020, 0xaabb, 0xccd5, 0xff7e, 0xff7e, 0xff7f,
  0x7fe5, 0x8010, 0x8010, 0xaab0, 0xccce, 0xff7d, 0xff7d, 0xff7e,
  0x7fec, 0x8008, 0x8008, 0xaaaa, 0xccca, 0xff7c, 0xff7c, 0xff7d,
  0x7fef, 0x8004, 0x8004, 0xaaa7, 0xccc8, 0xff7b, 0xff7b, 0xff7c,
  0x7ff0, 0x8002, 0x8002, 0xaaa5, 0xccc7, 0xff7a, 0xff7a, 0xff7b,
  0x7ff0, 0x8001, 0x8001, 0xaaa4, 0xccc6, 0xff79, 0xff79, 0xff7a,
  0x7ff0, 0x8000, 0x8000, 0xaaa3, 0xccc5, 0xff78, 0xff78, 0xff79,
  0xc000, 0xc000, 0xd555, 0xe666, 0xffc0, 0xffc0, 0xffc1, 0xffc1,
  0xa000, 0xa000, 0xbfff, 0xd999, 0xffa0, 0xffa0, 0xffa1, 0xffa1,
  0x9000, 0x9000, 0xb554, 0xd332, 0xff90, 0xff90, 0xff91, 0xff91,
  0x8800, 0x8800, 0xaffe, 0xcffe, 0xff88, 0xff88, 0xff89, 0xff89,
  0x8400, 0x8400, 0xad53, 0xce64, 0xff84, 0xff84, 0xff85, 0xff85,
  0x8200, 0x8200, 0xabfd, 0xcd97, 0xff82, 0xff82, 0xff83, 0xff83,
  0x8100, 0x8100, 0xab52, 0xcd30, 0xff81, 0xff81, 0xff82, 0xff82,
  0x8080, 0x8080, 0xaafc, 0xccfc, 0xff80, 0xff80, 0xff81, 0xff81,
  0x8040, 0x8040, 0xaad1, 0xcce2, 0xff7f, 0xff7f, 0xff80, 0xff80,
  0x8020, 0x8020, 0xaabb, 0xccd5, 0xff7e, 0xff7e, 0xff7f, 0xff7f,
  0x8010, 0x8010, 0xaab0, 0xccce, 0xff7d, 0xff7d, 0xff7e, 0xff7e,
  0x8008, 0x8008, 0xaaaa, 0xccca, 0xff7c, 0xff7c, 0xff7d, 0xff7d,
  0x8004, 0x8004, 0xaaa7, 0xccc8, 0xff7b, 0xff7b, 0xff7c, 0xff7c,
  0x8002, 0x8002, 0xaaa5, 0xccc7, 0xff7a, 0xff7a, 0xff7b, 0xff7b,
  0x8001, 0x8001, 0xaaa4, 0xccc6, 0xff79, 0xff79, 0xff7a, 0xff7a,
  0x8000, 0x8000, 0xaaa3, 0xccc5, 0xff78, 0xff78, 0xff79, 0xff79,
  0xc000, 0xd555, 0xe666, 0xffc0, 0xffc0, 0xffc1, 0xffc1, 0xfff8,
  0xa000, 0xbfff, 0xd999, 0xffa0, 0xffa0, 0xffa1, 0xffa1, 0xfff4,
  0x9000, 0xb554, 0xd332, 0xff90, 0xff90, 0xff91, 0xff91, 0xfff2,
  0x8800, 0xaffe, 0xcffe, 0xff88, 0xff88, 0xff89, 0xff89, 0xfff1,
  0x8400, 0xad53, 0xce64, 0xff84, 0xff84, 0xff85, 0xff85, 0xfff0,
  0x8200, 0xabfd, 0xcd97, 0xff82, 0xff82, 0xff83, 0xff83, 0xffef,
  0x8100, 0xab52, 0xcd30, 0xff81, 0xff81, 0xff82, 0xff82, 0xffee,
  0x8080, 0xaafc, 0xccfc, 0xff80, 0xff80, 0xff81, 0xff81, 0xffed,
  0x8040, 0xaad1, 0xcce2, 0xff7f, 0xff7f, 0xff80, 0xff80, 0xffec,
  0x8020, 0xaabb, 0xccd5, 0xff7e, 0xff7e, 0xff7f, 0xff7f, 0xffeb,
  0x8010, 0xaab0, 0xccce, 0xff7d, 0xff7d, 0xff7e, 0xff7e, 0xffea,
  0x8008, 0xaaaa, 0xccca, 0xff7c, 0xff7c, 0xff7d, 0xff7d, 0xffe9,
  0x8004, 0xaaa7, 0xccc8, 0xff7b, 0xff7b, 0xff7c, 0xff7c, 0xffe8,
  0x8002, 0xaaa5, 0xccc7, 0xff7a, 0xff7a, 0xff7b, 0xff7b, 0xffe7,
  0x8001, 0xaaa4, 0xccc6, 0xff79, 0xff79, 0xff7a, 0xff7a, 0xffe6,
  0x8000, 0xaaa3, 0xccc5, 0xff78, 0xff78, 0xff79, 0xff79, 0xffe5,
  0xd555, 0xe666, 0xffc0, 0xffc0, 0xffc1, 0xffc1, 0xfff8, 0xfffe,
  0xbfff, 0xd999, 0xffa0, 0xffa0, 0xffa1, 0xffa1, 0xfff4, 0xfffd,
  0xb554, 0xd332, 0xff90, 0xff90, 0xff91, 0xff91, 0xfff2, 0xfffc,
  0xaffe, 0xcffe, 0xff88, 0xff88, 0xff89, 0xff89, 0xfff1, 0xfffb,
  0xad53, 0xce64, 0xff84, 0xff84, 0xff85, 0xff85, 0xfff0, 0xfffa,
  0xabfd, 0xcd97, 0xff82, 0xff82, 0xff83, 0xff83, 0xffef, 0xfff9,
  0xab52, 0xcd30, 0xff81, 0xff81, 0xff82, 0xff82, 0xffee, 0xfff8,
  0xaafc, 0xccfc, 0xff80, 0xff80, 0xff81, 0xff81, 0xffed, 0xfff7,
  0xaad1, 0xcce2, 0xff7f, 0xff7f, 0xff80, 0xff80, 0xffec, 0xfff6,
  0xaabb, 0xccd5, 0xff7e, 0xff7e, 0xff7f, 0xff7f, 0xffeb, 0xfff5,
  0xaab0, 0xccce, 0xff7d, 0xff7d, 0xff7e, 0xff7e, 0xffea, 0xfff4,
  0xaaaa, 0xccca, 0xff7c, 0xff7c, 0xff7d, 0xff7d, 0xffe9, 0xfff3,
  0xaaa7, 0xccc8, 0xff7b, 0xff7b, 0xff7c, 0xff7c, 0xffe8, 0xfff2,
  0xaaa5, 0xccc7, 0xff7a, 0xff7a, 0xff7b, 0xff7b, 0xffe7, 0xfff1,
  0xaaa4, 0xccc6, 0xff79, 0xff79, 0xff7a, 0xff7a, 0xffe6, 0xfff0,
  0xaaa3, 0xccc5, 0xff78, 0xff78, 0xff79, 0xff79, 0xffe5, 0xffef,
  0xe666, 0xffc0, 0xffc0, 0xffc1, 0xffc1, 0xfff8, 0xfffe, 0xffff,
  0xd999, 0xffa0, 0xffa0, 0xffa1, 0xffa1, 0xfff4, 0xfffd, 0xfffe,
  0xd332, 0xff90, 0xff90, 0xff91, 0xff91, 0xfff2, 0xfffc, 0xfffd,
  0xcffe, 0xff88, 0xff88, 0xff89, 0xff89, 0xfff1, 0xfffb, 0xfffc,
  0xce64, 0xff84, 0xff84, 0xff85, 0xff85, 0xfff0, 0xfffa, 0xfffb,
  0xcd97, 0xff82, 0xff82, 0xff83, 0xff83, 0xffef, 0xfff9, 0xfffa,
  0xcd30, 0xff81, 0xff81, 0xff82, 0xff82, 0xffee, 0xfff8, 0xfff9,
  0xccfc, 0xff80, 0xff80, 0xff81, 0xff81, 0xffed, 0xfff7, 0xfff8,
  0xcce2, 0xff7f, 0xff7f, 0xff80, 0xff80, 0xffec, 0xfff6, 0xfff7,
  0xccd5, 0xff7e, 0xff7e, 0xff7f, 0xff7f, 0xffeb, 0xfff5, 0xfff6,
  0xccce, 0xff7d, 0xff7d, 0xff7e, 0xff7e, 0xffea, 0xfff4, 0xfff5,
  0xccca, 0xff7c, 0xff7c, 0xff7d, 0xff7d, 0xffe9, 0xfff3, 0xfff4,
  0xccc8, 0xff7b, 0xff7b, 0xff7c, 0xff7c, 0xffe8, 0xfff2, 0xfff3,
  0xccc7, 0xff7a, 0xff7a, 0xff7b, 0xff7b, 0xffe7, 0xfff1, 0xfff2,
  0xccc6, 0xff79, 0xff79, 0xff7a, 0xff7a, 0xffe6, 0xfff0, 0xfff1,
  0xccc5, 0xff78, 0xff78, 0xff79, 0xff79, 0xffe5, 0xffef, 0xfff0,
  0xffc0, 0xffc0, 0xffc1, 0xffc1, 0xfff8, 0xfffe, 0xffff, 0xffff,
  0xffa0, 0xffa0, 0xffa1, 0xffa1, 0xfff4, 0xfffd, 0xfffe, 0xfffe,
  0xff90, 0xff90, 0xff91, 0xff91, 0xfff2, 0xfffc, 0xfffd, 0xfffd,
  0xff88, 0xff88, 0xff89, 0xff89, 0xfff1, 0xfffb, 0xfffc, 0xfffc,
  0xff84, 0xff84, 0xff85, 0xff85, 0xfff0, 0xfffa, 0xfffb, 0xfffb,
  0xff82, 0xff82, 0xff83, 0xff83, 0xffef, 0xfff9, 0xfffa, 0xfffa,
  0xff81, 0xff81, 0xff82, 0xff82, 0xffee, 0xfff8, 0xfff9, 0xfff9,
  0xff80, 0xff80, 0xff81, 0xff81, 0xffed, 0xfff7, 0xfff8, 0xfff8,
  0xff7f, 0xff7f, 0xff80, 0xff80, 0xffec, 0xfff6, 0xfff7, 0xfff7,
  0xff7e, 0xff7e, 0xff7f, 0xff7f, 0xffeb, 0xfff5, 0xfff6, 0xfff6,
  0xff7d, 0xff7d, 0xff7e, 0xff7e, 0xffea, 0xfff4, 0xfff5, 0xfff5,
  0xff7c, 0xff7c, 0xff7d, 0xff7d, 0xffe9, 0xfff3, 0xfff4, 0xfff4,
  0xff7b, 0xff7b, 0xff7c, 0xff7c, 0xffe8, 0xfff2, 0xfff3, 0xfff3,
  0xff7a, 0xff7a, 0xff7b, 0xff7b, 0xffe7, 0xfff1, 0xfff2, 0xfff2,
  0xff79, 0xff79, 0xff7a, 0xff7a, 0xffe6, 0xfff0, 0xfff1, 0xfff1,
  0xff78, 0xff78, 0xff79, 0xff79, 0xffe5, 0xffef, 0xfff0, 0xfff0,
};
const unsigned kExpectedCount_NEON_ssra_8H_2OPIMM = 384;

#endif  // VIXL_SIM_SSRA_8H_2OPIMM_TRACE_AARCH64_H_
