.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.TH NOUVEAU __drivermansuffix__ __vendorversion__
.SH NAME
nouveau \- NVIDIA video driver
.SH SYNOPSIS
.nf
.B "Section \*qDevice\*q"
.BI "  Identifier \*q"  devname \*q
.B  "  Driver \*qnouveau\*q"
\ \ ...
.B EndSection
.fi
.SH DESCRIPTION
.B nouveau
is an __xservername__ driver for NVIDIA video cards.  The driver supports 2D
acceleration and provides support for the following framebuffer depths:
(15,) 16  and 24.  TrueColor visuals are supported for these depths.

.SH SUPPORTED HARDWARE
The
.B nouveau
driver supports PCI, PCI-Express and AGP video cards based on the following NVIDIA chips:
.TP 22
.B RIVA TNT
NV4
.TP 22
.B RIVA TNT2
NV5
.TP 22
.B GeForce 256, QUADRO
NV10
.TP 22
.B GeForce2, QUADRO2
NV11 & NV15
.TP 22
.B GeForce3, QUADRO DCC
NV20
.TP 22
.B nForce, nForce2
NV1A, NV1F
.TP 22
.B GeForce4, QUADRO4
NV17, NV18, NV25, NV28
.TP 22
.B GeForce FX, QUADRO FX
NV30, NV31, NV34, NV35, NV36, NV37, NV38
.TP 22
.B GeForce 6XXX
NV40, NV41, NV43, NV44, NV45, C51, MCP61
.TP 22
.B GeForce 7XXX
G70, G71, G72, G73, MCP67, MCP68, MCP73
.TP 22
.B GeForce 8XXX, 9XXX, 2XX, 3XX
G80, G84, G86, G92, G94, G96, G98, G200, GT215, GT216, GT218, MCP77,
MCP79, MCP89
.TP 22
.B GeForce 4XX, 5XX
GF100, GF104, GF106, GF108, GF110, GF114, GF116, GF117, GF119
.TP 22
.B GeForce 6XX, 7XX
GK104, GK106, GK107, GK110, GK208
.TP 22
.B GeForce GTX 750
GM107, GM108
.TP 22
.B GeForce GTX 9XX
GM200, GM204, GM206
.TP 22
.B GeForce GTX 10XX
GP102, GP104, GP106, GP107, GP108

.SH CONFIGURATION DETAILS
Please refer to __xconfigfile__(__filemansuffix__) for general configuration
details.  This section only covers configuration details specific to this
driver.
.PP
The driver auto-detects the chipset type and the amount of video memory
present for all chips.
.PP
The following driver
.B Options
are supported:
.TP
.BI "Option \*qHWCursor\*q \*q" boolean \*q
Enable or disable the HW cursor.  Default: on.
.TP
.BI "Option \*qAccelMethod\*q \*q" string \*q
Specify the acceleration method. One of \*qnone\*q, or \*qexa\*q. Default: exa.
.TP
.BI "Option \*qNoAccel\*q \*q" boolean \*q
Disable or enable acceleration.  Default: acceleration is enabled.
.TP
.BI "Option \*qShadowFB\*q \*q" boolean \*q
Enable or disable use of the shadow framebuffer layer.  Default: off.
.TP
.BI "Option \*qWrappedFB\*q \*q" boolean \*q
Enable or disable wfb, only affects nv50+. Useful for some legacy configurations where high rendering latency is perceived.  Default: wfb is disabled.
.TP
.BI "Option \*qGLXVBlank\*q \*q" boolean \*q
Synchronize GLX clients to VBlank. Useful where tearing is a problem,
harmful if the GPU isn't fast enough to keep up with the monitor
refresh rate. Default: on.
.TP
.BI "Option \*qZaphodHeads\*q \*q" string \*q
Specify the randr output(s) to use with zaphod mode for a particular driver
instance.  If you use this option you most use this option for all instances
of the driver.
.br
For example:
.B
Option \*qZaphodHeads\*q \*qLVDS,VGA-0\*q
will assign xrandr outputs LVDS and VGA-0 to this instance of the driver.
.TP
.BI "Option \*qPageFlip\*q \*q" boolean \*q
Enable DRI2 page flipping. Default: on.
.TP
.BI "Option \*qSwapLimit\*q \*q" integer \*q
Set maximum allowed number of pending OpenGL double-buffer swaps for
a drawable before a client is blocked.
.br
A value of 1 corresponds to double-buffering. A value of 2 corresponds
to triple-buffering. Higher values may allow higher framerate, but also
increase lag for interactive applications, e.g., games. Nouveau currently
reliably supports a maximum value of 2 on XOrg 1.12+. A maximum setting of 2
on older x-servers is allowed, but it will break conformance with the
OpenML OML_sync_control specification and will cause failure of software
that relies on correct presentation timing behaviour as defined in that
specification.
.br
Default: 1.
.TP
.BI "Option \*qDRI\*q \*q" integer \*q
Define the maximum level of DRI to enable. Valid values are 2 or 3.
exa acceleration will honor the maximum level if it is supported.
Default: 2.
.SH "SEE ALSO"
__xservername__(__appmansuffix__), __xconfigfile__(__filemansuffix__), Xserver(__appmansuffix__), X(__miscmansuffix__)
.SH AUTHORS
Authors include: David McKay, Jarno Paananen, Chas Inman, Dave Schmenk, 
Mark Vojkovich
.SH COPYRIGHT
.LP
NOTICE TO USER:   The source code  is copyrighted under  U.S. and
international laws.  Users and possessors of this source code are
hereby granted a nonexclusive,  royalty-free copyright license to
use this code in individual and commercial software.
.LP
Any use of this source code must include,  in the user documentation and
internal comments to the code,  notices to the end user as follows:
.LP
Copyright 1993-2003 NVIDIA, Corporation.  All rights reserved.
.LP
NVIDIA, CORPORATION MAKES NO REPRESENTATION ABOUT THE SUITABILITY
OF  THIS SOURCE  CODE  FOR ANY PURPOSE.  IT IS  PROVIDED  "AS IS"
WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.  NVIDIA, CORPORATION 
DISCLAIMS ALL WARRANTIES  WITH REGARD  TO THIS SOURCE CODE,
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY, NONINFRINGEMENT,  
AND FITNESS  FOR A PARTICULAR PURPOSE.   IN NO EVENT SHALL
NVIDIA, CORPORATION  BE LIABLE FOR ANY SPECIAL,  INDIRECT,  INCIDENTAL, 
OR CONSEQUENTIAL DAMAGES,  OR ANY DAMAGES  WHATSOEVER RESULTING FROM 
LOSS OF USE,  DATA OR PROFITS,  WHETHER IN AN ACTION
OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,  ARISING OUT OF
OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOURCE CODE.
.LP
U.S. Government  End  Users.   This source code  is a "commercial
item,"  as that  term is  defined at  48 C.F.R. 2.101 (OCT 1995),
consisting  of "commercial  computer  software"  and  "commercial
computer  software  documentation,"  as such  terms  are  used in
48 C.F.R. 12.212 (SEPT 1995)  and is provided to the U.S. Government 
only as  a commercial end item.   Consistent with  48 C.F.R.
12.212 and  48 C.F.R. 227.7202-1 through  227.7202-4 (JUNE 1995),
all U.S. Government End Users  acquire the source code  with only
those rights set forth herein.                                   

