package WSNotification::Types::NotificationMessageHolderType;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(0);

sub get_xmlns { 'http://docs.oasis-open.org/wsn/b-2' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %SubscriptionReference_of :ATTR(:get<SubscriptionReference>);
my %Topic_of :ATTR(:get<Topic>);
my %ProducerReference_of :ATTR(:get<ProducerReference>);
my %Message_of :ATTR(:get<Message>);

__PACKAGE__->_factory(
    [ qw(        SubscriptionReference
        Topic
        ProducerReference
        Message

    ) ],
    {
        'SubscriptionReference' => \%SubscriptionReference_of,
        'Topic' => \%Topic_of,
        'ProducerReference' => \%ProducerReference_of,
        'Message' => \%Message_of,
    },
    {
        'SubscriptionReference' => 'WSNotification::Elements::SubscriptionReference',

        'Topic' => 'WSNotification::Elements::Topic',

        'ProducerReference' => 'WSNotification::Elements::ProducerReference',


        'Message' => 'WSNotification::Types::NotificationMessageHolderType::_Message',
    },
    {

        'SubscriptionReference' => '',
        'Topic' => '',
        'ProducerReference' => '',
        'Message' => 'Message',
    }
);

} # end BLOCK




package WSNotification::Types::NotificationMessageHolderType::_Message;
use strict;
use warnings;
{
our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables


__PACKAGE__->_factory(
    [ qw(
    ) ],
    {
    },
    {
    },
    {

    }
);

} # end BLOCK







}







1;


=pod

=head1 NAME

WSNotification::Types::NotificationMessageHolderType

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
NotificationMessageHolderType from the namespace http://docs.oasis-open.org/wsn/b-2.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * SubscriptionReference

Note: The name of this property has been altered, because it didn't match
perl's notion of variable/subroutine names. The altered name is used in
perl code only, XML output uses the original name:

 


=item * Topic

Note: The name of this property has been altered, because it didn't match
perl's notion of variable/subroutine names. The altered name is used in
perl code only, XML output uses the original name:

 


=item * ProducerReference

Note: The name of this property has been altered, because it didn't match
perl's notion of variable/subroutine names. The altered name is used in
perl code only, XML output uses the original name:

 


=item * Message




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # WSNotification::Types::NotificationMessageHolderType
   SubscriptionReference =>  { # WSNotification::Types::EndpointReferenceType
     Address =>  { value => $some_value },
     ReferenceParameters =>  { # WSNotification::Types::ReferenceParametersType
     },
     Metadata =>  { # WSNotification::Types::MetadataType
     },
   },
   Topic =>  { # WSNotification::Types::TopicExpressionType
   },
   ProducerReference =>  { # WSNotification::Types::EndpointReferenceType
     Address =>  { value => $some_value },
     ReferenceParameters =>  { # WSNotification::Types::ReferenceParametersType
     },
     Metadata =>  { # WSNotification::Types::MetadataType
     },
   },
   Message =>  {
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

